/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.property;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.PropertyWriter;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.DeleteUtils;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.editor.experimentdesigner.config.ImageRegistry;
import org.grits.toolbox.editor.experimentdesigner.io.ExperimentPropertyWriter;
import org.grits.toolbox.entry.sample.property.SampleProperty;

public class ExperimentProperty
extends Property {
    private static final Logger logger = Logger.getLogger(ExperimentProperty.class);
    public static final String TYPE = "org.grits.toolbox.property.experiment";
    protected static ImageDescriptor imageDescriptor = ImageRegistry.getImageDescriptor(ImageRegistry.ExperimentDesignerImage.EXPERIMENTDESIGNICON);
    protected static PropertyWriter writer = new ExperimentPropertyWriter();

    public PropertyDataFile getExperimentFile() {
        PropertyDataFile experimentFile = null;
        for (PropertyDataFile dataFile : this.dataFiles) {
            if (!"default".equals(dataFile.getType())) continue;
            experimentFile = dataFile;
            break;
        }
        return experimentFile;
    }

    public String getType() {
        return TYPE;
    }

    public PropertyWriter getWriter() {
        return writer;
    }

    public ImageDescriptor getImage() {
        return imageDescriptor;
    }

    public void delete(Entry entry) {
        String fileLocation = String.valueOf(ExperimentProperty.getExperimentDesignLocation(entry)) + File.separator + this.getExperimentFile().getName();
        try {
            DeleteUtils.delete((File)new File(fileLocation));
        }
        catch (IOException e) {
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot delete experiment design", (Exception)e);
            logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot delete experiment design", (Throwable)e);
        }
    }

    public Object clone() {
        return null;
    }

    public Property getParentProperty() {
        return null;
    }

    public static String getExperimentDesignLocation(Entry entry) {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project").getDisplayName();
        String experimentGroupFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "experiments";
        return experimentGroupFolderLocation;
    }

    public void makeACopy(Entry currentEntry, Entry destinationEntry) throws IOException {
        try {
            File destinationFolder;
            File currentExperimentFile = new File(ExperimentProperty.getExperimentDesignLocation(currentEntry), this.getExperimentFile().getName());
            if (currentExperimentFile.exists()) {
                destinationFolder = new File(ExperimentProperty.getExperimentDesignLocation(destinationEntry.getParent()));
                if (!destinationFolder.exists() || !destinationFolder.isDirectory()) {
                    destinationFolder.mkdir();
                }
            } else {
                throw new FileNotFoundException("Could not find experiment design file for selected experiment design \"" + currentEntry.getDisplayName() + "\" in project \"" + DataModelSearch.findParentByType((Entry)currentEntry, (String)"org.grits.toolbox.property.project").getDisplayName() + "\"");
            }
            String sampleFileName = ((SampleProperty)destinationEntry.getParent().getProperty()).getSampleFile().getName();
            File destinationFile = new File(destinationFolder, sampleFileName.replace("sample", "experiment"));
            Files.copy(currentExperimentFile.toPath(), destinationFile.toPath(), new CopyOption[0]);
            ArrayList<PropertyDataFile> dataFiles = new ArrayList<PropertyDataFile>();
            PropertyDataFile currentDataFile = this.getExperimentFile();
            dataFiles.add(new PropertyDataFile(destinationFile.getName(), currentDataFile.getVersion(), currentDataFile.getType()));
            ExperimentProperty experimentProperty = new ExperimentProperty();
            experimentProperty.setDataFiles(dataFiles);
            experimentProperty.setRemoved(!this.exists());
            experimentProperty.setVersion(this.getVersion());
            experimentProperty.setViewerRank(this.getViewerRank());
            destinationEntry.setProperty((Property)experimentProperty);
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new IOException("Error copying experiment design information.\n" + ex.getMessage(), ex);
        }
    }
}

