/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.projectexplorer.handler;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.editor.EditorHandler;
import org.grits.toolbox.core.service.IGritsUIService;

public class ViewSelectedHandler {
    private static final Logger logger = Logger.getLogger(ViewSelectedHandler.class);
    public static final String COMMAND_ID = "org.grits.toolbox.core.command.projectexplorer.entry.view";
    @Inject
    private MApplication application;

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") Entry selectedEntry, @Named(value="e4ActivePart") MPart projectExplorerPart, EModelService modelService, IGritsUIService gritsUIService) {
        if ("org.grits.toolbox.core.part.projectexplorer".equals(projectExplorerPart.getElementId()) && selectedEntry != null) {
            logger.info((Object)("opening entry " + selectedEntry.getDisplayName()));
            if (gritsUIService.openEntryInPart(selectedEntry) == null) {
                logger.info((Object)("No e4 part could be found to display this entry type : " + selectedEntry.getProperty().getType() + "\n Switching to compatibility perspective"));
                MPerspective compatEditorPersp = (MPerspective)modelService.find("org.grits.toolbox.core.perspective.projectexplorer", (MUIElement)this.application);
                if (compatEditorPersp != null) {
                    gritsUIService.selectPerspective("org.grits.toolbox.core.perspective.projectexplorer");
                } else {
                    gritsUIService.selectPerspective("org.grits.toolbox.core.perspective.projectexplorer.<Default Perspective>");
                }
                logger.info((Object)"Using 3.x way to handle opening the entry");
                this.handleOldStuff(selectedEntry);
            }
        }
    }

    private void handleOldStuff(Entry selectedEntry) {
        EditorHandler.openEditorForEntry(selectedEntry);
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") Object object) {
        return object instanceof Entry;
    }
}

