/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions.sort;

import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions.sort.ArchivedFileViewerComparator;

public class SortFileNames
extends Action {
    private Logger logger = Logger.getLogger(SortFileNames.class);
    protected TreeViewer treeViewer = null;

    public SortFileNames(TreeViewer treeViewer) {
        super.setToolTipText("Sort in Alphanumeric Ascending order");
        this.treeViewer = treeViewer;
        treeViewer.getTree().setSortColumn(treeViewer.getTree().getColumn(0));
        boolean ascending = treeViewer.getTree().getSortDirection() == 128;
        this.setAscendingDescendingIcon(ascending);
        int direction = ascending ? 128 : 1024;
        treeViewer.getTree().setSortDirection(direction);
    }

    public void setAscendingDescendingIcon(boolean ascending) {
        if (ascending) {
            super.setImageDescriptor(ImageShare.SORT_ICON_ASCEND);
        } else {
            super.setImageDescriptor(ImageShare.SORT_ICON_DESCEND);
        }
    }

    public void run() {
        this.logger.debug((Object)"Start - Sorting left side table of Archive Entry Editor");
        ArchivedFileViewerComparator archivedFileViewerComparator = (ArchivedFileViewerComparator)this.treeViewer.getComparator();
        boolean ascending = this.treeViewer.getTree().getSortDirection() == 128;
        int newDirection = ascending ? 1024 : 128;
        this.treeViewer.getTree().setSortDirection(newDirection);
        this.treeViewer.getTree().setSortColumn(this.treeViewer.getTree().getColumn(0));
        this.setAscendingDescendingIcon(ascending);
        archivedFileViewerComparator.setColumn(0);
        archivedFileViewerComparator.setAscending(!ascending);
        this.treeViewer.refresh();
        this.logger.debug((Object)"End - Sorting left side table of Archive Entry Editor");
    }
}

