/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.JavaTrayIcon;
import com.sun.deploy.ui.JavaTrayIconController;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class MacJavaTrayIcon
extends JavaTrayIcon {
    private static final String JAVA_HOME_LINK = "http://www.java.com";
    private static final int GOTO_JAVA = 1;
    private static final int ABOUT_JAVA = 2;
    private static final int OPEN_JAVA_PREFS = 3;
    private static final int TOGGLE_CONSOLE_WINDOW = 4;
    private static final String JAVA_VERSION;
    private long mMenuHandle;

    protected MacJavaTrayIcon(JavaTrayIconController javaTrayIconController) {
        super(javaTrayIconController);
    }

    protected void installImpl() {
        this.dispose();
        this.mMenuHandle = this.nativeCreateMenu();
        this.nativeAddMenuItem(this.mMenuHandle, 2, MacJavaTrayIcon.getMessage("systray.about.java"));
        this.nativeAddMenuItem(this.mMenuHandle, 1, MacJavaTrayIcon.getMessage("systray.goto.java"));
        this.nativeAddMenuItem(this.mMenuHandle, 0, null);
        String string = Config.getStringProperty("deployment.console.startup.mode").equalsIgnoreCase("SHOW") ? this.getToggleLabel(true) : this.getToggleLabel(false);
        this.nativeAddMenuItem(this.mMenuHandle, 4, string);
        this.nativeAddMenuItem(this.mMenuHandle, 3, MacJavaTrayIcon.getMessage("systray.open.controlpanel"));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                MacJavaTrayIcon.this.dispose();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyConsoleClosedImpl() {
        MacJavaTrayIcon macJavaTrayIcon = this;
        synchronized (macJavaTrayIcon) {
            String string = this.getToggleLabel(false);
            this.nativeUpdateMenuItem(this.mMenuHandle, 4, string);
        }
    }

    private void dispose() {
        if (this.mMenuHandle == 0L) {
            return;
        }
        this.nativeDisposeMenu(this.mMenuHandle);
        this.mMenuHandle = 0L;
    }

    private void handleCommand(final int n) {
        new Thread(new Runnable(){

            public void run() {
                switch (n) {
                    case 4: {
                        boolean bl = !MacJavaTrayIcon.this.controller.isJavaConsoleVisible();
                        MacJavaTrayIcon.this.controller.showJavaConsole(bl);
                        MacJavaTrayIcon.this.nativeUpdateMenuItem(MacJavaTrayIcon.this.mMenuHandle, n, MacJavaTrayIcon.this.getToggleLabel(bl));
                        break;
                    }
                    case 3: {
                        MacJavaTrayIcon.this.nativeOpenControlPanel();
                        break;
                    }
                    case 2: {
                        ToolkitStore.getUI().showAboutJavaDialog();
                        break;
                    }
                    case 1: {
                        Platform.get().showDocument(MacJavaTrayIcon.JAVA_HOME_LINK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown command: " + n);
                    }
                }
            }
        }).start();
    }

    private String getToggleLabel(boolean bl) {
        if (bl) {
            return MacJavaTrayIcon.getMessage("systray.hide.console", new String[]{JAVA_VERSION});
        }
        return MacJavaTrayIcon.getMessage("systray.open.console", new String[]{JAVA_VERSION});
    }

    private static String getMessage(String string) {
        return MacJavaTrayIcon.getMessage(string, null);
    }

    private static String getMessage(String string, Object[] objectArray) {
        String string2 = objectArray == null ? ResourceManager.getMessage(string) : ResourceManager.getFormattedMessage(string, objectArray);
        return string2.replace("&", "");
    }

    private native long nativeCreateMenu();

    private native void nativeAddMenuItem(long var1, int var3, String var4);

    private native void nativeUpdateMenuItem(long var1, int var3, String var4);

    private native void nativeDisposeMenu(long var1);

    private native void nativeOpenControlPanel();

    static {
        Platform.get().loadDeployNativeLib();
        JAVA_VERSION = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.version");
            }
        });
    }
}

