/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.GWSParser;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class CoreType {
    protected String name;
    protected String superclass;
    protected String structure;
    protected String description;

    public CoreType(String init) throws Exception {
        Vector<String> tokens = TextUtils.tokenize(init, "\t");
        if (tokens.size() != 4) {
            throw new Exception("Invalid string format: " + init);
        }
        this.name = tokens.elementAt(0);
        this.superclass = tokens.elementAt(1);
        this.structure = tokens.elementAt(2);
        this.description = tokens.elementAt(3);
    }

    public String getName() {
        return this.name;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public String getStructure() {
        return this.structure;
    }

    public String getDescription() {
        return this.description;
    }

    public Residue newCore() throws Exception {
        new GWSParser();
        return GWSParser.readSubtree(this.structure, false);
    }
}

