/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.KCF;

import java.util.ArrayList;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseTypeDictionary;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SubstituentInterface;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACNotationParser;
import org.glycoinfo.GlycanFormatconverter.io.KCF.IUPACAglyconDescriptor;
import org.glycoinfo.GlycanFormatconverter.io.KCF.KCFNotationToIUPACNotation;
import org.glycoinfo.GlycanFormatconverter.io.KCF.KCFUtility;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.BaseStereoIndex;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameException;
import org.glycoinfo.GlycanFormatconverter.util.analyzer.MonosaccharideNotationAnalyzer;

public class KCFNodeConverter {
    private KCFUtility kcfUtil;

    KCFNodeConverter(KCFUtility _kcfUtil) {
        this.kcfUtil = _kcfUtil;
    }

    public Node start(String _node) throws GlycanException, GlyCoImporterException, TrivialNameException {
        ArrayList<String> units = this.kcfUtil.splitNotation(_node);
        String notation = units.get(1);
        IUPACAglyconDescriptor currentAglycon = IUPACAglyconDescriptor.forNotation(notation);
        if (units.get(0).equals("1") && currentAglycon != null) {
            return null;
        }
        if (units.get(0).equals("2") && currentAglycon != null) {
            String parentNotation = this.kcfUtil.splitNotation(this.kcfUtil.getNodeByID("1")).get(1);
            IUPACAglyconDescriptor parentAglycon = IUPACAglyconDescriptor.forNotation(parentNotation);
            if (parentAglycon == null && !currentAglycon.equals((Object)IUPACAglyconDescriptor.PHOSPHATE)) {
                return null;
            }
            if (parentAglycon != null) {
                return null;
            }
        }
        if (units.get(1).equals("*")) {
            return null;
        }
        if (this.isLinkageSubstituents(_node)) {
            return null;
        }
        Node node = this.makeSubstituent(_node);
        if (node == null) {
            KCFNotationToIUPACNotation kcf2iupac = new KCFNotationToIUPACNotation();
            IUPACNotationParser inp = new IUPACNotationParser();
            node = inp.parseMonosaccharide(kcf2iupac.start(notation));
            this.modifyMonosaccharide(node);
            this.modifyHeadAtom(node);
        }
        return node;
    }

    private Node makeSubstituent(String _notation) throws GlycanException {
        String unit = this.modifyNotation(this.kcfUtil.splitNotation(_notation).get(1));
        if (!this.isSubstituent(unit)) {
            return null;
        }
        Node ret = null;
        if (this.haveChild(_notation)) {
            if (this.isPyrophosphate(_notation)) {
                if (this.isCrossLinkedSubstituent(_notation)) {
                    return this.makeSubstituentNotation(BaseCrossLinkedTemplate.PYROPHOSPHATE);
                }
                return this.makeSubstituentNotation(BaseSubstituentTemplate.PYROPHOSPHATE);
            }
            if (this.isPhosphoEthanolamine(_notation)) {
                if (this.isCrossLinkedSubstituent(_notation)) {
                    return this.makeSubstituentNotation(BaseCrossLinkedTemplate.PHOSPHO_ETHANOLAMINE);
                }
                return this.makeSubstituentNotation(BaseSubstituentTemplate.PHOSPHOETHANOLAMINE);
            }
            if (unit.equals("P")) {
                if (this.isCrossLinkedSubstituent(_notation)) {
                    return this.makeSubstituentNotation(BaseCrossLinkedTemplate.PHOSPHATE);
                }
                return this.makeSubstituentNotation(BaseSubstituentTemplate.PHOSPHATE);
            }
        } else {
            return this.makeSubstituentNotation(BaseSubstituentTemplate.forIUPACNotationWithIgnore(unit));
        }
        return ret;
    }

    private boolean isSubstituent(String _notation) {
        BaseCrossLinkedTemplate crossT = BaseCrossLinkedTemplate.forIUPACNotationWithIgnore(_notation);
        BaseSubstituentTemplate subT = BaseSubstituentTemplate.forIUPACNotationWithIgnore(_notation);
        return crossT != null || subT != null;
    }

    private Node modifyMonosaccharide(Node _node) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_node;
        if (mono.getStereos().size() > 1 || mono.getStereos().isEmpty()) {
            return _node;
        }
        BaseTypeDictionary baseDict = BaseTypeDictionary.forName(mono.getStereos().getFirst());
        String tempStereo = mono.getStereos().getFirst();
        StringBuilder skeletonCode = new StringBuilder(baseDict.getStereoCode());
        BaseStereoIndex bsi = BaseStereoIndex.forCode(baseDict.getCoreName());
        if (bsi.getSize() != mono.getSuperClass().getSize()) {
            return _node;
        }
        for (GlyCoModification gMod : mono.getModifications()) {
            if (gMod.getPositionOne().intValue() == mono.getAnomericPosition() || gMod.getPositionOne().intValue() == mono.getSuperClass().getSize()) continue;
            skeletonCode.replace(gMod.getPositionOne() - 2, gMod.getPositionOne() - 1, "");
        }
        baseDict = BaseTypeDictionary.forStereoCode(skeletonCode.toString());
        String modifiedStereo = baseDict.getName();
        mono.removeStereo(tempStereo);
        mono.addStereo(modifiedStereo);
        return _node;
    }

    private boolean haveChild(String _notation) {
        String currentID = this.kcfUtil.splitNotation(_notation).get(0);
        String childSideNotation = this.kcfUtil.extractEdgeByID(currentID, true);
        String parentSideNotation = this.kcfUtil.extractEdgeByID(currentID, false);
        return !childSideNotation.equals("") && !parentSideNotation.equals("");
    }

    private boolean isCrossLinkedSubstituent(String _notation) {
        String linkage = this.kcfUtil.getEdgeByID(this.kcfUtil.splitNotation(_notation).get(0), true);
        String id = this.kcfUtil.extractID(this.kcfUtil.splitNotation(linkage).get(1));
        String nodeString = this.kcfUtil.getNodeByID(id);
        if (nodeString.equals("")) {
            return false;
        }
        return MonosaccharideNotationAnalyzer.start(this.kcfUtil.splitNotation(nodeString).get(1));
    }

    private boolean isPyrophosphate(String _notation) {
        if (this.kcfUtil.splitNotation(_notation).get(1).equals("PP")) {
            return true;
        }
        String currentID = this.kcfUtil.splitNotation(_notation).get(0);
        String childSideNotation = this.kcfUtil.extractEdgeByID(currentID, true);
        if (!childSideNotation.equals("")) {
            String childNode = this.kcfUtil.getNodeByID(this.kcfUtil.splitNotation(childSideNotation).get(1));
            String parentNode = this.kcfUtil.getNodeByID(this.kcfUtil.splitNotation(childSideNotation).get(2));
            if (childNode.equals("") || parentNode.equals("")) {
                return false;
            }
            BaseSubstituentTemplate parentT = BaseSubstituentTemplate.forIUPACNotationWithIgnore(this.kcfUtil.splitNotation(parentNode).get(1));
            BaseSubstituentTemplate childT = BaseSubstituentTemplate.forIUPACNotationWithIgnore(this.kcfUtil.splitNotation(childNode).get(1));
            if (parentT == null || childT == null) {
                return false;
            }
            if (parentT.equals(BaseSubstituentTemplate.PHOSPHATE) && childT.equals(BaseSubstituentTemplate.PHOSPHATE)) {
                return true;
            }
        }
        return false;
    }

    private boolean isPhosphoEthanolamine(String _notation) {
        String currentID = this.kcfUtil.splitNotation(_notation).get(0);
        String childNotation = this.kcfUtil.extractEdgeByID(currentID, true);
        if (!childNotation.equals("")) {
            String childNode = this.kcfUtil.getNodeByID(this.kcfUtil.splitNotation(childNotation).get(1));
            String parentNode = this.kcfUtil.getNodeByID(this.kcfUtil.splitNotation(childNotation).get(2));
            if (childNode.equals("") || parentNode.equals("")) {
                return false;
            }
            childNode = this.kcfUtil.splitNotation(childNode).get(1);
            parentNode = this.kcfUtil.splitNotation(parentNode).get(1);
            if (childNode.equals("EtN")) {
                childNode = BaseSubstituentTemplate.ETHANOLAMINE.getIUPACnotation();
            }
            BaseSubstituentTemplate parentT = BaseSubstituentTemplate.forIUPACNotationWithIgnore(parentNode);
            BaseSubstituentTemplate childT = BaseSubstituentTemplate.forIUPACNotationWithIgnore(childNode);
            if (parentT == null || childT == null) {
                return false;
            }
            if (parentT.equals(BaseSubstituentTemplate.PHOSPHATE) && childT.equals(BaseSubstituentTemplate.ETHANOLAMINE)) {
                return true;
            }
        }
        return false;
    }

    private boolean isLinkageSubstituents(String _notation) {
        String currentID = this.kcfUtil.splitNotation(_notation).get(0);
        String parentSideNotation = this.kcfUtil.extractEdgeByID(currentID, false);
        if (parentSideNotation.equals("")) {
            return false;
        }
        String childID = this.kcfUtil.splitNotation(parentSideNotation).get(1);
        String parentID = this.kcfUtil.splitNotation(parentSideNotation).get(2);
        if (childID.contains(":") || parentID.contains(":")) {
            return false;
        }
        if (this.kcfUtil.splitNotation(this.kcfUtil.getNodeByID(childID)).get(1).equals("EtN") && this.kcfUtil.splitNotation(this.kcfUtil.getNodeByID(parentID)).get(1).equals("P")) {
            return true;
        }
        return this.kcfUtil.splitNotation(this.kcfUtil.getNodeByID(childID)).get(1).equals("P") && this.kcfUtil.splitNotation(this.kcfUtil.getNodeByID(parentID)).get(1).equals("P");
    }

    private Node makeSubstituentNotation(SubstituentInterface _subInf) throws GlycanException {
        Substituent ret = new Substituent(_subInf);
        ret.setFirstPosition(new Linkage());
        if (ret.getSubstituent() instanceof BaseCrossLinkedTemplate) {
            ret.setSecondPosition(new Linkage());
        }
        if (!SubstituentUtility.isNLinkedSubstituent(ret)) {
            ret.setHeadAtom("O");
        }
        return ret;
    }

    private String modifyNotation(String _notation) {
        if (_notation.equals("PP")) {
            _notation = "PyrP";
        }
        if (_notation.equals("EtN")) {
            _notation = BaseSubstituentTemplate.ETHANOLAMINE.getIUPACnotation();
        }
        if (_notation.equals("EtnP")) {
            _notation = BaseSubstituentTemplate.PHOSPHOETHANOLAMINE.getIUPACnotation();
        }
        return _notation;
    }

    private void modifyHeadAtom(Node _node) {
        for (Edge donorEdge : _node.getChildEdges()) {
            Substituent sub;
            if (donorEdge.getSubstituent() != null && !((sub = (Substituent)donorEdge.getSubstituent()) instanceof GlycanRepeatModification)) continue;
        }
    }
}

