/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SubstituentInterface;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.HexoseDescriptor;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameDictionary;

public class SubstituentIUPACNotationConverter {
    private StringBuilder prefixSubs = new StringBuilder();
    private StringBuilder surfixSubs;
    private StringBuilder surfixCore = new StringBuilder();
    private HashMap<String, String> mapSubs;

    public SubstituentIUPACNotationConverter() {
        this.surfixSubs = new StringBuilder();
        this.mapSubs = new HashMap();
    }

    public String getCoreSubstituentNotaiton() {
        return this.surfixCore.toString();
    }

    public String getSubstituentNotation() {
        return this.surfixSubs.toString();
    }

    public String getPrefixSubstituent() {
        return this.prefixSubs.toString();
    }

    public void start(String _code, Node _node) throws GlycanException {
        StringBuilder nativeSub = new StringBuilder();
        for (Edge child : _node.getChildEdges()) {
            Substituent sub;
            if (child.getSubstituent() == null || (sub = (Substituent)child.getSubstituent()).getSubstituent() == null || sub instanceof GlycanRepeatModification || child.getChild() != null) continue;
            if (this.haveNativeSubstituentWithNsulfate(_code, sub, _node)) {
                nativeSub.append(BaseSubstituentTemplate.AMINE.getIUPACnotation());
                SubstituentUtility.changePlaneTemplate(sub);
            }
            if (this.haveNativeSubstituentInNeu(_code, sub)) {
                nativeSub.append(String.valueOf(this.makePosition(sub.getFirstPosition(), this.haveSecondPos(sub))) + sub.getSubstituent().getIUPACnotation());
                continue;
            }
            if (this.haveNativeSubstituent(_code, sub, _node)) {
                nativeSub.append(sub.getSubstituent().getIUPACnotation());
                continue;
            }
            if (this.haveAnhydroxyl(sub.getSubstituent())) {
                this.extractAnhydroxylSubstituent(sub);
                continue;
            }
            this.extractSubstituentWithPosition(sub);
        }
        if (this.prefixSubs.length() != 0) {
            this.prefixSubs.append("-Anhydro-");
        }
        this.surfixCore.append((CharSequence)nativeSub);
        this.extractUnsaturatedState(_node);
        StringBuilder coreSub = new StringBuilder();
        for (String unit : this.concatSubstituents()) {
            coreSub.append(unit);
        }
        this.surfixSubs.append((CharSequence)coreSub);
    }

    private String makePosition(Linkage _linkage, boolean _haveSecond) {
        if (_linkage == null) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        Iterator<Integer> iterPos = _linkage.getParentLinkages().iterator();
        while (iterPos.hasNext()) {
            Integer pos = iterPos.next();
            ret.append(pos == -1 ? "?" : pos);
            if (!iterPos.hasNext()) continue;
            ret.append("/");
        }
        if (_haveSecond) {
            if (_linkage.getChildLinkages().contains(0)) {
                ret.append("-1");
            } else {
                ret.append("-" + _linkage.getChildLinkages().get(0));
            }
        }
        if (_linkage.getParentProbabilityLower() != 1.0) {
            ret.append("(");
            if (_linkage.getParentProbabilityLower() == -1.0) {
                ret.append("?%");
            } else {
                ret.append(String.valueOf((int)(_linkage.getParentProbabilityLower() * 100.0)) + "%");
            }
        }
        if (_linkage.getParentProbabilityUpper() != 1.0) {
            if (_linkage.getParentProbabilityUpper() != _linkage.getParentProbabilityLower()) {
                if (ret.length() != 0) {
                    ret.append(",");
                }
                if (_linkage.getParentProbabilityUpper() == -1.0) {
                    ret.append("?%");
                } else {
                    ret.append(String.valueOf((int)(_linkage.getParentProbabilityUpper() * 100.0)) + "%");
                }
            }
            ret.append(")");
        }
        if (ret.indexOf("(") != -1 && ret.indexOf(")") == -1) {
            ret.append(")");
        }
        return ret.toString();
    }

    private void extractUnsaturatedState(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        for (GlyCoModification mod : mono.getModifications()) {
            ModificationTemplate modT = mod.getModificationTemplate();
            if (this.mapSubs.containsKey(modT.getIUPACnotation())) continue;
            if (this.isUnsaturate(modT)) {
                this.mapSubs.put(modT.getIUPACnotation(), String.valueOf(mod.getPositionOne()));
            }
            if (!modT.equals((Object)ModificationTemplate.UNKNOWN)) continue;
            this.mapSubs.put(modT.getIUPACnotation(), "?");
        }
    }

    private boolean isUnsaturate(ModificationTemplate _modT) {
        return _modT.equals((Object)ModificationTemplate.UNSATURATION_EL) || _modT.equals((Object)ModificationTemplate.UNSATURATION_FL) || _modT.equals((Object)ModificationTemplate.UNSATURATION_ZL) || _modT.equals((Object)ModificationTemplate.UNSATURATION_EU) || _modT.equals((Object)ModificationTemplate.UNSATURATION_FU) || _modT.equals((Object)ModificationTemplate.UNSATURATION_ZU);
    }

    private ArrayList<String> concatSubstituents() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : this.mapSubs.keySet()) {
            int numOfsub = 0;
            String notation = this.mapSubs.get(key);
            if (notation.indexOf(",") != -1 && notation.indexOf("-") == -1) {
                numOfsub = notation.split(",").length;
            }
            if (notation.indexOf(":") != -1) {
                numOfsub = notation.split(":").length;
            }
            String temp = String.valueOf(this.mapSubs.get(key).replaceAll("_", ",")) + key;
            if (numOfsub > 1) {
                temp = String.valueOf(temp) + numOfsub;
            }
            ret.add(temp);
        }
        Collections.sort(ret);
        return ret;
    }

    private void extractSubstituentWithPosition(Substituent _sub) {
        StringBuilder sbPos = new StringBuilder();
        boolean haveSecond = this.haveSecondPos(_sub);
        if (_sub.getFirstPosition() == null) {
            return;
        }
        String subNotation = SubstituentUtility.optimizeSubstituentNotationWithLinkageType(_sub);
        sbPos.append(this.makePosition(_sub.getFirstPosition(), haveSecond));
        if (_sub.getSecondPosition() != null) {
            if (_sub.getSecondPosition().getChildLinkages().isEmpty()) {
                sbPos.append("_" + this.makePosition(_sub.getSecondPosition(), haveSecond));
            } else {
                sbPos.append("," + this.makePosition(_sub.getSecondPosition(), haveSecond));
            }
        }
        if (this.mapSubs.containsKey(subNotation.toString())) {
            StringBuilder temp = new StringBuilder(this.mapSubs.get(subNotation));
            if (this.comparePosition(sbPos.toString(), temp.toString())) {
                if (_sub.getFirstPosition().getParentLinkages().size() > 1) {
                    temp.append(":" + sbPos);
                } else if (temp.indexOf(":") != -1 || temp.indexOf("-") != -1 || sbPos.indexOf(":") != -1 || sbPos.indexOf("-") != -1) {
                    temp.append(":" + sbPos);
                } else {
                    temp.append("," + sbPos);
                }
                sbPos = temp;
            } else if (_sub.getFirstPosition().getParentLinkages().size() > 1) {
                sbPos.append(":" + sbPos);
            } else if (temp.indexOf(":") != -1 || temp.indexOf("-") != -1 || sbPos.indexOf(":") != -1 || sbPos.indexOf("-") != -1) {
                sbPos.append(":" + temp);
            } else {
                sbPos.append("," + temp);
            }
        }
        this.mapSubs.put(subNotation.toString(), sbPos.toString());
    }

    private void extractAnhydroxylSubstituent(Substituent _sub) {
        if (this.prefixSubs.length() != 0) {
            this.prefixSubs.append(":");
        }
        this.prefixSubs.append(_sub.getFirstPosition().getParentLinkages().get(0));
        this.prefixSubs.append(",");
        this.prefixSubs.append(_sub.getSecondPosition().getParentLinkages().get(0));
    }

    private boolean comparePosition(String onePos, String twoPos) {
        int inttwo;
        String one = onePos.substring(0, 1);
        String two = twoPos.substring(0, 1);
        int intone = one.equals("?") ? -1 : Integer.parseInt(one);
        int n = inttwo = two.equals("?") ? -1 : Integer.parseInt(two);
        return intone > inttwo;
    }

    private boolean haveAnhydroxyl(SubstituentInterface _subface) {
        if (!(_subface instanceof BaseCrossLinkedTemplate)) {
            return false;
        }
        return _subface.equals(BaseCrossLinkedTemplate.ANHYDRO);
    }

    private boolean haveNativeSubstituent(String _code, Substituent _sub, Node _node) {
        if (_sub.getSubstituent() instanceof BaseCrossLinkedTemplate) {
            return false;
        }
        BaseSubstituentTemplate subT = (BaseSubstituentTemplate)_sub.getSubstituent();
        if (!this.isHexoseWithNativeSubstituent(_code)) {
            return false;
        }
        if (_sub.getFirstPosition().getParentLinkages().size() > 1 || _sub.getSecondPosition() != null) {
            return false;
        }
        Integer firstPosition = _sub.getFirstPosition().getParentLinkages().get(0);
        if (firstPosition != 2) {
            return false;
        }
        if (this.isAcidicTail(_node)) {
            return false;
        }
        if (subT.equals(BaseSubstituentTemplate.NACETYL)) {
            return true;
        }
        return _sub.getHeadAtom().equals("N");
    }

    private boolean haveNativeSubstituentInNeu(String _code, Substituent _sub) {
        if (this.isNeuraminicAcid(_code)) {
            return false;
        }
        if (_sub.getSubstituent() instanceof BaseCrossLinkedTemplate) {
            return false;
        }
        if (!this.isHexoseWithNativeSubstituent(_code)) {
            return false;
        }
        if (_sub.getFirstPosition().getParentLinkages().size() > 1 || _sub.getSecondPosition() != null) {
            return false;
        }
        Integer firstPosition = _sub.getFirstPosition().getParentLinkages().get(0);
        if (firstPosition != 5) {
            return false;
        }
        BaseSubstituentTemplate subT = (BaseSubstituentTemplate)_sub.getSubstituent();
        return subT.equals(BaseSubstituentTemplate.NACETYL) || subT.equals(BaseSubstituentTemplate.NGLYCOLYL);
    }

    private boolean isNeuraminicAcid(String _code) {
        TrivialNameDictionary dict = TrivialNameDictionary.forThreeLetterCode(_code);
        if (dict == null) {
            return false;
        }
        return dict.equals((Object)TrivialNameDictionary.NEU);
    }

    protected boolean haveNativeSubstituentWithNsulfate(String _code, Substituent _sub, Node _current) {
        if (_sub.getSubstituent() instanceof BaseCrossLinkedTemplate) {
            return false;
        }
        if (_sub.getFirstPosition().getParentLinkages().size() > 1) {
            return false;
        }
        Integer firstPosition = _sub.getFirstPosition().getParentLinkages().get(0);
        if (firstPosition != 2) {
            return false;
        }
        if (this.is6DeoxyHexose(_code) || this.isAcidicTail(_current)) {
            return false;
        }
        if (_sub.getSubstituent().equals(BaseSubstituentTemplate.NACETYL)) {
            return false;
        }
        return SubstituentUtility.isNLinkedSubstituent(_sub);
    }

    protected boolean isHexoseWithNativeSubstituent(String _code) {
        HexoseDescriptor enumHex = HexoseDescriptor.forTrivialName(_code);
        return enumHex != null;
    }

    protected boolean is6DeoxyHexose(String _code) {
        HexoseDescriptor enumHex = HexoseDescriptor.forTrivialName(_code);
        if (enumHex == null) {
            return false;
        }
        if (enumHex.equals((Object)HexoseDescriptor.FUC)) {
            return true;
        }
        if (enumHex.equals((Object)HexoseDescriptor.RHA)) {
            return true;
        }
        return enumHex.equals((Object)HexoseDescriptor.QUI);
    }

    private boolean isAcidicTail(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        boolean tailAcid = false;
        ModificationTemplate acid = ModificationTemplate.URONICACID;
        for (GlyCoModification mod : mono.getModifications()) {
            ModificationTemplate modT = mod.getModificationTemplate();
            boolean bl = tailAcid = mod.getPositionOne().intValue() == mono.getSuperClass().getSize() && modT.equals((Object)acid);
        }
        return tailAcid;
    }

    private boolean haveSecondPos(Substituent _sub) {
        return _sub.getSecondPosition() != null;
    }
}

