/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.Glycan;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.util.visitor.ContainerVisitor;
import org.glycoinfo.GlycanFormatconverter.util.visitor.VisitorException;

public class Monosaccharide
extends Node {
    private AnomericStateDescriptor enumAnomer;
    private int anomerPosition;
    private LinkedList<String> stereos = new LinkedList();
    private SuperClass enumSuperClass;
    public static final int UNKNOWN_RING = -1;
    public static final int OPEN_CHAIN = 0;
    private int ringStart;
    private int ringEnd;
    private ArrayList<GlyCoModification> modifications = new ArrayList();

    public Monosaccharide() {
        this.ringStart = -1;
        this.ringEnd = -1;
        this.modifications.clear();
        this.stereos.clear();
    }

    public Monosaccharide(AnomericStateDescriptor _anomer, SuperClass _superclass) throws GlycanException {
        if (_anomer == null) {
            throw new GlycanException("Invalid nomeric state");
        }
        this.enumAnomer = _anomer;
        if (_superclass == null) {
            throw new GlycanException("Invalid superclass");
        }
        this.enumSuperClass = _superclass;
        this.ringStart = -1;
        this.ringEnd = -1;
        this.modifications.clear();
        this.stereos.clear();
    }

    public void setAnomer(AnomericStateDescriptor _anomer) throws GlycanException {
        if (_anomer == null) {
            throw new GlycanException("Invalid anomeric state");
        }
        this.enumAnomer = _anomer;
    }

    public void setSuperClass(SuperClass _superclass) throws GlycanException {
        if (_superclass == null) {
            throw new GlycanException("Invalid super class");
        }
        this.enumSuperClass = _superclass;
    }

    public void setAnomericPosition(int _anomericPosition) {
        this.anomerPosition = _anomericPosition;
    }

    public SuperClass getSuperClass() {
        return this.enumSuperClass;
    }

    public AnomericStateDescriptor getAnomer() {
        return this.enumAnomer;
    }

    public int getAnomericPosition() {
        return this.anomerPosition;
    }

    public void setRing(int _start, int _end) throws GlycanException {
        if (_start == 0 || _end == 0) {
            // empty if block
        }
        if (_start > _end && _end > -1) {
            throw new GlycanException("start point bigger than end point");
        }
        if (_start < -1) {
            throw new GlycanException("start point should not -1");
        }
        if (_end < -1) {
            throw new GlycanException("end point should not -1");
        }
        this.ringStart = _start;
        this.ringEnd = _end;
    }

    public void setRingStart(int _start) throws GlycanException {
        if (this.ringStart > _start) {
            throw new GlycanException("Invalid start ring position");
        }
        if (_start < -1) {
            throw new GlycanException("Invalid start ring position");
        }
        this.ringStart = _start;
    }

    public void setRingEnd(int _end) throws GlycanException {
        if (this.ringEnd > _end) {
            throw new GlycanException("Invalid end ring position");
        }
        if (_end < -1) {
            throw new GlycanException("Invalid end ring position");
        }
        this.ringEnd = _end;
    }

    public int getRingStart() {
        return this.ringStart;
    }

    public int getRingEnd() {
        return this.ringEnd;
    }

    public ArrayList<GlyCoModification> getModifications() {
        ArrayList<GlyCoModification> ret = new ArrayList<GlyCoModification>();
        ret.addAll(this.modifications);
        return ret;
    }

    public boolean addModification(GlyCoModification _modification) {
        if (_modification == null) {
            return false;
        }
        if (!this.modifications.contains(_modification)) {
            return this.modifications.add(_modification);
        }
        return false;
    }

    public boolean removeModification(GlyCoModification _modificaiton) {
        return this.modifications.remove(_modificaiton);
    }

    public void setModification(ArrayList<GlyCoModification> _modifications) throws GlycanException {
        if (_modifications == null) {
            throw new GlycanException("Modificaition list is Null");
        }
        this.modifications.clear();
        Iterator<GlyCoModification> iterMod = _modifications.iterator();
        while (iterMod.hasNext()) {
            this.modifications.add(iterMod.next());
        }
    }

    public void setStereos(LinkedList<String> _stereo) throws GlycanException {
        if (_stereo == null) {
            throw new GlycanException("null is not a valide set of basetypes");
        }
        this.stereos.clear();
        Iterator iterStereo = _stereo.iterator();
        while (iterStereo.hasNext()) {
            this.addStereo((String)iterStereo.next());
        }
        this.stereos = _stereo;
    }

    public LinkedList<String> getStereos() {
        LinkedList<String> ret = new LinkedList<String>();
        ret.addAll(this.stereos);
        return ret;
    }

    public boolean addStereo(String _stereo) throws GlycanException {
        if (_stereo == null) {
            throw new GlycanException("Basetype can not be null");
        }
        return this.stereos.add(_stereo);
    }

    public boolean removeStereo(String _stereo) {
        return this.stereos.remove(_stereo);
    }

    public boolean hasModification(GlyCoModification _modification) {
        return this.modifications.contains(_modification);
    }

    public boolean hasModification(GlyCoModification _modification, Integer _positionOne) {
        for (GlyCoModification m : this.modifications) {
            if (!m.getModificationTemplate().equals((Object)_modification.getModificationTemplate()) || m.getPositionOne() != _positionOne) continue;
            return true;
        }
        return false;
    }

    public boolean hasModification(GlyCoModification _modification, Integer _positionOne, Integer _positionTwo) {
        for (GlyCoModification m : this.modifications) {
            if (!m.getModificationTemplate().equals((Object)_modification.getModificationTemplate()) || m.getPositionOne() != _positionOne || m.getPositionTwo() != _positionTwo) continue;
            return true;
        }
        return false;
    }

    @Override
    public void accept(ContainerVisitor _visitor) throws VisitorException {
        _visitor.visit(this);
    }

    @Override
    public Monosaccharide copy() throws GlycanException {
        Monosaccharide ret = null;
        ret = new Monosaccharide(this.enumAnomer, this.enumSuperClass);
        ret.setAnomericPosition(this.getAnomericPosition());
        ret.setRingStart(this.ringStart);
        ret.setRingEnd(this.ringEnd);
        Iterator iterStereo = this.stereos.iterator();
        while (iterStereo.hasNext()) {
            ret.addStereo((String)iterStereo.next());
        }
        Iterator<GlyCoModification> iterMod = this.modifications.iterator();
        while (iterMod.hasNext()) {
            ret.addModification(iterMod.next().copy());
        }
        for (Edge childEdge : this.getChildEdges()) {
            Substituent sub = (Substituent)childEdge.getSubstituent();
            if (sub == null || sub instanceof GlycanRepeatModification || childEdge.getChild() != null) continue;
            Edge copyEdge = childEdge.copy();
            Substituent copySub = sub.copy();
            copyEdge.setSubstituent(copySub);
            copyEdge.setParent(ret);
            ret.addChildEdge(copyEdge);
        }
        ret.setStereos(this.stereos);
        return ret;
    }
}

