/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.databasebot.dialog.process;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.tools.databasebot.dialog.process.IProgressReporter;
import org.grits.toolbox.tools.databasebot.dialog.process.ProgressDialogThread;
import org.grits.toolbox.widgets.processDialog.TextProgressBar;

public class ProgressDialog
extends Dialog
implements IProgressReporter {
    private static final Logger logger = Logger.getLogger(ProgressDialog.class);
    protected ProgressDialogThread m_worker = null;
    protected Button m_button = null;
    protected Text m_textNotification = null;
    protected TextProgressBar m_progressBarMain = null;
    protected Composite cancelComposite;
    protected Shell m_shell;
    protected Display display = null;
    private int max = 0;
    private double count = 0.0;
    private double increment = 0.0;
    protected boolean isCanceled = false;

    public ProgressDialog(Shell parent) {
        super(parent);
    }

    public Shell getShell() {
        return this.m_shell;
    }

    public void setShell(Shell shell) {
        this.m_shell = shell;
    }

    public ProgressDialogThread getWorker() {
        return this.m_worker;
    }

    public void setWorker(ProgressDialogThread a_worker) {
        this.m_worker = a_worker;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    @Override
    public void setProcessMessageLabel(String a_message) {
        final String t_message = new String(a_message);
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.m_progressBarMain.setText(t_message);
            }
        });
    }

    @Override
    public void updateProgresBar(String msg) {
        final String t_message = new String(msg);
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.m_progressBarMain.setSelection((int)(ProgressDialog.this.count + ProgressDialog.this.increment));
                ProgressDialog progressDialog = ProgressDialog.this;
                progressDialog.count = progressDialog.count + ProgressDialog.this.increment;
                ProgressDialog.this.m_progressBarMain.setText(t_message);
            }
        });
    }

    @Override
    public void threadFinished(final boolean successful) {
        if (!this.isCanceled) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.m_progressBarMain.setSelection(100);
                    ProgressDialog.this.m_button.setText("Finish");
                    ProgressDialog.this.m_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            (this).ProgressDialog.this.isCanceled = false;
                            (this).ProgressDialog.this.m_shell.close();
                        }
                    });
                    if (ProgressDialog.this.m_textNotification.getText().equals("") && successful) {
                        ProgressDialog.this.isCanceled = false;
                        ProgressDialog.this.m_shell.close();
                    }
                }
            });
        } else {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.isCanceled = true;
                    ProgressDialog.this.m_shell.close();
                }
            });
        }
    }

    public int open() {
        this.createContents();
        Monitor t_primaryMonitor = this.m_shell.getDisplay().getPrimaryMonitor();
        Rectangle t_boundsMonitor = t_primaryMonitor.getBounds();
        Rectangle t_boundsShell = this.m_shell.getBounds();
        int x = t_boundsMonitor.x + (t_boundsMonitor.width - t_boundsShell.width) / 2;
        int y = t_boundsMonitor.y + (t_boundsMonitor.height - t_boundsShell.height) / 2;
        this.m_shell.setLocation(x, y);
        this.m_shell.open();
        this.m_shell.layout();
        this.m_worker.setDialog(this);
        this.m_worker.start();
        Display display = this.getParent().getDisplay();
        while (!this.m_shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.isCanceled) {
            return 256;
        }
        return 32;
    }

    protected void createContents() {
        this.m_shell = PropertyHandler.getModalDialog((Shell)this.getParent());
        this.display = this.m_shell.getDisplay();
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        this.m_shell.setLayout((Layout)gridLayout);
        this.m_shell.setSize(483, 300);
        this.m_shell.setText("Progress Dialog");
        Composite composite = new Composite((Composite)this.m_shell, 0);
        composite.setLayoutData((Object)new GridData(4, 2, true, false));
        composite.setLayout((Layout)new GridLayout());
        this.m_progressBarMain = new TextProgressBar((Composite)this.m_shell, 65792);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.m_progressBarMain.setMinimum(0);
        this.m_progressBarMain.setMaximum(this.max);
        this.m_progressBarMain.setLayoutData((Object)gd);
        this.cancelComposite = new Composite((Composite)this.m_shell, 0);
        this.cancelComposite.setLayoutData((Object)new GridData(4, 2, false, false));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        this.cancelComposite.setLayout((Layout)gridLayout_1);
        GridData descriptionTextData = new GridData();
        descriptionTextData.minimumHeight = 80;
        descriptionTextData.grabExcessHorizontalSpace = true;
        descriptionTextData.grabExcessVerticalSpace = true;
        descriptionTextData.horizontalAlignment = 4;
        descriptionTextData.horizontalSpan = 2;
        this.m_textNotification = new Text(this.cancelComposite, 2816);
        this.m_textNotification.setLayoutData((Object)descriptionTextData);
        this.m_textNotification.setEditable(false);
        this.m_button = new Button(this.cancelComposite, 0);
        this.m_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressDialog.this.isCanceled = true;
                ProgressDialog.this.clickCancel();
            }
        });
        this.m_button.setLayoutData((Object)new GridData(78, -1));
        this.m_button.setText("cancel");
    }

    protected void clickCancel() {
        this.m_worker.cancelWork();
    }

    @Override
    public void setDescriptionText(String description) {
        final String t_message = new String(description);
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                StringBuffer sb = new StringBuffer();
                if (ProgressDialog.this.m_textNotification.getText().equals("")) {
                    sb.append(t_message);
                } else {
                    sb.append(ProgressDialog.this.m_textNotification.getText());
                    sb.append("\r\n");
                    sb.append(t_message);
                }
                ProgressDialog.this.m_textNotification.setText(sb.toString());
                ProgressDialog.this.m_textNotification.setSelection(ProgressDialog.this.m_textNotification.getCharCount());
            }
        });
    }

    @Override
    public void setMax(int max) {
        this.max = max;
        this.increment = 100.0 / (double)max;
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.m_progressBarMain.setSelection(0);
                ProgressDialog.this.m_progressBarMain.setText("");
                ProgressDialog.this.count = 0.0;
            }
        });
    }

    public Display getDisplay() {
        return this.display;
    }

    @Override
    public void endWithException(final Exception e) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                logger.error((Object)e.getMessage(), (Throwable)e);
                if (ErrorUtils.createErrorMessageBoxReturn((Shell)ProgressDialog.this.m_shell, (String)"Error", (Exception)e) == 1) {
                    ProgressDialog.this.isCanceled = true;
                    ProgressDialog.this.m_shell.close();
                }
            }
        });
    }
}

