/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.tablehelpers;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.MenuItemProviders;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTable;

public class MSAnnotationMenuItemProviders
extends MenuItemProviders {
    public static IMenuItemProvider hideRowMenuItemProvider() {
        return MSAnnotationMenuItemProviders.hideRowMenuItemProvider("Hide unannotated rows");
    }

    public static IMenuItemProvider hideRowMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem menuItem = new MenuItem(popupMenu, 8);
                menuItem.setText(menuLabel);
                menuItem.setEnabled(true);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        MSAnnotationTable msTable = (MSAnnotationTable)natTable;
                        msTable.hideUnannotatedRows();
                        msTable.updatePreferenceSettingsFromCurrentView();
                        msTable.getPreference().writePreference();
                    }
                });
            }
        };
    }

    public static IMenuItemProvider hideNoSelectionMenuItemProvider() {
        return MSAnnotationMenuItemProviders.hideNoSelectionMenuItemProvider("Hide rows with no selection");
    }

    public static IMenuItemProvider hideNoSelectionMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem menuItem = new MenuItem(popupMenu, 8);
                menuItem.setText(menuLabel);
                menuItem.setEnabled(true);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        MSAnnotationTable msTable = (MSAnnotationTable)natTable;
                        msTable.hideInvisibleRows();
                        msTable.updatePreferenceSettingsFromCurrentView();
                        msTable.getPreference().writePreference();
                    }
                });
            }
        };
    }

    public static IMenuItemProvider showNoSelectionMenuItemProvider() {
        return MSAnnotationMenuItemProviders.showNoSelectionMenuItemProvider("Show rows with no selection");
    }

    public static IMenuItemProvider showNoSelectionMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem showAllColumns = new MenuItem(popupMenu, 8);
                showAllColumns.setText(menuLabel);
                showAllColumns.setEnabled(true);
                showAllColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MSAnnotationTable msTable = (MSAnnotationTable)natTable;
                        msTable.showInvisibleRows();
                        msTable.updatePreferenceSettingsFromCurrentView();
                        msTable.getPreference().writePreference();
                    }
                });
            }
        };
    }

    public static IMenuItemProvider showAllRowMenuItemProvider() {
        return MSAnnotationMenuItemProviders.showAllRowMenuItemProvider("Show unannotated rows");
    }

    public static IMenuItemProvider showAllRowMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem showAllColumns = new MenuItem(popupMenu, 8);
                showAllColumns.setText(menuLabel);
                showAllColumns.setEnabled(true);
                showAllColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MSAnnotationTable msTable = (MSAnnotationTable)natTable;
                        msTable.showUnannotatedRows();
                        msTable.updatePreferenceSettingsFromCurrentView();
                        msTable.getPreference().writePreference();
                    }
                });
            }
        };
    }

    public static IMenuItemProvider lockSelectionMenuItemProvider() {
        return MSAnnotationMenuItemProviders.lockSelectionMenuItemProvider("Lock Selection");
    }

    private static IMenuItemProvider lockSelectionMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem lockSelection = new MenuItem(popupMenu, 8);
                lockSelection.setText(menuLabel);
                lockSelection.setEnabled(true);
                lockSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MSAnnotationTable msTable = (MSAnnotationTable)natTable;
                        msTable.lockSelection();
                    }
                });
            }
        };
    }

    public static IMenuItemProvider unlockSelectionMenuItemProvider() {
        return MSAnnotationMenuItemProviders.unlockSelectionMenuItemProvider("Unlock Selection");
    }

    private static IMenuItemProvider unlockSelectionMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem unlockSelection = new MenuItem(popupMenu, 8);
                unlockSelection.setText(menuLabel);
                unlockSelection.setEnabled(true);
                unlockSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MSAnnotationTable msTable = (MSAnnotationTable)natTable;
                        msTable.unlockSelection();
                    }
                });
            }
        };
    }
}

