/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;

public class GritsPreferenceNode
extends PreferenceNode {
    private static final Logger logger = Logger.getLogger(GritsPreferenceNode.class);
    private String pluginId = null;
    private String className = null;

    public GritsPreferenceNode(String pluginId, String id, String pageName, ImageDescriptor imageDescriptor, String className) {
        super(id, pageName, imageDescriptor, className);
        this.pluginId = pluginId;
        this.className = className;
    }

    public void createPage() {
        this.setPage((IPreferencePage)this.loadPageFromPlugin());
    }

    private PreferencePage loadPageFromPlugin() {
        logger.info((Object)("Creating class : " + this.pluginId + "/" + this.className));
        try {
            Class clazz = Platform.getBundle((String)this.pluginId).loadClass(this.className);
            PreferencePage page = null;
            if (PreferencePage.class.isAssignableFrom(clazz)) {
                page = (PreferencePage)clazz.newInstance();
                page.setTitle(this.getLabelText());
                return page;
            }
            String errorMessage = "This class does not extend PreferencePage: " + this.pluginId + "/" + this.className;
            logger.fatal((Object)errorMessage);
            throw new InstantiationException(errorMessage);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.fatal((Object)("Error loading page \"" + this.className + "\" from plugin : " + this.pluginId + "\n" + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

