/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTableViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IStatusMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.ILabelRequestMonitor;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractVirtualContentTableModel;
import org.eclipse.debug.internal.ui.views.memory.renderings.IPresentationErrorListener;
import org.eclipse.debug.internal.ui.views.memory.renderings.IVirtualContentListener;
import org.eclipse.debug.internal.ui.views.memory.renderings.MemorySegment;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.progress.UIJob;

public abstract class AsyncVirtualContentTableViewer
extends AsynchronousTableViewer {
    private Object fPendingTopIndexKey;
    private ArrayList<Object> fTopIndexQueue = new ArrayList();
    private boolean fPendingResizeColumns;
    private ListenerList<IVirtualContentListener> fVirtualContentListeners = new ListenerList();
    private SelectionListener fScrollSelectionListener;
    private ListenerList<IPresentationErrorListener> fPresentationErrorListeners = new ListenerList();
    private Object fTopIndexKey;

    public AsyncVirtualContentTableViewer(Composite parent, int style) {
        super(parent, style);
        this.initScrollBarListener();
    }

    private void initScrollBarListener() {
        ScrollBar scroll = this.getTable().getVerticalBar();
        this.fScrollSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AsyncVirtualContentTableViewer.this.handleScrollBarSelection();
            }
        };
        scroll.addSelectionListener(this.fScrollSelectionListener);
    }

    public void setTopIndex(Object key) {
        this.fPendingTopIndexKey = key;
        this.attemptSetTopIndex();
    }

    protected Object getPendingSetTopIndexKey() {
        return this.fPendingTopIndexKey;
    }

    @Override
    protected void handlePresentationFailure(IStatusMonitor monitor, IStatus status) {
        this.notifyPresentationError(monitor, status);
    }

    public void disposeColumns() {
        TableColumn[] oldColumns = this.getTable().getColumns();
        int i = 0;
        while (i < oldColumns.length) {
            oldColumns[i].dispose();
            ++i;
        }
    }

    public void disposeCellEditors() {
        CellEditor[] oldCellEditors = this.getCellEditors();
        if (oldCellEditors != null) {
            int i = 0;
            while (i < oldCellEditors.length) {
                oldCellEditors[i].dispose();
                ++i;
            }
        }
    }

    public void resizeColumnsToPreferredSize() {
        this.fPendingResizeColumns = true;
        this.fPendingResizeColumns = this.attemptResizeColumnsToPreferredSize();
    }

    private boolean attemptResizeColumnsToPreferredSize() {
        if (this.fPendingResizeColumns && !this.hasPendingUpdates()) {
            UIJob job = new UIJob("packcolumns"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    Table table = AsyncVirtualContentTableViewer.this.getTable();
                    if (!table.isDisposed()) {
                        if (table.getSize().x > 0) {
                            TableColumn[] columns = table.getColumns();
                            int i = 0;
                            while (i < columns.length - 1) {
                                columns[i].pack();
                                ++i;
                            }
                        } else {
                            AsyncVirtualContentTableViewer.this.fPendingResizeColumns = true;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            return false;
        }
        return this.fPendingResizeColumns;
    }

    protected synchronized void attemptSetTopIndex() {
        Object remaining;
        if (this.fPendingTopIndexKey != null && (remaining = this.doAttemptSetTopIndex(this.fPendingTopIndexKey)) == null) {
            this.fPendingTopIndexKey = remaining;
        }
    }

    private synchronized Object doAttemptSetTopIndex(final Object topIndexKey) {
        int i = this.getVirtualContentModel().indexOfKey(topIndexKey);
        if (i >= 0) {
            UIJob job = new UIJob("set top index"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (AsyncVirtualContentTableViewer.this.getTable().isDisposed()) {
                        AsyncVirtualContentTableViewer.this.fTopIndexQueue.clear();
                        return Status.OK_STATUS;
                    }
                    int idx = AsyncVirtualContentTableViewer.this.getVirtualContentModel().indexOfKey(topIndexKey);
                    if (idx >= 0) {
                        if (DebugUIPlugin.DEBUG_DYNAMIC_LOADING) {
                            DebugUIPlugin.trace("actual set top index: " + ((BigInteger)topIndexKey).toString(16));
                        }
                        AsyncVirtualContentTableViewer.this.fPendingTopIndexKey = null;
                        AsyncVirtualContentTableViewer.this.setTopIndexKey(topIndexKey);
                        AsyncVirtualContentTableViewer.this.getTable().setTopIndex(idx);
                        AsyncVirtualContentTableViewer.this.tableTopIndexSetComplete();
                        if (AsyncVirtualContentTableViewer.this.getTable().getTopIndex() != idx) {
                            if (DebugUIPlugin.DEBUG_DYNAMIC_LOADING) {
                                DebugUIPlugin.trace(">>> FAILED set top index : " + ((BigInteger)topIndexKey).toString(16));
                            }
                            if (AsyncVirtualContentTableViewer.this.hasPendingUpdates()) {
                                if (DebugUIPlugin.DEBUG_DYNAMIC_LOADING) {
                                    DebugUIPlugin.trace(">>> Retry top index: " + ((BigInteger)topIndexKey).toString(16));
                                }
                                AsyncVirtualContentTableViewer.this.fPendingTopIndexKey = topIndexKey;
                            }
                        }
                    } else {
                        if (DebugUIPlugin.DEBUG_DYNAMIC_LOADING) {
                            DebugUIPlugin.trace("cannot find key, put it back to the queue: " + topIndexKey);
                        }
                        AsyncVirtualContentTableViewer.this.fPendingTopIndexKey = topIndexKey;
                    }
                    AsyncVirtualContentTableViewer.this.removeKeyFromQueue(topIndexKey);
                    return Status.OK_STATUS;
                }
            };
            this.addKeyToQueue(topIndexKey);
            job.setSystem(true);
            job.schedule();
            return topIndexKey;
        }
        return topIndexKey;
    }

    protected void tableTopIndexSetComplete() {
    }

    public void addVirtualContentListener(IVirtualContentListener listener) {
        this.fVirtualContentListeners.add((Object)listener);
    }

    public void removeVirtualContentListener(IVirtualContentListener listener) {
        this.fVirtualContentListeners.remove((Object)listener);
    }

    protected void notifyListenersAtBufferStart() {
        int topIdx = this.getTable().getTopIndex();
        for (IVirtualContentListener iVirtualContentListener : this.fVirtualContentListeners) {
            final IVirtualContentListener listener = iVirtualContentListener;
            if (topIdx >= listener.getThreshold(0)) continue;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.handledAtBufferStart();
                }

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log(exception);
                }
            });
        }
    }

    protected void notifyListenersAtBufferEnd() {
        int topIdx = this.getTable().getTopIndex();
        int bottomIdx = topIdx + this.getNumberOfVisibleLines();
        int elementsCnt = this.getVirtualContentModel().getElements().length;
        int numLinesLeft = elementsCnt - bottomIdx;
        for (IVirtualContentListener iVirtualContentListener : this.fVirtualContentListeners) {
            final IVirtualContentListener listener = iVirtualContentListener;
            if (numLinesLeft > listener.getThreshold(1)) continue;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.handleAtBufferEnd();
                }

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log(exception);
                }
            });
        }
    }

    protected void handleScrollBarSelection() {
        if (!this.fTopIndexQueue.isEmpty()) {
            return;
        }
        this.topIndexChanged();
    }

    public void topIndexChanged() {
        if (DebugUIPlugin.DEBUG_DYNAMIC_LOADING) {
            MemorySegment a = (MemorySegment)((Object)this.getTable().getItem(this.getTable().getTopIndex()).getData());
            DebugUIPlugin.trace(String.valueOf(Thread.currentThread().getName()) + " " + (Object)((Object)this) + " handle scroll bar moved:  top index: " + a.getAddress().toString(16));
        }
        this.setTopIndexKey(this.getVirtualContentModel().getKey(this.getTable().getTopIndex()));
        this.notifyListenersAtBufferStart();
        this.notifyListenersAtBufferEnd();
    }

    protected void setTopIndexKey(Object key) {
        this.fTopIndexKey = key;
    }

    protected Object getTopIndexKey() {
        return this.fTopIndexKey;
    }

    @Override
    protected synchronized void preservingSelection(Runnable updateCode) {
        Object oldTopIndexKey = null;
        oldTopIndexKey = this.fPendingTopIndexKey == null ? this.getTopIndexKey() : this.fPendingTopIndexKey;
        try {
            updateCode.run();
        }
        finally {
            if (oldTopIndexKey != null) {
                this.setTopIndex(oldTopIndexKey);
            }
        }
    }

    public void addPresentationErrorListener(IPresentationErrorListener errorListener) {
        this.fPresentationErrorListeners.add((Object)errorListener);
    }

    public void removePresentationErrorListener(IPresentationErrorListener errorListener) {
        this.fPresentationErrorListeners.remove((Object)errorListener);
    }

    private void notifyPresentationError(final IStatusMonitor monitor, final IStatus status) {
        Iterator iterator = this.fPresentationErrorListeners.iterator();
        while (iterator.hasNext()) {
            IPresentationErrorListener iPresentationErrorListener;
            final IPresentationErrorListener listener = iPresentationErrorListener = (IPresentationErrorListener)iterator.next();
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.handlePresentationFailure(monitor, status);
                }

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log(exception);
                }
            });
        }
    }

    @Override
    protected AsynchronousModel createModel() {
        return this.createVirtualContentTableModel();
    }

    protected abstract AbstractVirtualContentTableModel createVirtualContentTableModel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeyToQueue(Object topIndexKey) {
        ArrayList<Object> arrayList = this.fTopIndexQueue;
        synchronized (arrayList) {
            if (DebugUIPlugin.DEBUG_DYNAMIC_LOADING) {
                DebugUIPlugin.trace(" >>> add to top index queue: " + ((BigInteger)topIndexKey).toString(16));
            }
            this.fTopIndexQueue.add(topIndexKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeKeyFromQueue(Object topIndexKey) {
        ArrayList<Object> arrayList = this.fTopIndexQueue;
        synchronized (arrayList) {
            if (DebugUIPlugin.DEBUG_DYNAMIC_LOADING) {
                DebugUIPlugin.trace(" >>> remove frome top index queue: " + ((BigInteger)topIndexKey).toString(16));
            }
            this.fTopIndexQueue.remove(topIndexKey);
        }
    }

    public AbstractVirtualContentTableModel getVirtualContentModel() {
        if (this.getModel() instanceof AbstractVirtualContentTableModel) {
            return (AbstractVirtualContentTableModel)this.getModel();
        }
        return null;
    }

    private int getNumberOfVisibleLines() {
        int lineHeight;
        int scroll;
        int border;
        int numberOfLines;
        Table table = this.getTable();
        int height = table.getSize().y;
        if (height == 0) {
            height = table.getParent().getSize().y;
        }
        if ((numberOfLines = (height = height - (border = table.getHeaderHeight()) - (scroll = table.getHorizontalBar().getSize().y)) / (lineHeight = this.getMinTableItemHeight(table))) <= 0) {
            return 20;
        }
        return numberOfLines;
    }

    private int getMinTableItemHeight(Table table) {
        if (MemoryViewUtil.isLinuxGTK()) {
            TableItem[] items = table.getItems();
            int minHeight = table.getItemHeight();
            int i = 0;
            while (i < items.length) {
                if (items[i].getData() != null) {
                    minHeight = Math.min(items[i].getBounds((int)0).height, minHeight);
                }
                ++i;
            }
            return minHeight;
        }
        return table.getItemHeight();
    }

    @Override
    protected void updateComplete(IStatusMonitor monitor) {
        super.updateComplete(monitor);
        this.attemptSetTopIndex();
        if (monitor instanceof ILabelRequestMonitor) {
            this.fPendingResizeColumns = this.attemptResizeColumnsToPreferredSize();
        }
    }

    protected boolean hasPendingSetTopIndex() {
        return !this.fTopIndexQueue.isEmpty();
    }
}

