/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.utils;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class GeneralIconProvider {
    private static Map<String, Image> mapFilenameToIconImage = new HashMap<String, Image>();

    private static Image loadIconImage(String filename) {
        if (filename == null) {
            return null;
        }
        if (!mapFilenameToIconImage.containsKey(filename) || mapFilenameToIconImage.get(filename).isDisposed()) {
            InputStream stream = GeneralIconProvider.class.getResourceAsStream(filename);
            if (stream == null) {
                return null;
            }
            Image img = new Image((Device)Display.getCurrent(), stream);
            mapFilenameToIconImage.put(filename, img);
        }
        return mapFilenameToIconImage.get(filename);
    }

    public static Image getCutIcon() {
        return GeneralIconProvider.loadIconImage("/icons/common/cut.png");
    }

    public static Image getCopyIcon() {
        return GeneralIconProvider.loadIconImage("/icons/common/copy.png");
    }

    public static Image getPasteIcon() {
        return GeneralIconProvider.loadIconImage("/icons/common/paste.png");
    }

    public static Image getDeleteIcon() {
        return GeneralIconProvider.loadIconImage("/icons/common/delete.png");
    }

    public static Image getBracketIcon() {
        return GeneralIconProvider.loadIconImage("/icons/bracket.png");
    }

    public static Image getRepeatIcon() {
        return GeneralIconProvider.loadIconImage("/icons/repeat.png");
    }

    public static Image getChangeDisplayIcon() {
        return GeneralIconProvider.loadIconImage("/icons/display.png");
    }

    public static Image getResiduePropertiesIcon() {
        return GeneralIconProvider.loadIconImage("/icons/properties.png");
    }

    public static Image getOrientationIcon(int orientation) {
        if (orientation == 0) {
            return GeneralIconProvider.loadIconImage("/icons/orientation/rl.png");
        }
        if (orientation == 1) {
            return GeneralIconProvider.loadIconImage("/icons/orientation/bt.png");
        }
        if (orientation == 2) {
            return GeneralIconProvider.loadIconImage("/icons/orientation/lr.png");
        }
        if (orientation == 3) {
            return GeneralIconProvider.loadIconImage("/icons/orientation/tb.png");
        }
        return null;
    }
}

