/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.glycoinfo.GlycanFormatconverter.io.GlycoCT.WURCSToGlycoCT;
import org.glycoinfo.WURCSFramework.io.GlycoCT.WURCSExporterGlycoCT;
import org.grits.toolbox.tools.glycanbuilder.core.io.ErrorDialogUtils;
import org.grits.toolbox.tools.glycanbuilder.core.io.ImageFormat;
import org.grits.toolbox.tools.glycanbuilder.core.io.SequenceFormat;
import org.grits.toolbox.tools.glycanbuilder.core.io.parser.GWSParser;
import org.grits.toolbox.tools.glycanbuilder.core.io.parser.GlycanParser;
import org.grits.toolbox.tools.glycanbuilder.core.io.parser.GlycoCTCondensedParser;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.awt.GlycanRendererAWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.awt.SVGUtils;
import org.grits.toolbox.tools.glycanbuilder.core.workspace.BuilderWorkspaceSWT;

public class GlycanIOUtils {
    public static String convertGlycoCTToWURCS(String strGlycoCT) {
        WURCSExporterGlycoCT exporter = new WURCSExporterGlycoCT();
        try {
            exporter.start(strGlycoCT);
            return exporter.getWURCS();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            MultiStatus status = ErrorDialogUtils.createMultiStatus(e.getLocalizedMessage(), e);
            ErrorDialog.openError(null, (String)"Error", (String)("Error in converting GlycoCT to WURCS:\n" + exporter.getValidationErrorLog()), (IStatus)status);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getGlycanSequence(List<Glycan> lGlycans, SequenceFormat format) {
        if (lGlycans == null) return null;
        if (lGlycans.isEmpty()) {
            return null;
        }
        if (format == null) {
            format = SequenceFormat.GWS;
        }
        ArrayList<String> lSequences = new ArrayList<String>();
        try {
            GlycanParser parser = new GWSParser();
            if (format == SequenceFormat.GCT_C || format == SequenceFormat.WURCS) {
                parser = new GlycoCTCondensedParser(false);
            }
            Iterator<Glycan> iterator = lGlycans.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return lSequences;
                }
                Glycan glycan = iterator.next();
                String sequence = parser.writeGlycan(glycan);
                if (sequence.replaceAll("\n", "").isEmpty()) {
                    throw new Exception("Error in glycan sequence conversion");
                }
                if (format == SequenceFormat.WURCS && (sequence = GlycanIOUtils.convertGlycoCTToWURCS(sequence)) == null) {
                    return null;
                }
                lSequences.add(sequence);
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return null;
        }
    }

    public static List<String> convertGlycanSecuenceWithCheck(List<Glycan> lGlycans, SequenceFormat format, boolean bMultiSave) {
        Shell shell = Display.getCurrent().getActiveShell();
        if (lGlycans == null || lGlycans.isEmpty()) {
            MessageBox box = new MessageBox(shell, 33);
            box.setMessage("No glycan in the canvas.");
            box.open();
            return null;
        }
        List<String> lSequences = GlycanIOUtils.getGlycanSequence(lGlycans, format);
        if (lSequences == null || lSequences.isEmpty()) {
            MessageBox box = new MessageBox(shell, 33);
            box.setMessage("The glycan could not be imported.");
            box.open();
            return null;
        }
        if (!bMultiSave && lSequences.size() > 1) {
            MessageBox box;
            if (!format.supportMultipleStructures()) {
                box = new MessageBox(shell, 200);
                box.setText("Can not support multiple structues");
                box.setMessage("The selected format does not support multiple structures.\nThe structures will be exported to multiple files separately. Continue?");
                if (box.open() == 128) {
                    return null;
                }
            } else {
                box = new MessageBox(shell, 192);
                box.setText("Can support multiple structues");
                box.setMessage("The selected format support multiple structures.\nDo you want to export these structures into one file?");
                if (box.open() == 64) {
                    bMultiSave = true;
                }
            }
        }
        if (bMultiSave && lSequences.size() > 1 && format.supportMultipleStructures()) {
            String strAllSeq = "";
            for (String seq : lSequences) {
                if (!strAllSeq.isEmpty()) {
                    strAllSeq = String.valueOf(strAllSeq) + format.getDelimiter();
                }
                strAllSeq = String.valueOf(strAllSeq) + seq;
            }
            lSequences.clear();
            lSequences.add(strAllSeq);
        }
        return lSequences;
    }

    public static void saveGlycanSequence(List<Glycan> lGlycans, SequenceFormat format, boolean bMultiSave) {
        List<String> lSequences;
        if (lGlycans == null || lGlycans.isEmpty()) {
            return;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setText("Save glycans as sequence");
        fd.setOverwrite(true);
        if (format == null) {
            fd.setFilterNames(SequenceFormat.getFilterNames());
            fd.setFilterExtensions(SequenceFormat.getFilterExtentions());
        } else {
            fd.setFilterNames(new String[]{format.getFilterName()});
            fd.setFilterExtensions(new String[]{format.getFilterExtention()});
        }
        String strSelectedPath = fd.open();
        if (strSelectedPath == null) {
            return;
        }
        if (format == null) {
            format = SequenceFormat.values()[fd.getFilterIndex()];
        }
        if ((lSequences = GlycanIOUtils.convertGlycanSecuenceWithCheck(lGlycans, format, bMultiSave)) == null) {
            return;
        }
        try {
            ArrayList<String> lFilepathes = new ArrayList<String>();
            int nSufix = 1;
            for (String seq : lSequences) {
                String strFilepath = strSelectedPath;
                if (lSequences.size() != 1) {
                    int pos = strFilepath.lastIndexOf(46);
                    strFilepath = String.valueOf(strFilepath.substring(0, pos)) + "-" + nSufix++ + strFilepath.substring(pos);
                }
                FileOutputStream fos = new FileOutputStream(strFilepath);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
                bw.write(seq, 0, seq.length());
                bw.newLine();
                bw.close();
                lFilepathes.add(strFilepath);
            }
            if (lFilepathes.size() > 1) {
                MessageBox box = new MessageBox(shell, 34);
                String message = "The sequences are saved into following files:\n";
                for (String filepath : lFilepathes) {
                    message = String.valueOf(message) + filepath + "\n";
                }
                box.setText("Sequences are saved successfully");
                box.setMessage(message);
                box.open();
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public static String convertWURCSToGlycoCT(String strWURCS) throws Exception {
        WURCSToGlycoCT exporter = new WURCSToGlycoCT();
        exporter.start(strWURCS);
        if (!exporter.getErrorMessages().isEmpty()) {
            throw new Exception(exporter.getErrorMessages());
        }
        return exporter.getGlycoCT();
    }

    public static List<Glycan> getGlycansFromSequence(String strSequence, SequenceFormat format, MassOptions massOptions) {
        ArrayList<String> lSequences = new ArrayList<String>();
        if (format == SequenceFormat.GWS && strSequence.contains(";")) {
            for (String t : TextUtils.tokenize((String)strSequence, (String)";")) {
                if (t.isEmpty()) continue;
                lSequences.add(t);
            }
        } else if (format.supportMultipleStructures() && strSequence.contains(format.getDelimiter())) {
            for (String t : TextUtils.tokenize((String)strSequence, (String)format.getDelimiter())) {
                if (t.isEmpty()) continue;
                lSequences.add(t);
            }
        } else {
            lSequences.add(strSequence);
        }
        return GlycanIOUtils.getGlycansFromSequences(lSequences, format, massOptions);
    }

    public static List<Glycan> getGlycansFromSequences(List<String> lSequences, SequenceFormat format, MassOptions massOptions) {
        if (lSequences == null || lSequences.isEmpty()) {
            return null;
        }
        if (format == null) {
            format = SequenceFormat.GWS;
        }
        ArrayList<Glycan> lGlycans = new ArrayList<Glycan>();
        try {
            GlycanParser parser = new GWSParser();
            if (format == SequenceFormat.GCT_C || format == SequenceFormat.WURCS) {
                parser = new GlycoCTCondensedParser(false);
            }
            for (String sequence : lSequences) {
                if (format == SequenceFormat.WURCS) {
                    sequence = GlycanIOUtils.convertWURCSToGlycoCT(sequence);
                }
                Glycan glycan = parser.readGlycan(sequence, massOptions);
                lGlycans.add(glycan);
            }
            return lGlycans;
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            MultiStatus status = ErrorDialogUtils.createMultiStatus(e.getLocalizedMessage(), e);
            ErrorDialog.openError(null, (String)"Error in import sequence", (String)"The glycans cannot be converted by the selected format.", (IStatus)status);
            return null;
        }
    }

    public static List<Glycan> loadGlycans(SequenceFormat format, MassOptions massOptions) {
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog fd = new FileDialog(shell, 4096);
        fd.setText("Load glycans as sequence format");
        if (format == null) {
            fd.setFilterNames(SequenceFormat.getFilterNames());
            fd.setFilterExtensions(SequenceFormat.getFilterExtentions());
        } else {
            fd.setFilterNames(new String[]{format.getFilterName(), "All files"});
            fd.setFilterExtensions(new String[]{format.getFilterExtention(), "*.*"});
        }
        String strSelectedPath = fd.open();
        if (strSelectedPath == null) {
            return null;
        }
        if (format == null) {
            format = SequenceFormat.values()[fd.getFilterIndex()];
        }
        String strSequence = "";
        try {
            String line;
            FileInputStream fos = new FileInputStream(strSelectedPath);
            BufferedReader br = new BufferedReader(new InputStreamReader(fos));
            while ((line = br.readLine()) != null) {
                strSequence = String.valueOf(strSequence) + line.trim();
                if (format == SequenceFormat.GWS) continue;
                strSequence = String.valueOf(strSequence) + System.lineSeparator();
            }
            br.close();
        }
        catch (IOException e) {
            LogUtils.report((Exception)e);
            return null;
        }
        if (strSequence.isEmpty()) {
            MessageBox box = new MessageBox(shell, 40);
            box.setText("Error in import sequence");
            box.setMessage("There is no sequence in the file.");
            box.open();
            return null;
        }
        List<Glycan> lGlycans = GlycanIOUtils.getGlycansFromSequence(strSequence, format, massOptions);
        if (lGlycans == null || lGlycans.isEmpty()) {
            return null;
        }
        return lGlycans;
    }

    public static void saveGlycanImage(List<Glycan> lGlycans, BuilderWorkspaceSWT bws, ImageFormat format) {
        if (lGlycans == null || lGlycans.isEmpty()) {
            return;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setText("Save image");
        fd.setOverwrite(true);
        if (format == null) {
            fd.setFilterNames(ImageFormat.getFilterNames());
            fd.setFilterExtensions(ImageFormat.getFilterExtensions());
        } else {
            fd.setFilterNames(new String[]{format.getFilterName()});
            fd.setFilterExtensions(new String[]{format.getFilterExtention()});
        }
        String strSelectedPath = fd.open();
        if (strSelectedPath == null) {
            return;
        }
        if (format == null) {
            format = ImageFormat.values()[fd.getFilterIndex()];
        }
        if (format.isAvailableInSWT()) {
            boolean opaque = true;
            Color colorOld = bws.getGlycanRenderer().getBackgroundColor();
            bws.getGlycanRenderer().setBackgroundColor(Display.getCurrent().getSystemColor(1));
            if (format == ImageFormat.PNG) {
                opaque = false;
            }
            Image img = bws.getGlycanRenderer().getImage(lGlycans, opaque, bws.getGraphicOptions().SHOW_MASSES, bws.getGraphicOptions().SHOW_REDEND);
            bws.getGlycanRenderer().setBackgroundColor(colorOld);
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{img.getImageData()};
            loader.save(strSelectedPath, format.getSWTImageConstant());
            return;
        }
        GlycanRendererAWT gr = bws.getGlycanRendererAWT();
        SVGUtils.export(gr, strSelectedPath, lGlycans, gr.getGraphicOptions().SHOW_MASSES, gr.getGraphicOptions().SHOW_REDEND, format.getIdentifier());
    }
}

