/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.io.MonosaccharideExporter;
import org.eurocarbdb.resourcesdb.io.StandardExporter;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.Ringtype;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;
import org.eurocarbdb.resourcesdb.monosaccharide.Stereocode;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.template.BasetypeTemplate;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;
import org.eurocarbdb.resourcesdb.template.TrivialnameTemplate;
import org.eurocarbdb.resourcesdb.util.NumberPrefix;
import org.eurocarbdb.resourcesdb.util.StringUtils;
import org.eurocarbdb.resourcesdb.util.Utils;

public class BcsdbExporter
extends StandardExporter
implements MonosaccharideExporter {
    private String configStr = null;
    private String basetypeStr = null;

    public BcsdbExporter() {
        this((Config)null, (TemplateContainer)null);
    }

    public BcsdbExporter(Config conf) {
        this(conf, null);
    }

    public BcsdbExporter(Config conf, TemplateContainer container) {
        super(GlycanNamescheme.BCSDB, conf, container);
    }

    @Override
    public String export(Monosaccharide ms) throws ResourcesDbException {
        return this.export(ms, this.getConfig().isForceTrivialNames());
    }

    public String export(Monosaccharide ms, boolean forceTrivial) throws ResourcesDbException {
        ArrayList<CoreModification> deoxyList;
        String outStr = "";
        if (ms.getConfiguration() == null) {
            String stereo = ms.getStereoStrWithoutAnomeric();
            ms.setConfiguration(Stereocode.getConfigurationFromStereoString(stereo));
        }
        TrivialnameTemplate trivTmpl = this.getTemplateContainer().getTrivialnameTemplateContainer().checkMsForTrivialname(GlycanNamescheme.BCSDB, ms);
        this.setUsedTrivialnameTemplate(trivTmpl);
        if (trivTmpl != null) {
            this.configStr = trivTmpl.isDefaultConfigIsCompulsory() ? "X" : String.valueOf(ms.getConfiguration().getBcsdbSymbol());
            this.basetypeStr = trivTmpl.getPrimaryName(this.getNamescheme());
        } else {
            this.formatConfigAndBasetypeStrings(ms);
        }
        outStr = outStr + ms.getAnomer().getBcsdbSymbol();
        outStr = outStr + this.configStr;
        ArrayList<CoreModification> anhydroList = ms.getCoreModifications(CoreModificationTemplate.ANHYDRO);
        if (anhydroList != null && anhydroList.size() > 0) {
            String anhydroStr = "";
            int anhydroCount = 0;
            for (CoreModification mod : anhydroList) {
                if (this.trivialnameHasCoremod(mod)) continue;
                if (anhydroCount > 0) {
                    anhydroStr = anhydroStr + ",";
                }
                int pos1 = mod.getIntValuePosition1();
                int pos2 = mod.getIntValuePosition2();
                anhydroStr = pos1 == 0 ? anhydroStr + "?" : anhydroStr + pos1;
                anhydroStr = anhydroStr + ",";
                anhydroStr = pos2 == 0 ? anhydroStr + "?" : anhydroStr + pos2;
                anhydroStr = anhydroStr + "anh";
                ++anhydroCount;
            }
            if (anhydroCount > 0) {
                outStr = outStr + anhydroStr;
            }
        }
        if ((deoxyList = ms.getCoreModifications(CoreModificationTemplate.DEOXY)) != null && deoxyList.size() > 0) {
            String deoxyStr = "";
            int deoxyCount = 0;
            for (CoreModification mod : deoxyList) {
                int pos;
                if (this.trivialnameHasCoremod(mod)) continue;
                if (deoxyCount > 0) {
                    deoxyStr = deoxyStr + ",";
                }
                deoxyStr = (pos = mod.getIntValuePosition1()) == 0 ? deoxyStr + "?" : deoxyStr + pos;
                ++deoxyCount;
            }
            if (deoxyCount > 0) {
                deoxyStr = deoxyStr + "d";
                outStr = outStr + deoxyStr;
            }
        }
        outStr = outStr + this.basetypeStr;
        outStr = ms.isAlditol() ? outStr + Ringtype.UNKNOWN.getBcsdbSymbol() : outStr + ms.getRingtype().getBcsdbSymbol();
        ArrayList<CoreModification> enList = ms.getEnModifications();
        if (enList != null && enList.size() > 0) {
            String enString = "";
            int enCount = 0;
            for (CoreModification mod : enList) {
                int pos;
                if (this.trivialnameHasCoremod(mod)) continue;
                if (enCount > 0) {
                    enString = enString + ",";
                }
                enString = (pos = mod.getIntValuePosition1()) == 0 ? enString + "?" : enString + pos;
                ++enCount;
            }
            if (enCount > 0) {
                enString = enCount == 1 ? enString + "en" : enString + (Object)((Object)NumberPrefix.forSize(enCount)) + "en";
                outStr = outStr + enString;
            }
        }
        outStr = outStr + this.formatSubstitutionsString(ms);
        if (ms.isUronic()) {
            outStr = outStr + "A";
        }
        ArrayList<CoreModification> uloList = ms.getCoreModifications(CoreModificationTemplate.KETO);
        String uloString = "";
        int uloCount = 0;
        if (uloList != null && uloList.size() > 0) {
            for (CoreModification mod : uloList) {
                if (this.trivialnameHasCoremod(mod)) continue;
                if (uloCount > 0) {
                    uloString = uloString + ",";
                }
                int pos = mod.getIntValuePosition1();
                uloString = uloString + "-";
                uloString = pos == 0 ? uloString + "?" : uloString + pos;
                ++uloCount;
            }
            if (uloCount > 0) {
                if (uloCount == 1 && uloString.equals("-2")) {
                    uloString = "";
                }
                uloString = uloString + "-";
                if (uloCount > 1) {
                    uloString = uloString + (Object)((Object)NumberPrefix.forSize(uloCount));
                }
                uloString = uloString + "ulo";
                outStr = outStr + uloString;
            }
        }
        if (ms.isAldonic()) {
            if (!this.trivialnameHasCoremod(ms.getCoreModification(CoreModificationTemplate.ACID, 1))) {
                outStr = uloCount > 0 ? outStr + "sonic" : outStr + "-onic";
            }
        } else if (ms.isAldaric() && !this.trivialnameHasCoremod(ms.getCoreModification(CoreModificationTemplate.ACID, ms.getSize()))) {
            outStr = uloCount > 0 ? outStr + "saric" : outStr + "-aric";
        }
        if (ms.isAlditol()) {
            outStr = outStr + "-ol";
        }
        return outStr;
    }

    private void formatConfigAndBasetypeStrings(Monosaccharide ms) throws ResourcesDbException {
        ArrayList<String> stereoList = Stereocode.prepareStereocodeForBasetypeDetermination(ms);
        this.configStr = "";
        if (stereoList.size() == 0) {
            this.configStr = this.configStr + StereoConfiguration.Unknown.getBcsdbSymbol();
            this.basetypeStr = StringUtils.camelCase(this.getTemplateContainer().getBasetypeTemplateContainer().getSuperclassTemplateBySize(ms.getSize()).getBaseName());
        } else if (stereoList.size() == 1) {
            this.configStr = this.configStr + Stereocode.getConfigurationFromStereoString(stereoList.get(0)).getBcsdbSymbol();
            BasetypeTemplate btTmpl = this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeTemplateByStereoString(stereoList.get(0));
            String basename = btTmpl.getBaseName();
            if (btTmpl.getSize() == ms.getSize()) {
                if (basename.equalsIgnoreCase("tro")) {
                    basename = "thr";
                }
                this.basetypeStr = StringUtils.camelCase(basename);
            } else {
                if (basename.equalsIgnoreCase("tro")) {
                    basename = "thr";
                }
                this.basetypeStr = basename + StringUtils.camelCase(this.getTemplateContainer().getBasetypeTemplateContainer().getSuperclassTemplateBySize(ms.getSize()).getBaseName());
            }
        } else {
            this.configStr = this.configStr + StereoConfiguration.Nonchiral.getBcsdbSymbol();
            this.basetypeStr = "";
            for (String stereoFragment : stereoList) {
                this.configStr = this.configStr + Stereocode.getConfigurationFromStereoString(stereoFragment).getBcsdbSymbol();
                if (stereoFragment.length() <= 1) continue;
                BasetypeTemplate btTmpl = this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeTemplateByStereoString(stereoFragment);
                this.basetypeStr = this.basetypeStr + btTmpl.getBaseName();
            }
            this.basetypeStr = this.basetypeStr + StringUtils.camelCase(this.getTemplateContainer().getBasetypeTemplateContainer().getSuperclassTemplateBySize(ms.getSize()).getBaseName());
        }
    }

    private String formatSubstitutionsString(Monosaccharide ms) throws ResourcesDbException {
        String substStr = "";
        int substCount = 0;
        for (Substitution subst : ms.getSubstitutions()) {
            Substitution trivSubst;
            int position1;
            String posStr = Utils.formatPositionsString(subst.getPosition1(), "/", "?");
            if (posStr.equals("2") && (subst.getTemplate().getName().equalsIgnoreCase(SubstituentTemplate.AMINOTEMPLATENAME) || subst.getTemplate().isExtendedAmine(this.getTemplateContainer().getSubstituentTemplateContainer())) && substCount == 0 && !subst.hasPosition2()) {
                posStr = "";
            }
            if (subst.hasPosition2()) {
                posStr = posStr + "," + Utils.formatPositionsString(subst.getPosition2(), "/", "?");
            }
            String substName = subst.getResidueIncludedName(GlycanNamescheme.BCSDB);
            if (this.getUsedTrivialnameTemplate() != null && (position1 = subst.getIntValuePosition1()) > 0 && (trivSubst = this.getUsedTrivialnameTemplate().getSubstitutionByPosition(position1)) != null) {
                if (trivSubst.equals(subst)) continue;
                if (trivSubst.getName().equals(SubstituentTemplate.AMINOTEMPLATENAME)) {
                    String substTmplSepDisp;
                    SubstituentTemplate oLinkedEquivTmpl;
                    String oLinkTmplSepDisp;
                    String oLinkedEquivName;
                    if (subst.getResidueIncludedName(this.getNamescheme()) != null && this.getTemplateContainer().getSubstituentTemplateContainer().forName(this.getNamescheme(), subst.getResidueIncludedName(this.getNamescheme())).getName().equals(SubstituentTemplate.AMINOTEMPLATENAME)) continue;
                    if (subst.getTemplate().isExtendedAmine(this.getTemplateContainer().getSubstituentTemplateContainer()) && (oLinkedEquivName = subst.getTemplate().getOLinkedEquivalent(this.getTemplateContainer().getSubstituentTemplateContainer())) != null && oLinkedEquivName.length() > 0 && StringUtils.strCmpNullEqualsEmpty(oLinkTmplSepDisp = (oLinkedEquivTmpl = this.getTemplateContainer().getSubstituentTemplateContainer().forName(GlycanNamescheme.GLYCOCT, oLinkedEquivName)).getSeparateDisplay(this.getNamescheme(), LinkageType.H_AT_OH), substTmplSepDisp = null)) {
                        oLinkedEquivName = oLinkedEquivTmpl.getPrimaryAlias(this.getNamescheme(), LinkageType.H_AT_OH).getResidueIncludedName();
                        substName = oLinkedEquivTmpl.getResidueIncludedName(this.getNamescheme(), LinkageType.H_AT_OH);
                        if (substName == null || substName.length() == 0) {
                            substName = oLinkedEquivTmpl.getSeparateDisplay(this.getNamescheme(), LinkageType.H_AT_OH);
                        }
                        if (oLinkedEquivName.startsWith("O")) {
                            oLinkedEquivName = oLinkedEquivName.substring(1);
                        }
                        if (oLinkedEquivName.startsWith("-")) {
                            oLinkedEquivName = oLinkedEquivName.substring(1);
                        }
                        substName = oLinkedEquivTmpl.equals(this.getTemplateContainer().getSubstituentTemplateContainer().forName(this.getNamescheme(), oLinkedEquivName)) ? oLinkedEquivName : subst.getResidueIncludedName(this.getNamescheme());
                    }
                }
            }
            if (substName == null || substName.length() <= 0) continue;
            substStr = substStr + posStr + substName;
            ++substCount;
        }
        return substStr;
    }

    private boolean trivialnameHasCoremod(CoreModification mod) {
        if (this.getUsedTrivialnameTemplate() != null) {
            return this.getUsedTrivialnameTemplate().hasCoreModification(mod);
        }
        return false;
    }
}

