/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.util;

import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class Scheduler
implements ThreadFactory {
    private final String threadNamePrefix;
    private final AtomicInteger counter = new AtomicInteger();
    private int scheduledTasks;
    private ScheduledExecutorService threadPool;

    public Scheduler(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }

    public synchronized ScheduledFuture<?> schedule(Runnable runnable, long initialDelayMillis) {
        return this.getThreadPool().schedule(runnable, initialDelayMillis, TimeUnit.MILLISECONDS);
    }

    public synchronized ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long initialDelayMillis, long refreshIntervalMillis) {
        ++this.scheduledTasks;
        return this.getThreadPool().scheduleAtFixedRate(runnable, initialDelayMillis, refreshIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public synchronized ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long initialDelayMillis, long refreshIntervalMillis) {
        ++this.scheduledTasks;
        return this.getThreadPool().scheduleWithFixedDelay(runnable, initialDelayMillis, refreshIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private synchronized ScheduledExecutorService getThreadPool() {
        if (this.threadPool == null) {
            this.threadPool = Executors.newScheduledThreadPool(1, this);
        }
        return this.threadPool;
    }

    public synchronized void unschedule(ScheduledFuture<?> future) {
        future.cancel(false);
        if (this.threadPool != null && --this.scheduledTasks <= 0) {
            this.threadPool.shutdownNow();
            this.threadPool = null;
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        return new Thread(ObjectUtils.getNatTableThreadGroup(), r, String.valueOf(this.threadNamePrefix) + "-" + this.counter.incrementAndGet());
    }

    public synchronized Future<?> submit(Runnable runnable) {
        return this.getThreadPool().submit(runnable);
    }
}

