/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.atom;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Isotope;
import org.eurocarbdb.resourcesdb.io.HibernateAccess;
import org.eurocarbdb.resourcesdb.util.NumberUtils;
import org.eurocarbdb.resourcesdb.util.Utils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Periodic {
    H(1, "H", "Hydrogen", 1.00794, true, 0.0708, -252.87, -259.34, 14.304, 13.598),
    HE(2, "He", "Helium", 4.002602, true, 0.124901, -268.93, -272.2, 5.193, 24.587),
    LI(3, "Li", "Lithium", 6.941, true, 0.534, 1342.0, 180.5, 3.582, 5.392),
    BE(4, "Be", "Beryllium", 9.012182, true, 1.85, 2471.0, 1287.0, 1.825, 9.323),
    B(5, "B", "Boron", 10.811, true, 2.37, 4000.0, 2075.0, 1.026, 8.298),
    C(6, "C", "Carbon", 12.0107, true, 2.267, 3842.0, 4492.0, 0.709, 11.26),
    N(7, "N", "Nitrogen", 14.0067, true, 0.807, -195.79, -210.0, 1.04, 14.534),
    O(8, "O", "Oxygen", 15.9994, true, 1.141, -182.95, -218.79, 0.918, 13.618),
    F(9, "F", "Fluorine", 18.9984032, true, 1.5, -188.12, -219.62, 0.824, 17.423),
    NE(10, "Ne", "Neon", 20.1797, true, 1.204, -246.08, -248.59, 1.03, 21.565),
    NA(11, "Na", "Sodium", 22.98977, true, 0.97, 883.0, 97.8, 1.228, 5.139),
    MG(12, "Mg", "Magnesium", 24.305, true, 1.74, 1090.0, 650.0, 1.023, 7.646),
    AL(13, "Al", "Aluminium", 26.981538, true, 2.7, 2519.0, 660.32, 0.897, 5.986),
    SI(14, "Si", "Silicon", 28.0855, true, 2.3296, 3265.0, 1414.0, 0.705, 8.152),
    P(15, "P", "Phosphorus", 30.973761, true, 1.82, 280.5, 44.15, 0.769, 10.487),
    S(16, "S", "Sulfur", 32.065, true, 2.067, 444.6, 115.21, 0.71, 10.36),
    CL(17, "Cl", "Chlorine", 35.453, true, 1.56, -34.04, -101.5, 0.479, 12.968),
    AR(18, "Ar", "Argon", 39.948, true, 1.396, -185.85, -189.35, 0.52, 15.76),
    K(19, "K", "Potassium", 39.0983, true, 0.89, 759.0, 63.38, 0.757, 4.341),
    CA(20, "Ca", "Calcium", 40.078, true, 1.54, 1484.0, 842.0, 0.647, 6.113),
    SC(21, "Sc", "Scandium", 44.95591, true, 2.99, 2836.0, 1541.0, 0.568, 6.561),
    TI(22, "Ti", "Titanium", 47.867, true, 4.5, 3287.0, 1668.0, 0.523, 6.828),
    V(23, "V", "Vanadium", 50.9415, true, 6.0, 3407.0, 1910.0, 0.489, 6.746),
    CR(24, "Cr", "Chromium", 51.9961, true, 7.15, 2671.0, 1907.0, 0.449, 6.767),
    MN(25, "Mn", "Manganese", 54.938049, true, 7.3, 2061.0, 1246.0, 0.479, 7.434),
    FE(26, "Fe", "Iron", 55.845, true, 7.875, 2861.0, 1538.0, 0.449, 7.902),
    CO(27, "Co", "Cobalt", 58.9332, true, 8.86, 2927.0, 1495.0, 0.421, 7.881),
    NI(28, "Ni", "Nickel", 58.6934, true, 8.912, 2913.0, 1455.0, 0.444, 7.64),
    CU(29, "Cu", "Copper", 63.546, true, 8.933, 2562.0, 1084.62, 0.385, 7.726),
    ZN(30, "Zn", "Zinc", 58.6934, true, 7.134, 907.0, 419.53, 0.388, 9.394),
    GA(31, "Ga", "Gallium", 69.7236, true, 5.91, 2204.0, 29.76, 0.371, 5.999),
    GE(32, "Ge", "Germanium", 72.64, true, 5.323, 2833.0, 938.25, 0.32, 7.9),
    AS(33, "As", "Arsenic", 74.9216, true, 5.776, 614.0, 817.0, 0.329, 9.815),
    SE(34, "Se", "Selenium", 78.96, true, 4.809, 685.0, 221.0, 0.321, 9.752),
    BR(35, "Br", "Bromine", 79.904, true, 3.11, 58.8, -7.2, 0.226, 11.814),
    KR(36, "Kr", "Krypton", 83.798, true, 2.418, -153.22, -157.36, 0.248, 14.0),
    RB(37, "Rb", "Rubidium", 85.4678, true, 1.53, 688.0, 39.31, 0.363, 4.177),
    SR(38, "Sr", "Strontium", 87.62, true, 2.64, 1382.0, 777.0, 0.301, 5.695),
    Y(39, "Y", "Yttrium", 88.90585, true, 4.47, 3345.0, 1522.0, 0.298, 6.217),
    ZR(40, "Zr", "Zirconium", 91.224, true, 6.52, 4409.0, 1855.0, 0.278, 6.634),
    NB(41, "Nb", "Niobium", 92.90638, true, 8.57, 4744.0, 2477.0, 0.265, 6.759),
    MO(42, "Mo", "Molybdenum", 95.94, true, 10.2, 4639.0, 2623.0, 0.251, 7.092),
    TC(43, "Tc", "Technetium", 98.0, false, 11.0, 4265.0, 2157.0, null, 7.28),
    RU(44, "Ru", "Ruthenium", 101.07, true, 12.1, 4150.0, 2334.0, 0.238, 7.361),
    RH(45, "Rh", "Rhodium", 102.9055, true, 12.4, 3695.0, 1964.0, 0.243, 7.459),
    PD(46, "Pd", "Palladium", 106.42, true, 12.0, 2963.0, 1554.9, 0.244, 8.337),
    AG(47, "Ag", "Silver", 107.8682, true, 10.501, 2162.0, 961.78, 0.235, 7.576),
    CD(48, "Cd", "Cadmium", 112.411, true, 8.69, 767.0, 321.07, 0.232, 8.994),
    IN(49, "In", "Indium", 114.818, true, 7.31, 2072.0, 156.6, 0.233, 5.786),
    SN(50, "Sn", "Tin", 118.71, true, 7.287, 2602.0, 231.93, 0.228, 7.344),
    SB(51, "Sb", "Antimony", 121.76, true, 6.685, 1587.0, 630.63, 0.207, 8.64),
    TE(52, "Te", "Tellurium", 127.6, true, 6.232, 988.0, 449.51, 0.202, 9.01),
    I(53, "I", "Iodine", 126.90447, true, 4.93, 184.4, 113.7, 0.145, 10.451),
    XE(54, "Xe", "Xenon", 131.293, true, 2.953, -108.04, -111.75, 0.158, 12.13),
    CS(55, "Cs", "Cesium", 132.90545, true, 1.93, 671.0, 28.44, 0.242, 3.894),
    BA(56, "Ba", "Barium", 137.327, true, 3.62, 1897.0, 727.0, 0.204, 5.212),
    LA(57, "La", "Lathanum", 138.9055, true, 6.15, 3464.0, 918.0, 0.195, 5.577),
    CE(58, "Ce", "Cerium", 140.116, true, 8.16, 3443.0, 798.0, 0.192, 5.539),
    PR(59, "Pr", "Praseodymium", 140.907648, true, 6.77, 3520.0, 931.0, 0.193, 5.464),
    ND(60, "Nd", "Neodymium", 144.24, true, 7.01, 3074.0, 1021.0, 0.19, 5.525),
    PM(61, "Pm", "Prometium", 145.0, false, 7.26, 3000.0, 1042.0, null, 5.55),
    SM(62, "Sm", "Samarium", 150.36, true, 7.52, 1794.0, 1074.0, 0.197, 5.644),
    EU(63, "Eu", "Europium", 151.964, true, 5.24, 1596.0, 822.0, 0.182, 5.67),
    GD(64, "Gd", "Gadolinium", 157.25, true, 7.9, 3273.0, 1313.0, 0.236, 6.15),
    TB(65, "Tb", "Terbium", 158.92534, true, 8.23, 3230.0, 1356.0, 0.182, 5.864),
    DY(66, "Dy", "Dysprosium", 162.5, true, 8.55, 2567.0, 1412.0, 0.173, 5.939),
    HO(67, "Ho", "Holmium", 164.93032, true, 8.8, 2700.0, 1474.0, 0.165, 6.022),
    ER(68, "Er", "Erbium", 167.259, true, 9.07, 2868.0, 1529.0, 0.168, 6.108),
    TM(69, "Tm", "Thulium", 168.93421, true, 9.32, 1950.0, 1545.0, 0.16, 6.184),
    YB(70, "Yb", "Ytterbium", 173.04, true, 6.9, 1196.0, 819.0, 0.155, 6.254),
    LU(71, "Lu", "Lutetium", 174.967, true, 9.84, 3402.0, 1663.0, 0.154, 5.426),
    HF(72, "Hf", "Hafnium", 178.49, true, 13.3, 4603.0, 2233.0, 0.144, 6.825),
    TA(73, "Ta", "Tantalum", 180.9479, true, 16.4, 5458.0, 3017.0, 0.14, 7.89),
    W(74, "W", "Tungsten", 178.49, true, 19.3, 5555.0, 3422.0, 0.132, 7.98),
    RE(75, "Re", "Rhenium", 186.207, true, 20.8, null, 3186.0, 0.137, 7.88),
    OS(76, "Os", "Osmium", 190.23, true, 22.5, 5012.0, 3033.0, 0.13, 8.7),
    IR(77, "Ir", "Iridium", 192.217, true, 22.5, null, null, 0.131, 9.1),
    PT(78, "Pt", "Platinum", 195.078, true, 21.46, 3825.0, 1768.4, 0.133, 9.0),
    AU(79, "Au", "Gold", 196.966552, true, 19.282, 2856.0, 1064.18, 0.129, 9.226),
    HG(80, "Hg", "Mercury", 200.59, true, 13.5336, 356.73, -38.83, 0.14, 10.438),
    TL(81, "Tl", "Thallium", 204.3833, true, null, null, 1473.0, 0.129, 6.108),
    PB(82, "Pb", "Lead", 207.2, true, 11.342, 1749.0, 327.46, 0.129, 7.417),
    BI(83, "Bi", "Bismuth", 208.98038, true, 9.807, 1564.0, 271.4, 0.122, 7.289),
    PO(84, "Po", "Polonium", 209.0, false, 9.32, null, 254.0, null, 8.417),
    AT(85, "At", "Astatine", 210.0, false, null, null, 302.0, null, null),
    RN(86, "Rn", "Radon", 222.0, false, 4.4, -61.7, -71.0, 0.094, 10.749),
    FR(87, "Fr", "Francium", 223.0, false, null, null, 27.0, null, null),
    RA(88, "Ra", "Radium", 226.0, false, 5.0, null, 700.0, null, 5.279),
    AC(89, "Ac", "Actinium", 227.0, false, 10.07, 3198.0, 1051.0, null, 5.17),
    TH(90, "Th", "Thorium", 232.0381, false, 11.72, 4788.0, 1750.0, 0.113, 6.08),
    PA(91, "Pa", "Protactinium", 231.03588, false, 15.37, null, 1572.0, null, 5.89),
    U(92, "U", "Uranium", 238.02891, false, 18.95, 4131.0, 1135.0, 0.116, 6.194),
    NP(93, "Np", "Neptunium", 237.0, false, 20.25, null, 644.0, null, 6.266),
    PU(94, "Pu", "Plutonium", 237.0, false, 19.84, 3228.0, 640.0, null, 6.06),
    AM(95, "Am", "Americium", 243.0, false, 3.69, 2011.0, 1176.0, null, 5.993),
    CM(96, "Cm", "Curium", 247.0, false, 13.51, null, 1345.0, null, 6.02),
    BK(97, "Bk", "Berkelium", 247.0, false, 14.0, null, 1050.0, null, 6.23),
    CF(98, "Cf", "Californium", 251.0, false, null, null, 900.0, null, 6.3),
    ES(99, "Es", "Einsteinium", 252.0, false, null, null, 860.0, null, 6.42),
    FM(100, "Fm", "Fermium", 257.0, false, null, null, 1527.0, null, 6.5),
    MD(101, "Md", "Mendelevium", 258.0, false, null, null, 827.0, null, 6.58),
    NO(102, "No", "Nobelium", 259.0, false, null, null, 827.0, null, 6.65),
    LR(103, "Lr", "Lawrencium", 262.0, false, null, null, 1627.0, null, null),
    RF(104, "Rf", "Rutherfordium", 261.0, false, null, null, null, null, null),
    DB(105, "Db", "Dubnium", 262.0, false, null, null, null, null, null),
    SG(106, "Sg", "Seaborgium", 266.0, false, null, null, null, null, null),
    BH(107, "Bh", "Bohrium", 264.0, false, null, null, null, null, null),
    HS(108, "Hs", "Hassium", 277.0, false, null, null, null, null, null),
    MT(109, "Mt", "Meitnerium", 268.0, false, null, null, null, null, null),
    DS(110, "Ds", "Darmstadtium", 281.0, false, null, null, null, null, null);

    private String symbol;
    private int periodicNumber;
    private String name;
    private Double avgMass;
    private boolean stable;
    private Double density;
    private Double boilingPoint;
    private Double meltingPoint;
    private Double specificHeat;
    private Double ionisationPotential;
    private Set<Isotope> isotopes;

    private Periodic() {
        this.init();
    }

    private Periodic(int periodicNum, String symbolStr, String nameStr, Double mass, boolean isStable, Double dens, Double boiling, Double melting, Double specific, Double ionisPot, Isotope[] isos) {
        this.setPeriodicNumber(periodicNum);
        this.setSymbol(symbolStr);
        this.setName(nameStr);
        this.setAvgMass(mass);
        this.setStable(isStable);
        this.setDensity(dens);
        this.setBoilingPoint(boiling);
        this.setMeltingPoint(melting);
        this.setSpecificHeat(specific);
        this.setIonisationPotential(ionisPot);
        if (isos != null) {
            this.setIsotopes(new HashSet<Isotope>());
            for (int i = 0; i < isos.length; ++i) {
                this.getIsotopes().add(isos[i]);
            }
        } else {
            this.setIsotopes(null);
        }
    }

    private Periodic(int periodicNum, String symbolStr, String nameStr, Double mass, boolean isStable, Double dens, Double boiling, Double melting, Double specific, Double ionisPot) {
        this(periodicNum, symbolStr, nameStr, mass, isStable, dens, boiling, melting, specific, ionisPot, null);
    }

    public Double getAvgMass() {
        return this.avgMass;
    }

    public void setAvgMass(double avgMass) {
        this.avgMass = new Double(avgMass);
    }

    public void setAvgMass(Double avgMass) {
        this.avgMass = avgMass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPeriodicNumber() {
        return this.periodicNumber;
    }

    public void setPeriodicNumber(int periodicNumber) {
        this.periodicNumber = periodicNumber;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public Double getBoilingPoint() {
        return this.boilingPoint;
    }

    public void setBoilingPoint(double boilingPoint) {
        this.boilingPoint = new Double(boilingPoint);
    }

    public void setBoilingPoint(Double boilingPoint) {
        this.boilingPoint = boilingPoint;
    }

    public Double getDensity() {
        return this.density;
    }

    public void setDensity(double density) {
        this.density = new Double(density);
    }

    public void setDensity(Double density) {
        this.density = density;
    }

    public Double getIonisationPotential() {
        return this.ionisationPotential;
    }

    public void setIonisationPotential(double ionisationPotential) {
        this.ionisationPotential = new Double(ionisationPotential);
    }

    public void setIonisationPotential(Double ionisationPotential) {
        this.ionisationPotential = ionisationPotential;
    }

    public Double getMeltingPoint() {
        return this.meltingPoint;
    }

    public void setMeltingPoint(double meltingPoint) {
        this.meltingPoint = new Double(meltingPoint);
    }

    public void setMeltingPoint(Double meltingPoint) {
        this.meltingPoint = meltingPoint;
    }

    public Double getSpecificHeat() {
        return this.specificHeat;
    }

    public void setSpecificHeat(double specificHeat) {
        this.specificHeat = new Double(specificHeat);
    }

    public void setSpecificHeat(Double specificHeat) {
        this.specificHeat = specificHeat;
    }

    public boolean isStable() {
        return this.stable;
    }

    public void setStable(boolean stable) {
        this.stable = stable;
    }

    public Set<Isotope> getIsotopes() {
        block3: {
            if (this.isotopes == null) {
                try {
                    Periodic.setData(Config.getGlobalConfig());
                }
                catch (ResourcesDbException rEx) {
                    if (Config.getGlobalConfig().getPrintErrorMsgLevel() <= 0) break block3;
                    System.err.println(rEx);
                }
            }
        }
        return this.isotopes;
    }

    public void setIsotopes(Set<Isotope> isotopes) {
        this.isotopes = isotopes;
    }

    public void addIsotope(Isotope iso) {
        if (this.isotopes == null) {
            this.isotopes = new HashSet<Isotope>();
        }
        this.isotopes.add(iso);
    }

    public Isotope getMostAbundantIsotope() {
        Isotope retIso = null;
        for (Isotope iso : this.getIsotopes()) {
            if (retIso == null) {
                retIso = iso;
                continue;
            }
            if (iso.getAbundance() > retIso.getAbundance()) {
                retIso = iso;
                continue;
            }
            if (iso.getAbundance() != retIso.getAbundance() || !(iso.getMass() < retIso.getMass())) continue;
            retIso = iso;
        }
        return retIso;
    }

    public int getIsotopesCount() {
        if (this.getIsotopes() != null) {
            return this.getIsotopes().size();
        }
        return 0;
    }

    public static Periodic getElementBySymbol(String symbol) throws ResourcesDbException {
        for (Periodic elem : Periodic.values()) {
            if (!elem.getSymbol().equals(symbol)) continue;
            return elem;
        }
        throw new ResourcesDbException("Element symbol " + symbol + " not available.");
    }

    public static Periodic getElementByNumber(int number) throws ResourcesDbException {
        Periodic el = null;
        for (Periodic elem : Periodic.values()) {
            if (elem.getPeriodicNumber() != number) continue;
            return elem;
        }
        if (el == null) {
            throw new ResourcesDbException("Element number " + number + " not available.");
        }
        return el;
    }

    public static ArrayList<Periodic> getElementsList() throws ResourcesDbException {
        ArrayList<Periodic> elementsList = new ArrayList<Periodic>();
        for (Periodic elem : Periodic.values()) {
            elementsList.add(elem);
        }
        return elementsList;
    }

    public static boolean dataIsSet() {
        return true;
    }

    public static void setData(Config conf) throws ResourcesDbException {
        Periodic.setDataFromXmlFile(conf.getElementsXmlUrl());
    }

    public static void setDataIfNotSet(Config conf) throws ResourcesDbException {
        if (!Periodic.dataIsSet()) {
            Periodic.setData(conf);
        }
    }

    public static void setDataFromXmlFile(URL xmlUrl) throws ResourcesDbException {
        SAXBuilder parser = new SAXBuilder();
        try {
            Document doc = parser.build(xmlUrl);
            Element root = doc.getRootElement();
            List templateList = root.getChildren();
            for (Element xmlElement : templateList) {
                Periodic el = Periodic.getElementFromXmlTree(xmlElement);
                if (el.name == null) continue;
            }
        }
        catch (JDOMException je) {
            throw new ResourcesDbException("JDOMException: " + je.getMessage());
        }
        catch (IOException ie) {
            throw new ResourcesDbException("IOException: " + ie.getMessage());
        }
    }

    private static Periodic getElementFromXmlTree(Element xmlElement) {
        Periodic e = null;
        if (xmlElement.getName().equals("element")) {
            try {
                e = Periodic.getElementByNumber(Integer.parseInt(xmlElement.getAttributeValue("atomic_number")));
            }
            catch (NumberFormatException e1) {
                e1.printStackTrace();
            }
            catch (ResourcesDbException e1) {
                e1.printStackTrace();
            }
            List childList = xmlElement.getChildren("isotope");
            if (childList != null) {
                for (Element xmlIso : childList) {
                    Isotope iso = Periodic.getIsotopeFromXmlTree(xmlIso, e);
                    e.addIsotope(iso);
                }
            }
        }
        return e;
    }

    private static Isotope getIsotopeFromXmlTree(Element xmlElement, Periodic e) {
        Isotope iso = null;
        if (xmlElement.getName().equalsIgnoreCase("isotope")) {
            iso = new Isotope(e, Integer.parseInt(xmlElement.getAttributeValue("neutron_count")));
            iso.setMass(NumberUtils.parseDoubleStr(xmlElement.getAttributeValue("mass"), null));
            iso.setAbundance(NumberUtils.parseDoubleStr(xmlElement.getAttributeValue("frequency"), null));
            iso.setCommonName(xmlElement.getAttributeValue("common_name"));
            iso.setHalfLife(xmlElement.getAttributeValue("half_life"));
            iso.setSpin(xmlElement.getAttributeValue("spin"));
            iso.setStable(Utils.parseTrueFalseString(xmlElement.getAttributeValue("stable"), null));
        }
        return iso;
    }

    public static void setDataFromDB() throws ResourcesDbException {
        ArrayList<Periodic> elemList = null;
        try {
            elemList = HibernateAccess.getElementListFromDB();
        }
        catch (Throwable e) {
            System.err.println(e);
        }
        if (elemList == null) {
            throw new ResourcesDbException("Cannot set element list from database.");
        }
        HashMap<String, Periodic> bySymbolMap = new HashMap<String, Periodic>();
        HashMap<Integer, Periodic> byNumberMap = new HashMap<Integer, Periodic>();
        for (Periodic elem : elemList) {
            bySymbolMap.put(elem.getSymbol().toUpperCase(), elem);
            byNumberMap.put(new Integer(elem.getPeriodicNumber()), elem);
        }
    }

    public void init() {
        this.setSymbol("");
        this.setPeriodicNumber(0);
        this.setName("");
        this.setAvgMass(null);
        this.setStable(true);
        this.setMeltingPoint(null);
        this.setBoilingPoint(null);
        this.setIonisationPotential(null);
        this.setSpecificHeat(null);
        this.setDensity(null);
        this.setIsotopes(new HashSet<Isotope>());
    }

    public String toString() {
        String outStr = "Element " + this.getPeriodicNumber() + " | symbol: " + this.getSymbol() + " | name: " + this.getName() + " | stable: " + this.isStable() + " | avg. mass: " + this.getAvgMass();
        outStr = outStr + " | density: " + this.getDensity();
        outStr = outStr + " | melting/boiling point: " + this.getMeltingPoint() + "/" + this.getBoilingPoint();
        outStr = outStr + " | specific heat: " + this.getSpecificHeat();
        outStr = outStr + " | ion. pot.: " + this.getIonisationPotential();
        return outStr;
    }
}

