/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.table.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnChooserUtils;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnEntry;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnGroupEntry;
import org.eclipse.nebula.widgets.nattable.columnChooser.ISelectionTreeListener;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.command.ColumnGroupExpandCollapseCommand;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnsAndGroupsCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.display.control.table.dialog.ColumnChooserDialog;
import org.grits.toolbox.display.control.table.dialog.GRITSColumnEntry;
import org.grits.toolbox.display.control.table.dialog.GRITSTableColumnChooserDialog;
import org.grits.toolbox.display.control.table.tablecore.GRITSColumnChooserUtils;
import org.grits.toolbox.display.control.table.tablecore.IGritsTable;

public class GRITSTableColumnChooser {
    private static final Comparator<ColumnEntry> COLUMN_ENTRY_LABEL_COMPARATOR = new Comparator<ColumnEntry>(){

        @Override
        public int compare(ColumnEntry o1, ColumnEntry o2) {
            return ((GRITSColumnEntry)o1).getLabel().compareToIgnoreCase(((GRITSColumnEntry)o2).getLabel());
        }
    };
    protected ColumnChooserDialog columnChooserDialog;
    protected List<ColumnEntry> hiddenColumnEntries;
    protected List<ColumnEntry> visibleColumnsEntries;
    protected boolean sortAvailableColumns;
    protected Boolean asGlobalPreference = null;
    protected IGritsTable gritsTable = null;

    public GRITSTableColumnChooser(Shell shell, boolean sortAvailableColumns, boolean asGlobalPreference, IGritsTable gritsTable) {
        this.gritsTable = gritsTable;
        this.sortAvailableColumns = sortAvailableColumns;
        this.asGlobalPreference = asGlobalPreference;
        this.columnChooserDialog = this.getNewColumnChooserDialog(shell);
    }

    protected ColumnChooserDialog getNewColumnChooserDialog(Shell shell) {
        this.columnChooserDialog = this.asGlobalPreference != false ? new ColumnChooserDialog(shell, Messages.getString((String)"ColumnChooser.availableColumns"), Messages.getString((String)"ColumnChooser.selectedColumns")) : new GRITSTableColumnChooserDialog(shell, Messages.getString((String)"ColumnChooser.availableColumns"), Messages.getString((String)"ColumnChooser.selectedColumns"), this);
        return this.columnChooserDialog;
    }

    public IGritsTable getGRITSTable() {
        return this.gritsTable;
    }

    protected boolean hasColumnGroupHeader() {
        return this.gritsTable.hasColumnGroupHeader();
    }

    protected ColumnHideShowLayer getColumnHideShowLayer() {
        return this.gritsTable.getColumnHideShowLayer();
    }

    protected DataLayer getColumnHeaderDataLayer() {
        return this.gritsTable.getColumnHeaderDataLayer();
    }

    protected ColumnHeaderLayer getColumnHeaderLayer() {
        return this.gritsTable.getColumnHeaderLayer();
    }

    protected ColumnGroupModel getColumnGroupModel() {
        return this.gritsTable.getColumnGroupModel();
    }

    protected SelectionLayer getSelectionLayer() {
        return this.gritsTable.getSelectionLayer();
    }

    public void reInit(IGritsTable gritsTable) {
        this.gritsTable = gritsTable;
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.columnChooserDialog.setDialogSettings(dialogSettings);
    }

    public ColumnChooserDialog getColumnChooserDialog() {
        return this.columnChooserDialog;
    }

    public void createDialog() {
        this.columnChooserDialog.create();
    }

    public List<ColumnEntry> getVisibleColumnsEntries() {
        return this.visibleColumnsEntries;
    }

    public List<ColumnEntry> getVisibleColumnEntries() {
        List<ColumnEntry> columnEntries = GRITSColumnChooserUtils.getVisibleColumnsEntries(this.getColumnHideShowLayer(), this.getColumnHeaderLayer(), this.getColumnHeaderDataLayer());
        return columnEntries;
    }

    public List<ColumnEntry> getHiddenColumnEntries() {
        List<ColumnEntry> columnEntries = GRITSColumnChooserUtils.getHiddenColumnEntries(this.getColumnHideShowLayer(), this.getColumnHeaderLayer(), this.getColumnHeaderDataLayer());
        if (this.sortAvailableColumns) {
            Collections.sort(columnEntries, COLUMN_ENTRY_LABEL_COMPARATOR);
        }
        return columnEntries;
    }

    public void populateDialog() {
        if (this.gritsTable == null || this.gritsTable.getColumnHeaderDataLayer().getColumnCount() == 0) {
            return;
        }
        this.hiddenColumnEntries = this.getHiddenColumnEntries();
        this.columnChooserDialog.populateAvailableTree(this.hiddenColumnEntries, this.getColumnGroupModel());
        this.visibleColumnsEntries = this.getVisibleColumnEntries();
        this.columnChooserDialog.populateSelectedTree(this.visibleColumnsEntries, this.getColumnGroupModel());
        this.columnChooserDialog.expandAllLeaves();
    }

    public void openDialog() {
        this.columnChooserDialog.open();
    }

    public void addListenersOnColumnChooserDialog() {
        this.columnChooserDialog.addListener(new ISelectionTreeListener(){

            public void itemsRemoved(List<ColumnEntry> removedItems) {
                List<ColumnEntry> toBeRemoved = removedItems;
                if (!GRITSTableColumnChooser.this.asGlobalPreference.booleanValue() && ((GRITSTableColumnChooserDialog)GRITSTableColumnChooser.this.columnChooserDialog).isPropigateSelected()) {
                    toBeRemoved = GRITSTableColumnChooser.this.propigateSelectedItems(removedItems, GRITSTableColumnChooser.this.visibleColumnsEntries);
                }
                ColumnChooserUtils.hideColumnEntries(toBeRemoved, (ColumnHideShowLayer)GRITSTableColumnChooser.this.getColumnHideShowLayer());
                GRITSTableColumnChooser.this.refreshColumnChooserDialog();
            }

            public void itemsSelected(List<ColumnEntry> addedItems) {
                List<ColumnEntry> toBeAdded = addedItems;
                if (!GRITSTableColumnChooser.this.asGlobalPreference.booleanValue() && ((GRITSTableColumnChooserDialog)GRITSTableColumnChooser.this.columnChooserDialog).isPropigateSelected()) {
                    toBeAdded = GRITSTableColumnChooser.this.propigateSelectedItems(addedItems, GRITSTableColumnChooser.this.hiddenColumnEntries);
                }
                ColumnChooserUtils.showColumnEntries(toBeAdded, (ColumnHideShowLayer)GRITSTableColumnChooser.this.getColumnHideShowLayer());
                GRITSTableColumnChooser.this.refreshColumnChooserDialog();
                GRITSTableColumnChooser.this.columnChooserDialog.setSelectionIncludingNested(ColumnChooserUtils.getColumnEntryIndexes(addedItems));
            }

            public void itemsMoved(SelectionLayer.MoveDirectionEnum direction, List<ColumnGroupEntry> movedColumnGroupEntries, List<ColumnEntry> movedColumnEntries, List<List<Integer>> fromPositions, List<Integer> toPositions) {
                this.moveItems(direction, movedColumnGroupEntries, movedColumnEntries, fromPositions, toPositions);
            }

            private void moveItems(SelectionLayer.MoveDirectionEnum direction, List<ColumnGroupEntry> movedColumnGroupEntries, List<ColumnEntry> movedColumnEntries, List<List<Integer>> fromPositions, List<Integer> toPositions) {
                int i = 0;
                while (i < fromPositions.size()) {
                    boolean columnGroupMoved = this.columnGroupMoved(fromPositions.get(i), movedColumnGroupEntries);
                    boolean multipleColumnsMoved = fromPositions.get(i).size() > 1;
                    ReorderColumnsAndGroupsCommand command = null;
                    if (!columnGroupMoved && !multipleColumnsMoved) {
                        int fromPosition = fromPositions.get(i).get(0);
                        int toPosition = this.adjustToPosition(direction, (int)toPositions.get(i));
                        command = new ColumnReorderCommand((ILayer)GRITSTableColumnChooser.this.getColumnHideShowLayer(), fromPosition, toPosition);
                    } else if (columnGroupMoved && multipleColumnsMoved) {
                        command = new ReorderColumnsAndGroupsCommand((ILayer)GRITSTableColumnChooser.this.getColumnHideShowLayer(), fromPositions.get(i), this.adjustToPosition(direction, toPositions.get(i)));
                    } else if (!columnGroupMoved && multipleColumnsMoved) {
                        command = new MultiColumnReorderCommand((ILayer)GRITSTableColumnChooser.this.getColumnHideShowLayer(), fromPositions.get(i), this.adjustToPosition(direction, toPositions.get(i)));
                    } else if (columnGroupMoved && !multipleColumnsMoved) {
                        command = new ReorderColumnGroupCommand((ILayer)GRITSTableColumnChooser.this.getColumnHideShowLayer(), fromPositions.get(i).get(0).intValue(), this.adjustToPosition(direction, toPositions.get(i)));
                    }
                    GRITSTableColumnChooser.this.getColumnHideShowLayer().doCommand(command);
                    ++i;
                }
                GRITSTableColumnChooser.this.refreshColumnChooserDialog();
                GRITSTableColumnChooser.this.columnChooserDialog.setSelectionIncludingNested(ColumnChooserUtils.getColumnEntryIndexes(movedColumnEntries));
            }

            private int adjustToPosition(SelectionLayer.MoveDirectionEnum direction, Integer toColumnPosition) {
                if (SelectionLayer.MoveDirectionEnum.DOWN == direction) {
                    return toColumnPosition + 1;
                }
                return toColumnPosition;
            }

            private boolean columnGroupMoved(List<Integer> fromPositions, List<ColumnGroupEntry> movedColumnGroupEntries) {
                for (ColumnGroupEntry columnGroupEntry : movedColumnGroupEntries) {
                    if (!fromPositions.contains(columnGroupEntry.getFirstElementPosition())) continue;
                    return true;
                }
                return false;
            }

            public void itemsCollapsed(ColumnGroupEntry columnGroupEntry) {
                int index = columnGroupEntry.getFirstElementIndex();
                int position = GRITSTableColumnChooser.this.getSelectionLayer().getColumnPositionByIndex(index);
                GRITSTableColumnChooser.this.getSelectionLayer().doCommand((ILayerCommand)new ColumnGroupExpandCollapseCommand((ILayer)GRITSTableColumnChooser.this.getSelectionLayer(), position));
            }

            public void itemsExpanded(ColumnGroupEntry columnGroupEntry) {
                int index = columnGroupEntry.getFirstElementIndex();
                int position = GRITSTableColumnChooser.this.getSelectionLayer().getColumnPositionByIndex(index);
                GRITSTableColumnChooser.this.getSelectionLayer().doCommand((ILayerCommand)new ColumnGroupExpandCollapseCommand((ILayer)GRITSTableColumnChooser.this.getSelectionLayer(), position));
            }
        });
    }

    public List<ColumnEntry> propigateSelectedItems(List<ColumnEntry> selectedItems, List<ColumnEntry> selectedList) {
        ArrayList<ColumnEntry> newList = new ArrayList<ColumnEntry>();
        int i = 0;
        while (i < selectedList.size()) {
            ColumnEntry selEntry = selectedList.get(i);
            int j = 0;
            while (j < selectedItems.size()) {
                ColumnEntry otherEntry = selectedItems.get(j);
                if (((GRITSColumnEntry)selEntry).getKey().equals(((GRITSColumnEntry)otherEntry).getKey())) {
                    newList.add(selEntry);
                }
                ++j;
            }
            ++i;
        }
        return newList;
    }

    protected void refreshColumnChooserDialog() {
        this.hiddenColumnEntries = this.getHiddenColumnEntries();
        this.visibleColumnsEntries = this.getVisibleColumnEntries();
        this.columnChooserDialog.removeAllLeaves();
        this.columnChooserDialog.populateSelectedTree(this.visibleColumnsEntries, this.getColumnGroupModel());
        this.columnChooserDialog.populateAvailableTree(this.hiddenColumnEntries, this.getColumnGroupModel());
        this.columnChooserDialog.expandAllLeaves();
    }
}

