/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Atom;
import org.eurocarbdb.application.glycanbuilder.Isotope;
import org.eurocarbdb.application.glycanbuilder.MassUtils;
import org.eurocarbdb.application.glycanbuilder.Molecule;
import org.eurocarbdb.application.glycanbuilder.Pair;

public class MSUtils {
    private static final double OUTPUT_TOLERANCE = 0.01;
    private static final double COMPUTE_TOLERANCE = 1.0E-6;

    public static double[][] average(Collection<double[][]> curves, boolean show_all) {
        int i;
        if (curves.size() == 0) {
            return null;
        }
        double mass_tol = show_all ? 1.0E-4 : 0.5;
        Vector<Pair> accumulated = new Vector<Pair>();
        for (double[][] curve : curves) {
            i = 0;
            block1: for (int l = 0; l < curve[0].length; ++l) {
                while (true) {
                    if (i >= accumulated.size() || curve[0][l] < (Double)((Pair)accumulated.get(i)).getFirst() - mass_tol) {
                        accumulated.insertElementAt(new Pair((Object)curve[0][l], (Object)curve[1][l]), i);
                        continue block1;
                    }
                    if (curve[0][l] <= (Double)((Pair)accumulated.get(i)).getFirst() + mass_tol) {
                        Pair dest = (Pair)accumulated.get(i);
                        dest.setSecond((Object)((Double)dest.getSecond() + curve[1][l]));
                        continue block1;
                    }
                    ++i;
                }
            }
        }
        int count = accumulated.size();
        int no_curves = curves.size();
        i = 0;
        double[][] ret = new double[][]{new double[count], new double[count]};
        for (Pair min : accumulated) {
            ret[0][i] = (Double)min.getFirst();
            ret[1][i] = (Double)min.getSecond() / (double)no_curves;
            ++i;
        }
        return ret;
    }

    public static void adjust(double[][] data, double mz_ratio, double intensity) {
        int i;
        double mass_shift = 0.0;
        for (i = 0; i < data[0].length; ++i) {
            if (data[1][i] != 1.0) continue;
            mass_shift = mz_ratio - data[0][i];
            break;
        }
        i = 0;
        while (i < data[0].length) {
            double[] dArray = data[0];
            int n = i;
            dArray[n] = dArray[n] + mass_shift;
            double[] dArray2 = data[1];
            int n2 = i++;
            dArray2[n2] = dArray2[n2] * intensity;
        }
    }

    public static double[][] getIsotopesCurve(int no_molecules, String molecule, boolean show_all) throws Exception {
        return MSUtils.getIsotopesCurve(no_molecules, new Molecule(molecule), show_all);
    }

    public static double[][] getIsotopesCurve(int no_molecules, Molecule m, boolean show_all) throws Exception {
        TreeMap<Double, Double> mol_massint = new TreeMap<Double, Double>();
        mol_massint.put(0.0, 1.0);
        for (Map.Entry a : m.getAtoms()) {
            double[][] atom_massint = MSUtils.getAtomIsotopesCurve(no_molecules * (Integer)a.getValue(), ((Atom)a.getKey()).getSymbol());
            TreeMap<Double, Double> new_mol_massint = new TreeMap<Double, Double>();
            for (Map.Entry mi : mol_massint.entrySet()) {
                double old_mass = (Double)mi.getKey();
                double old_int = (Double)mi.getValue();
                for (int i = 0; i < atom_massint[0].length; ++i) {
                    double new_mass = old_mass + atom_massint[0][i];
                    double new_int = old_int * atom_massint[1][i];
                    Double cur_int = (Double)new_mol_massint.get(new_mass);
                    if (cur_int == null) {
                        new_mol_massint.put(new_mass, new_int);
                        continue;
                    }
                    new_mol_massint.put(new_mass, cur_int + new_int);
                }
            }
            mol_massint = new_mol_massint;
        }
        double last_mass = 0.0;
        double mass_tol = show_all ? 1.0E-4 : 0.5;
        int no_charges = no_molecules * m.getNoCharges();
        Vector<Pair> mol_accumulated = new Vector<Pair>();
        for (Map.Entry mi : mol_massint.entrySet()) {
            double mass = (Double)mi.getKey();
            if (no_charges > 0) {
                mass -= (double)no_charges * MassUtils.electron.getMainMass();
                mass /= (double)Math.abs(no_charges);
            }
            double rel_int = (Double)mi.getValue();
            if (mol_accumulated.size() == 0 || mass - last_mass > mass_tol) {
                mol_accumulated.add(new Pair((Object)mass, (Object)rel_int));
                last_mass = mass;
                continue;
            }
            double old_rel_int = (Double)((Pair)mol_accumulated.get(mol_accumulated.size() - 1)).getSecond();
            ((Pair)mol_accumulated.get(mol_accumulated.size() - 1)).setSecond((Object)(old_rel_int + rel_int));
        }
        int count = 0;
        for (Pair mi : mol_accumulated) {
            if (!((Double)mi.getSecond() > 0.01)) continue;
            ++count;
        }
        int i = 0;
        double[][] ret = new double[][]{new double[count], new double[count]};
        for (Pair mi : mol_accumulated) {
            if (!((Double)mi.getSecond() > 0.01)) continue;
            ret[0][i] = (Double)mi.getFirst();
            ret[1][i] = (Double)mi.getSecond();
            ++i;
        }
        return ret;
    }

    private static double[][] getAtomIsotopesCurve(int no_atoms, String atom_name) throws Exception {
        if (no_atoms == 0) {
            return new double[0][];
        }
        Atom atom = MassUtils.getAtom((String)atom_name);
        if (atom == null) {
            throw new Exception("Invalid atom name: " + atom_name);
        }
        Isotope main_isotope = MassUtils.getMainIsotope((Atom)atom);
        if (main_isotope == null) {
            throw new Exception("No isotopic information for atom: " + atom_name);
        }
        Vector all_isotopes = MassUtils.getAllIsotopes((Atom)atom);
        int no_isotopes = all_isotopes.size();
        double lpn = (double)no_atoms * Math.log(main_isotope.getAbundance());
        Vector<Pair> massint_pairs = new Vector<Pair>();
        int r = 0;
        while (true) {
            Vector<int[]> combinations = MSUtils.getAllCombinations(no_atoms, no_isotopes, r);
            boolean added = false;
            for (int[] x : combinations) {
                double lp = MSUtils.logMultinomialCoefficient(no_atoms, x);
                for (int i = 0; i < no_isotopes; ++i) {
                    lp += (double)x[i] * Math.log(((Isotope)all_isotopes.get(i)).getAbundance());
                }
                double rel_int = Math.exp(lp - lpn);
                if (!(rel_int > 1.0E-6)) continue;
                double mass = 0.0;
                for (int i = 0; i < no_isotopes; ++i) {
                    mass += (double)x[i] * ((Isotope)all_isotopes.get(i)).getMass();
                }
                massint_pairs.add(new Pair((Object)mass, (Object)rel_int));
                added = true;
            }
            if (no_isotopes == 1 || !added) break;
            ++r;
        }
        double[][] ret = new double[][]{new double[massint_pairs.size()], new double[massint_pairs.size()]};
        for (int i = 0; i < massint_pairs.size(); ++i) {
            ret[0][i] = (Double)((Pair)massint_pairs.get(i)).getFirst();
            ret[1][i] = (Double)((Pair)massint_pairs.get(i)).getSecond();
        }
        return ret;
    }

    private static double logMultinomialCoefficient(int n, int[] x) {
        double ret = Math.log(MSUtils.binomialCoefficient(n, x[0]));
        for (int i = 1; i < x.length; ++i) {
            ret -= Math.log(MSUtils.factorial(x[i]));
        }
        return ret;
    }

    private static double factorial(int n) {
        return MSUtils.binomialCoefficient(n, 1);
    }

    private static double binomialCoefficient(int n, int k) {
        double ret = 1.0;
        for (int i = n; i > k; --i) {
            ret *= (double)i;
        }
        return ret;
    }

    private static Vector<int[]> getAllCombinations(int n, int k, int r) {
        Vector<int[]> ret = new Vector<int[]>();
        int[] root = new int[k];
        root[0] = n;
        Arrays.fill(root, 1, k, 0);
        MSUtils.getAllCombinationsRecursive(ret, root, r);
        return ret;
    }

    private static void getAllCombinationsRecursive(Vector<int[]> buffer, int[] current, int r) {
        if (r == 0) {
            buffer.add(current);
            return;
        }
        int i = 1;
        while (i < current.length) {
            int[] new_current = MSUtils.clone(current);
            new_current[0] = new_current[0] - 1;
            int n = i++;
            new_current[n] = new_current[n] + 1;
            MSUtils.getAllCombinationsRecursive(buffer, new_current, r - 1);
        }
    }

    private static int[] clone(int[] array) {
        int[] ret = new int[array.length];
        for (int c = 0; c < array.length; ++c) {
            ret[c] = array[c];
        }
        return ret;
    }

    public static final class IsotopeList {
        private double mass_tol;
        private TreeMap<Double, Double> mz_int_map;

        public IsotopeList(boolean show_all) {
            this.mass_tol = show_all ? 1.0E-4 : 0.2;
            this.mz_int_map = new TreeMap();
        }

        private Map.Entry<Double, Double> getEntry(double mz) {
            for (Map.Entry<Double, Double> e : this.mz_int_map.entrySet()) {
                double emz = e.getKey();
                if (emz > mz + this.mass_tol) {
                    return null;
                }
                if (!(emz > mz - this.mass_tol)) continue;
                return e;
            }
            return null;
        }

        public double get(double mz) {
            Map.Entry<Double, Double> e = this.getEntry(mz);
            return e == null ? 0.0 : e.getValue();
        }

        public void add(double mz, double intensity, boolean sum) {
            Map.Entry<Double, Double> e = this.getEntry(mz);
            if (e == null) {
                this.mz_int_map.put(mz, intensity);
            } else if (sum) {
                this.mz_int_map.put(e.getKey(), e.getValue() + intensity);
            } else {
                this.mz_int_map.put(e.getKey(), intensity);
            }
        }

        public void add(double[][] data, boolean sum) {
            for (int i = 0; i < data[0].length; ++i) {
                this.add(data[0][i], data[1][i], sum);
            }
        }

        public void adjust(double[][] data, double mz_ratio, double intensity) {
            double mass_shift = 0.0;
            for (int i = 0; i < data[0].length; ++i) {
                if (data[1][i] != 1.0) continue;
                mass_shift = mz_ratio - data[0][i];
                break;
            }
            double int_shift = this.get(mz_ratio);
            for (int i = 0; i < data[0].length; ++i) {
                double new_mz = data[0][i] + mass_shift;
                double new_int = data[1][i] * (intensity - int_shift) + this.get(new_mz);
                data[0][i] = new_mz;
                data[1][i] = new_int;
            }
        }
    }
}

