/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class WebBrowser
extends JPanel {
    public final JWebBrowser webBrowser;
    public final JPanel webBrowserPanel = new JPanel(new BorderLayout());

    public WebBrowser() {
        super(new BorderLayout());
        this.webBrowserPanel.setBorder(BorderFactory.createTitledBorder("Native Web Browser component"));
        this.webBrowser = new JWebBrowser(new NSOption[0]);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebBrowser.this.webBrowser.navigate("http://www.google.com");
                WebBrowser.this.webBrowser.setMenuBarVisible(false);
                WebBrowser.this.webBrowserPanel.add((Component)WebBrowser.this.webBrowser, "Center");
                WebBrowser.this.add((Component)WebBrowser.this.webBrowserPanel, "Center");
            }
        });
    }

    public void openResource(final URL remoteResource, final String localResource, boolean localInJar) throws URISyntaxException, IOException {
        if (this.checkSiteExists(remoteResource)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebBrowser.this.webBrowser.navigate(remoteResource.toString());
                }
            });
        } else if (localInJar) {
            this.openResource(new File(localResource));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebBrowser.this.webBrowser.navigate(localResource.toString());
                }
            });
        }
    }

    public void navigate(final URL remoteResource) throws URISyntaxException, IOException {
        if (this.checkSiteExists(remoteResource)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebBrowser.this.webBrowser.navigate(remoteResource.toString());
                }
            });
        }
    }

    public boolean checkSiteExists(URL url) {
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("HEAD");
            return con.getResponseCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void openResource(URL url) throws URISyntaxException, IOException {
        this.openResource(url.toURI());
    }

    public void openResource(URI uri) throws IOException {
        this.openResource(new File(uri));
    }

    public void openResource(InputStream inputStream) throws IOException {
        this.openResource(new InputStreamReader(inputStream));
    }

    public void openResource(File file) throws FileNotFoundException, IOException {
        this.openResource(new FileReader(file));
    }

    public void openResource(Reader reader) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer buf = new StringBuffer();
        while ((line = bufferedReader.readLine()) != null) {
            buf.append(line);
        }
        bufferedReader.close();
        reader.close();
        this.setHTMLContent(buf.toString());
    }

    public void setHTMLContent(final String content) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebBrowser.this.webBrowser.setHTMLContent(content);
            }
        });
    }
}

