/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.Map;
import java.util.TreeMap;
import org.eurocarbdb.MolecularFramework.io.CarbohydrateSequenceEncoding;
import org.eurocarbdb.MolecularFramework.io.SugarExporterFactory;
import org.eurocarbdb.MolecularFramework.io.SugarImporterFactory;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycoCTParser;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MolecularFrameworkParser
extends GlycoCTParser {
    private CarbohydrateSequenceEncoding encoding = null;

    public static Map<String, String> getImportFormats() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (CarbohydrateSequenceEncoding cse : SugarImporterFactory.getSupportedEncodings()) {
            map.put(cse.getId(), cse.getName());
        }
        return map;
    }

    public static Map<String, String> getExportFormats() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (CarbohydrateSequenceEncoding cse : SugarExporterFactory.getSupportedEncodings()) {
            map.put(cse.getId(), cse.getName());
        }
        return map;
    }

    public static Map<String, String> getFormats() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (CarbohydrateSequenceEncoding cse : SugarImporterFactory.getSupportedEncodings()) {
            map.put(cse.getId(), cse.getName());
        }
        for (CarbohydrateSequenceEncoding cse : SugarExporterFactory.getSupportedEncodings()) {
            map.put(cse.getId(), cse.getName());
        }
        return map;
    }

    public static boolean isSequenceFormat(String format) {
        try {
            return CarbohydrateSequenceEncoding.forId((String)format) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public MolecularFrameworkParser(String format) {
        super(false);
        try {
            this.encoding = CarbohydrateSequenceEncoding.forId((String)format);
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }

    @Override
    public String writeGlycan(Glycan structure) {
        try {
            Sugar s = this.toSugar(structure);
            return SugarExporterFactory.exportSugar((Sugar)s, (CarbohydrateSequenceEncoding)this.encoding);
        }
        catch (Exception e) {
            LogUtils.report(e);
            return "";
        }
    }

    @Override
    public Glycan readGlycan(String buffer, MassOptions default_mass_options) throws Exception {
        buffer = TextUtils.trim(buffer);
        Sugar s = SugarImporterFactory.importSugar((String)buffer, (CarbohydrateSequenceEncoding)this.encoding);
        return this.fromSugar(s, default_mass_options);
    }
}

