/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.INITCOMMONCONTROLSEX;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MCHITTESTINFO;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.SYSTEMTIME;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;
    boolean doubleClick;
    boolean ignoreSelection;
    SYSTEMTIME lastSystemTime;
    SYSTEMTIME time = new SYSTEMTIME();
    static final long DateTimeProc;
    static final TCHAR DateTimeClass;
    static final long CalendarProc;
    static final TCHAR CalendarClass;
    static final char SINGLE_QUOTE = '\'';
    static final char DAY_FORMAT_CONSTANT = 'd';
    static final char MONTH_FORMAT_CONSTANT = 'M';
    static final char YEAR_FORMAT_CONSTANT = 'y';
    static final char HOURS_FORMAT_CONSTANT = 'h';
    static final char MINUTES_FORMAT_CONSTANT = 'm';
    static final char SECONDS_FORMAT_CONSTANT = 's';
    static final char AMPM_FORMAT_CONSTANT = 't';

    static {
        DateTimeClass = new TCHAR(0, "SysDateTimePick32", true);
        CalendarClass = new TCHAR(0, "SysMonthCal32", true);
        INITCOMMONCONTROLSEX icex = new INITCOMMONCONTROLSEX();
        icex.dwSize = INITCOMMONCONTROLSEX.sizeof;
        icex.dwICC = 256;
        OS.InitCommonControlsEx(icex);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0L, DateTimeClass, lpWndClass);
        DateTimeProc = lpWndClass.lpfnWndProc;
        lpWndClass.hInstance = OS.GetModuleHandle(null);
        lpWndClass.style &= 0xFFFFBFFF;
        lpWndClass.style |= 8;
        OS.RegisterClass(DateTimeClass, lpWndClass);
        lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0L, CalendarClass, lpWndClass);
        CalendarProc = lpWndClass.lpfnWndProc;
        lpWndClass.hInstance = OS.GetModuleHandle(null);
        lpWndClass.style &= 0xFFFFBFFF;
        lpWndClass.style |= 8;
        OS.RegisterClass(CalendarClass, lpWndClass);
    }

    public DateTime(Composite parent, int style) {
        super(parent, DateTime.checkStyle(style));
        if ((this.style & 0x8000) != 0) {
            String buffer = (this.style & 0x20) != 0 ? this.getCustomShortDateFormat() : this.getCustomShortTimeFormat();
            TCHAR lpszFormat = new TCHAR(0, buffer, true);
            OS.SendMessage(this.handle, 4146, 0L, lpszFormat);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        if (this.handle == 0L) {
            return 0L;
        }
        return OS.CallWindowProc(this.windowProc(), hwnd, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        style &= 0xFFFFFCFF;
        style = DateTime.checkBits(style, 32, 128, 1024, 0, 0, 0);
        if (((style = DateTime.checkBits(style, 65536, 32768, 0x10000000, 0, 0, 0)) & 0x20) == 0) {
            style &= 0xFFFFFFFB;
        }
        return style;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint == -1 || hHint == -1) {
            if ((this.style & 0x400) != 0) {
                RECT rect = new RECT();
                OS.SendMessage(this.handle, 4105, 0L, rect);
                width = rect.right;
                height = rect.bottom;
            } else {
                if ((this.style & 0x4000) != 0) {
                    int bits = OS.GetWindowLong(this.handle, -16);
                    OS.SendMessage(this.handle, 4107, 0L, bits | 4);
                }
                SIZE size = new SIZE();
                OS.SendMessage(this.handle, 4111, 0L, size);
                width = size.cx;
                height = size.cy;
                int upDownHeight = OS.GetSystemMetrics(20) + 7;
                height = Math.max(height, upDownHeight);
            }
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidthInPixels();
        return new Point(width += border * 2, height += border * 2);
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        if ((this.style & 0x800) == 0) {
            int bits = OS.GetWindowLong(this.handle, -20);
            OS.SetWindowLong(this.handle, -20, bits &= 0xFFFDFDFF);
        }
    }

    @Override
    int defaultBackground() {
        return OS.GetSysColor(5);
    }

    String getCustomShortDateFormat() {
        TCHAR tchar = new TCHAR(this.getCodePage(), 80);
        int size = OS.GetLocaleInfo(1024, 4102, tchar, 80);
        return size != 0 ? tchar.toString(0, size - 1) : "M/yyyy";
    }

    String getCustomShortTimeFormat() {
        StringBuffer buffer = new StringBuffer(this.getTimeFormat());
        int length = buffer.length();
        boolean inQuotes = false;
        int start = 0;
        int end = 0;
        while (start < length) {
            char ch = buffer.charAt(start);
            if (ch == '\'') {
                inQuotes = !inQuotes;
            } else if (ch == 's' && !inQuotes) {
                end = start + 1;
                while (end < length && buffer.charAt(end) == 's') {
                    ++end;
                }
                while (start > 0 && buffer.charAt(start) != 'm') {
                    --start;
                }
                ++start;
                break;
            }
            ++start;
        }
        if (start < end) {
            buffer.delete(start, end);
        }
        return buffer.toString();
    }

    String getTimeFormat() {
        TCHAR tchar = new TCHAR(this.getCodePage(), 80);
        int size = OS.GetLocaleInfo(1024, 4099, tchar, 80);
        return size > 0 ? tchar.toString(0, size - 1) : "h:mm:ss tt";
    }

    public int getDay() {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        return systime.wDay;
    }

    public int getHours() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.time.wHour;
        }
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        return systime.wHour;
    }

    public int getMinutes() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.time.wMinute;
        }
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        return systime.wMinute;
    }

    public int getMonth() {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        return systime.wMonth - 1;
    }

    @Override
    String getNameText() {
        return (this.style & 0x80) != 0 ? String.valueOf(this.getHours()) + ":" + this.getMinutes() + ":" + this.getSeconds() : String.valueOf(this.getMonth() + 1) + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.time.wSecond;
        }
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        return systime.wSecond;
    }

    public int getYear() {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        return systime.wYear;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.lastSystemTime = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setDate(int year, int month, int day) {
        this.checkWidget();
        if (year < 1752 || year > 9999) {
            return;
        }
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wYear = (short)year;
        systime.wMonth = (short)(month + 1);
        systime.wDay = (short)day;
        OS.SendMessage(this.handle, msg, 0L, systime);
        this.lastSystemTime = null;
    }

    public void setDay(int day) {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wDay = (short)day;
        OS.SendMessage(this.handle, msg, 0L, systime);
        this.lastSystemTime = null;
    }

    public void setHours(int hours) {
        this.checkWidget();
        if (hours < 0 || hours > 23) {
            return;
        }
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wHour = (short)hours;
        OS.SendMessage(this.handle, msg, 0L, systime);
        if ((this.style & 0x400) != 0 && hours >= 0 && hours <= 23) {
            this.time.wHour = (short)hours;
        }
    }

    public void setMinutes(int minutes) {
        this.checkWidget();
        if (minutes < 0 || minutes > 59) {
            return;
        }
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wMinute = (short)minutes;
        OS.SendMessage(this.handle, msg, 0L, systime);
        if ((this.style & 0x400) != 0 && minutes >= 0 && minutes <= 59) {
            this.time.wMinute = (short)minutes;
        }
    }

    public void setMonth(int month) {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wMonth = (short)(month + 1);
        OS.SendMessage(this.handle, msg, 0L, systime);
        this.lastSystemTime = null;
    }

    @Override
    public void setOrientation(int orientation) {
        if ((this.style & 0x400) != 0) {
            super.setOrientation(orientation);
        }
    }

    public void setSeconds(int seconds) {
        this.checkWidget();
        if (seconds < 0 || seconds > 59) {
            return;
        }
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wSecond = (short)seconds;
        OS.SendMessage(this.handle, msg, 0L, systime);
        if ((this.style & 0x400) != 0 && seconds >= 0 && seconds <= 59) {
            this.time.wSecond = (short)seconds;
        }
    }

    public void setTime(int hours, int minutes, int seconds) {
        this.checkWidget();
        if (hours < 0 || hours > 23 || minutes < 0 || minutes > 59 || seconds < 0 || seconds > 59) {
            return;
        }
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wHour = (short)hours;
        systime.wMinute = (short)minutes;
        systime.wSecond = (short)seconds;
        OS.SendMessage(this.handle, msg, 0L, systime);
        if ((this.style & 0x400) != 0 && hours >= 0 && hours <= 23 && minutes >= 0 && minutes <= 59 && seconds >= 0 && seconds <= 59) {
            this.time.wHour = (short)hours;
            this.time.wMinute = (short)minutes;
            this.time.wSecond = (short)seconds;
        }
    }

    public void setYear(int year) {
        this.checkWidget();
        if (year < 1752 || year > 9999) {
            return;
        }
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wYear = (short)year;
        OS.SendMessage(this.handle, msg, 0L, systime);
        this.lastSystemTime = null;
    }

    @Override
    int widgetStyle() {
        int bits = super.widgetStyle() | 0x10000;
        if ((this.style & 0x4000) != 0) {
            bits |= 4;
        }
        if ((this.style & 0x400) != 0) {
            return bits | 0x10;
        }
        bits &= 0xFDFFFFFF;
        if ((this.style & 0x80) != 0) {
            bits |= 9;
        }
        if ((this.style & 0x20) != 0) {
            bits |= (this.style & 0x10000) != 0 ? 12 : 4;
            if ((this.style & 4) == 0) {
                bits |= 1;
            }
        }
        return bits;
    }

    @Override
    TCHAR windowClass() {
        return (this.style & 0x400) != 0 ? CalendarClass : DateTimeClass;
    }

    @Override
    long windowProc() {
        return (this.style & 0x400) != 0 ? CalendarProc : DateTimeProc;
    }

    @Override
    LRESULT wmNotifyChild(NMHDR hdr, long wParam, long lParam) {
        switch (hdr.code) {
            case -753: {
                this.display.captureChanged = true;
                break;
            }
            case -749: {
                if (this.ignoreSelection) break;
                SYSTEMTIME systime = new SYSTEMTIME();
                OS.SendMessage(this.handle, 4097, 0L, systime);
                this.sendSelectionEvent(13);
                break;
            }
            case -759: {
                SYSTEMTIME systime = new SYSTEMTIME();
                OS.SendMessage(this.handle, 4097, 0L, systime);
                if (this.lastSystemTime != null && systime.wDay == this.lastSystemTime.wDay && systime.wMonth == this.lastSystemTime.wMonth && systime.wYear == this.lastSystemTime.wYear) break;
                this.sendSelectionEvent(13);
                if ((this.style & 0x80) != 0) break;
                this.lastSystemTime = systime;
            }
        }
        return super.wmNotifyChild(hdr, wParam, lParam);
    }

    @Override
    LRESULT WM_CHAR(long wParam, long lParam) {
        LRESULT result = super.WM_CHAR(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch ((int)wParam) {
            case 13: {
                this.sendSelectionEvent(14);
            }
            case 9: 
            case 27: {
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    @Override
    LRESULT WM_LBUTTONDBLCLK(long wParam, long lParam) {
        LRESULT result = super.WM_LBUTTONDBLCLK(wParam, lParam);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if ((this.style & 0x400) != 0) {
            MCHITTESTINFO pMCHitTest = new MCHITTESTINFO();
            pMCHitTest.cbSize = MCHITTESTINFO.sizeof;
            POINT pt = new POINT();
            pt.x = OS.GET_X_LPARAM(lParam);
            pt.y = OS.GET_Y_LPARAM(lParam);
            pMCHitTest.pt = pt;
            long code = OS.SendMessage(this.handle, 4110, 0L, pMCHitTest);
            if ((code & 0x20001L) == 131073L) {
                this.doubleClick = true;
            }
        }
        return result;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(long wParam, long lParam) {
        LRESULT result = super.WM_LBUTTONDOWN(wParam, lParam);
        if (result == LRESULT.ZERO) {
            return result;
        }
        this.doubleClick = false;
        if ((this.style & 0x400) != 0 && (this.style & 0x80000) == 0) {
            OS.SetFocus(this.handle);
        }
        return result;
    }

    @Override
    LRESULT WM_LBUTTONUP(long wParam, long lParam) {
        LRESULT result = super.WM_LBUTTONUP(wParam, lParam);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (this.doubleClick) {
            this.sendSelectionEvent(14);
        }
        this.doubleClick = false;
        return result;
    }

    @Override
    LRESULT WM_TIMER(long wParam, long lParam) {
        LRESULT result = super.WM_TIMER(wParam, lParam);
        if (result != null) {
            return result;
        }
        this.ignoreSelection = true;
        long code = this.callWindowProc(this.handle, 275, wParam, lParam);
        this.ignoreSelection = false;
        return code == 0L ? LRESULT.ZERO : new LRESULT(code);
    }
}

