/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.utilShare.validator;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.graphics.Image;

public class StringValidator
implements ICellEditorValidator {
    private ControlDecoration controlDecoration;
    private int validatorType = 0;

    public StringValidator(ControlDecoration controlDecoration) {
        this.controlDecoration = controlDecoration;
        Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.controlDecoration.setMarginWidth(2);
        this.controlDecoration.setImage(errorImage);
    }

    public StringValidator(ControlDecoration controlDecoration, int validatorType) {
        this(controlDecoration);
        this.validatorType = validatorType != 1 ? 0 : validatorType;
    }

    public String isValid(Object value) {
        String inValidMessage = null;
        this.controlDecoration.hide();
        if (value instanceof String) {
            String stringValue = (String)value;
            stringValue = stringValue.trim();
            switch (this.validatorType) {
                case 0: {
                    break;
                }
                case 1: {
                    inValidMessage = stringValue.isEmpty() ? " Value cannot be empty " : inValidMessage;
                }
            }
        } else {
            inValidMessage = " Value is not a String ";
        }
        if (inValidMessage != null) {
            this.controlDecoration.show();
            this.controlDecoration.setDescriptionText(inValidMessage);
        }
        return inValidMessage;
    }
}

