/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.annotation.gelato.AnalyteMatcher;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.structure.GelatoAnalyte;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScansAnnotation;

public class FragmentMatcher {
    private static final Logger logger = Logger.getLogger(FragmentMatcher.class);
    protected AnalyteMatcher parentAnalyteMatcher = null;
    protected Map<Double, Integer> mPeakMatched = new HashMap<Double, Integer>();
    protected int curScanNum = -1;

    public FragmentMatcher(int curScanNum, AnalyteMatcher parentAnalyteMatcher) {
        this.parentAnalyteMatcher = parentAnalyteMatcher;
        this.curScanNum = curScanNum;
    }

    public List<Integer> getMatchingSubScans(Data data, int iCurScanNum, Peak parentPeak) {
        ArrayList<Integer> iMatchingScans = new ArrayList<Integer>();
        List<Integer> lScans = GelatoUtils.getSubScanForPrecursor(data, iCurScanNum, parentPeak);
        if (!lScans.isEmpty()) {
            for (Integer iSubScanNum : lScans) {
                iMatchingScans.add(iSubScanNum);
            }
        }
        return iMatchingScans;
    }

    public Map<Double, Integer> getPeakMatched() {
        return this.mPeakMatched;
    }

    public int getCurScanNum() {
        return this.curScanNum;
    }

    public void setCurScanNum(int curScanNum) {
        this.curScanNum = curScanNum;
    }

    public boolean matchFragment(ScansAnnotation fragmentScansAnnotation, int iParentScanNum, Annotation fragAnnotation, Feature parentFeature, GelatoAnalyte fragAnalyte, Data data, List<IonSettings> lFragmentAdductsToAnalyze, List<Integer> lFragmentAdductCounts, List<IonSettings> lFragmentExchangesToAnalyze, List<Integer> lFragmentExchangesCounts, List<MoleculeSettings> lFragmentNeutralLossesToAnalyze, List<Integer> lFragmentNeutralLossCounts, AnalyteSettings settings, String fragmentType, String tempPath) {
        boolean bRes = false;
        try {
            if (this.getCurScanNum() != iParentScanNum) {
                this.getPeakMatched().clear();
                this.setCurScanNum(iParentScanNum);
            }
            double[] analyteInfo = GelatoUtils.getAnalyteMzAndCharge(fragAnalyte.getAnalyte(), settings, lFragmentAdductsToAnalyze, lFragmentAdductCounts, lFragmentExchangesToAnalyze, lFragmentExchangesCounts, lFragmentNeutralLossesToAnalyze, lFragmentNeutralLossCounts);
            double analyteMz = analyteInfo[0];
            int iParentCharge = (int)analyteInfo[1];
            int iNumParentExchanges = (int)analyteInfo[2];
            int iNumParentLosses = (int)analyteInfo[3];
            int iStartInx = 0;
            if (this.getPeakMatched().containsKey(analyteMz)) {
                iStartInx = this.getPeakMatched().get(analyteMz);
            }
            Scan scan = (Scan)data.getScans().get(iParentScanNum);
            for (int iPeakInx = iStartInx; iPeakInx < scan.getPeaklist().size(); ++iPeakInx) {
                try {
                    int[] iPeakMatchInfo = GelatoUtils.getMatchingPeak(scan, iPeakInx, analyteMz, data.getDataHeader().getMethod(), false);
                    if (iPeakMatchInfo == null || iPeakMatchInfo[1] == -1) continue;
                    Peak peak = (Peak)scan.getPeaklist().get(iPeakMatchInfo[1]);
                    boolean bCurRes = this.parentAnalyteMatcher.scorePeakToFeature(data, analyteMz, fragmentType, fragAnalyte, fragAnnotation, fragmentScansAnnotation, parentFeature, lFragmentAdductsToAnalyze, lFragmentAdductCounts, iParentCharge, lFragmentExchangesToAnalyze, lFragmentExchangesCounts, iNumParentExchanges, lFragmentNeutralLossesToAnalyze, lFragmentNeutralLossCounts, iNumParentLosses, settings, peak, iParentScanNum, tempPath);
                    bRes |= bCurRes;
                    this.getPeakMatched().put(analyteMz, iPeakMatchInfo[1]);
                    iPeakInx = scan.getPeaklist().size();
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"Error analyzing peaks in FragmentMatcherGlycanBased:matchFragment.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in FragmentMatcherGlycanBased:matchFragment.", (Throwable)e);
        }
        return bRes;
    }
}

