/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.utils;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Point;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.editor.experimentdesigner.exception.NoExperimentDesignException;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.OutputNode;
import org.grits.toolbox.editor.experimentdesigner.model.Parameter;
import org.grits.toolbox.editor.experimentdesigner.model.ParameterGroup;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.property.ExperimentProperty;
import org.grits.toolbox.editor.experimentdesigner.utils.ExternalNode;

public class ExperimentDesignerUtils {
    @Inject
    @Named(value="workspace_location")
    private static String workspaceLocation;

    public static void addOutputNode(Entry sampleEntry, ExternalNode node) throws Exception {
        ExperimentGraph graph = ExperimentDesignerUtils.loadExperimentDesign(sampleEntry);
        graph.setConnectionsToNodes();
        graph.setProjectEntry(sampleEntry.getParent());
        List children = graph.getChildren();
        Point location = new Point(50, 100);
        int locationY = 100;
        for (Object graphNode : children) {
            if (!(graphNode instanceof GraphNode)) continue;
            if (((GraphNode)graphNode).getLocation() == null) {
                ((GraphNode)graphNode).setLocation(location);
                location = location.translate(100, 0);
                continue;
            }
            locationY = Math.max(locationY, ((GraphNode)graphNode).getLocation().y);
        }
        ExperimentDesignerUtils.addOutputNode(graph, node, locationY);
        ExperimentProperty experimentProperty = ExperimentDesignerUtils.getExperimentProperty(sampleEntry);
        String fileName = experimentProperty.getExperimentFile().getName();
        String experimentFolderLocation = ExperimentDesignerUtils.getExperimentFolderLocation(sampleEntry);
        String fileLocation = String.valueOf(experimentFolderLocation) + File.separator + fileName;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ExperimentGraph.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)graph, (OutputStream)os);
        FileWriter fileWriter = new FileWriter(fileLocation);
        fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
        fileWriter.close();
        os.close();
    }

    static void addOutputNode(ExperimentGraph graph, ExternalNode node, int locationY) {
        int locationX = 50;
        List existingNodes = graph.getChildren();
        boolean entryFound = false;
        for (Object object : existingNodes) {
            if (!(object instanceof OutputNode)) continue;
            OutputNode outputNode = (OutputNode)object;
            locationX = outputNode.getLocation().x;
            if (!outputNode.getLabel().equalsIgnoreCase(node.getLabel())) continue;
            outputNode.setDescription(node.getDescription());
            outputNode.setParameterGroups(node.getParameterGroups());
            outputNode.setParameters(node.getParameters());
            entryFound = true;
            break;
        }
        Point originalLocation = new Point(locationX, locationY + 100);
        if (!entryFound) {
            OutputNode newNode = new OutputNode();
            newNode.setLabel(node.getLabel());
            newNode.setParameterGroups(node.getParameterGroups());
            newNode.setParameters(node.getParameters());
            newNode.setLocation(originalLocation.translate(100, 0));
            newNode.setColor(ColorConstants.lightGreen);
            graph.addChild(newNode);
        }
    }

    static ExperimentProperty getExperimentProperty(Entry sampleEntry) throws NoExperimentDesignException {
        List childEntries = sampleEntry.getChildren();
        ExperimentProperty experimentProperty = null;
        for (Entry entry : childEntries) {
            Property prop = entry.getProperty();
            if (prop.getType() != "org.grits.toolbox.property.experiment") continue;
            experimentProperty = (ExperimentProperty)prop;
        }
        if (experimentProperty == null) {
            throw new NoExperimentDesignException("Experiment Design for " + sampleEntry.getDisplayName() + " does not exists!");
        }
        return experimentProperty;
    }

    static String getExperimentFolderLocation(Entry sampleEntry) {
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + sampleEntry.getParent().getDisplayName();
        String exampleFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "experiments";
        return exampleFolderLocation;
    }

    public static ExperimentGraph loadExperimentDesign(Entry sampleEntry) throws Exception {
        String experimentFolderLocation = ExperimentDesignerUtils.getExperimentFolderLocation(sampleEntry);
        ExperimentProperty experimentProperty = ExperimentDesignerUtils.getExperimentProperty(sampleEntry);
        String fileName = experimentProperty.getExperimentFile().getName();
        String fileLocation = String.valueOf(experimentFolderLocation) + File.separator + fileName;
        File experimentFile = new File(fileLocation);
        if (!experimentFile.exists()) {
            throw new NoExperimentDesignException("Experiment Design for " + sampleEntry.getDisplayName() + " does not exists!");
        }
        FileInputStream inputStream = new FileInputStream(experimentFile.getAbsolutePath());
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ExperimentGraph.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        ExperimentGraph graph = (ExperimentGraph)unmarshaller.unmarshal((Reader)reader);
        reader.close();
        inputStream.close();
        return graph;
    }

    public static BufferedImage loadExperimentDesignImage(Entry sampleEntry) throws Exception {
        String experimentFolderLocation = ExperimentDesignerUtils.getExperimentFolderLocation(sampleEntry);
        ExperimentProperty experimentProperty = ExperimentDesignerUtils.getExperimentProperty(sampleEntry);
        String fileName = experimentProperty.getExperimentFile().getName();
        String imageFileName = String.valueOf(fileName.substring(0, fileName.lastIndexOf("."))) + ".png";
        String imageFileLocation = String.valueOf(experimentFolderLocation) + File.separator + imageFileName;
        File imageFile = new File(imageFileLocation);
        if (imageFile.exists()) {
            return ImageIO.read(imageFile);
        }
        return null;
    }

    public static List<Parameter> getParameterFromExperiment(Entry sampleEntry, String protocolName, String parameterName) throws Exception {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        ExperimentGraph graph = ExperimentDesignerUtils.loadExperimentDesign(sampleEntry);
        for (Object graphNode : graph.getChildren()) {
            ProtocolNode protocol;
            if (!(graphNode instanceof ProtocolNode) || !(protocol = (ProtocolNode)graphNode).getLabel().equalsIgnoreCase(protocolName)) continue;
            if (protocol.getParameters() != null) {
                for (Parameter parameter : protocol.getParameters()) {
                    if (!parameter.getName().equalsIgnoreCase(parameterName)) continue;
                    parameters.add(parameter);
                }
            }
            if (protocol.getParameterGroups() == null) continue;
            for (ParameterGroup group : protocol.getParameterGroups()) {
                for (Parameter parameter : group.getParameters()) {
                    if (!parameter.getName().equalsIgnoreCase(parameterName)) continue;
                    parameters.add(parameter);
                }
            }
        }
        return parameters;
    }

    public static List<ParameterGroup> getParameterGroupFromExperiment(Entry sampleEntry, String protocolName, String parameterGroupName) throws Exception {
        ArrayList<ParameterGroup> parameterGroups = new ArrayList<ParameterGroup>();
        ExperimentGraph graph = ExperimentDesignerUtils.loadExperimentDesign(sampleEntry);
        for (Object graphNode : graph.getChildren()) {
            ProtocolNode protocol;
            if (!(graphNode instanceof ProtocolNode) || !(protocol = (ProtocolNode)graphNode).getLabel().equalsIgnoreCase(protocolName)) continue;
            for (ParameterGroup group : protocol.getParameterGroups()) {
                if (!group.getLabel().equalsIgnoreCase(parameterGroupName)) continue;
                parameterGroups.add(group);
            }
        }
        return parameterGroups;
    }
}

