/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.commands;

import org.eclipse.gef.commands.Command;
import org.grits.toolbox.editor.experimentdesigner.model.Connection;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.InputNode;
import org.grits.toolbox.editor.experimentdesigner.model.OutputNode;

public class ConnectionCreateCommand
extends Command {
    private Connection connection;
    private final int lineStyle;
    private final GraphNode source;
    private GraphNode target;

    public ConnectionCreateCommand(GraphNode source, int lineStyle) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("connection creation");
        this.source = source;
        this.lineStyle = lineStyle;
    }

    public boolean canExecute() {
        if (this.source.equals(this.target)) {
            return false;
        }
        if (this.target instanceof InputNode) {
            return false;
        }
        if (this.source instanceof OutputNode) {
            return false;
        }
        for (Connection conn : this.source.getSourceConnections()) {
            if (!conn.getTarget().equals(this.target)) continue;
            return false;
        }
        return !this.isConnected(this.target, this.source);
    }

    boolean isConnected(GraphNode t, GraphNode s) {
        boolean connected = false;
        if (t == s) {
            System.out.println("target and source are the same!");
        }
        if (t != null && t.getSourceConnections() != null) {
            for (Connection conn : t.getSourceConnections()) {
                if (conn.getTarget().equals(s)) {
                    return true;
                }
                if (conn.getTarget() != null && (connected = this.isConnected(conn.getTarget(), s))) break;
            }
        }
        return connected;
    }

    public void execute() {
        this.connection = new Connection(this.source, this.target);
        this.connection.setLineStyle(this.lineStyle);
    }

    public void redo() {
        this.connection.reconnect();
    }

    public void setTarget(GraphNode target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.target = target;
    }

    public void undo() {
        this.connection.disconnect();
    }
}

