/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResiduePlacement;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class ResiduePlacementDictionary {
    private Vector<ResiduePlacement> placements = new Vector();

    public void loadPlacements(String filename) {
        this.placements.clear();
        try {
            String line;
            BufferedReader is;
            if (filename.startsWith("http")) {
                URLConnection conn = new URL(filename).openConnection();
                is = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            } else {
                URL file_url = ResidueDictionary.class.getResource(filename);
                if (file_url == null) {
                    File file = new File(filename);
                    if (!file.exists()) {
                        throw new FileNotFoundException(filename);
                    }
                    is = new BufferedReader(new FileReader(file));
                } else {
                    is = new BufferedReader(new InputStreamReader(file_url.openStream()));
                }
            }
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim(line)).length() <= 0 || line.startsWith("%")) continue;
                this.placements.add(new ResiduePlacement(line));
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report(e);
            this.placements.clear();
        }
    }

    public ResiduePlacement getPlacement(Linkage link) {
        return this.getPlacement(link.getParentResidue(), link, link.getChildResidue());
    }

    public ResiduePlacement getPlacement(Linkage link, boolean sticky) {
        return this.getPlacement(link.getParentResidue(), link, link.getChildResidue(), sticky);
    }

    public ResiduePlacement getPlacement(Residue parent, Linkage link, Residue child) {
        for (ResiduePlacement p : this.placements) {
            if (!p.matches(parent, link, child)) continue;
            return p;
        }
        return new ResiduePlacement();
    }

    public ResiduePlacement getPlacement(Residue parent, Linkage link, Residue child, boolean sticky) {
        for (ResiduePlacement p : this.placements) {
            if (!p.matches(parent, link, child)) continue;
            return sticky ? p.getIfSticky() : p;
        }
        return new ResiduePlacement();
    }
}

