/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.forms;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class DatabaseIDComposite {
    private FormToolkit m_toolkit;
    private Text m_txtIdPrefix;
    private Text m_txtIdPostfix;
    private Button m_btnOverwriteIds;

    public DatabaseIDComposite(Composite parent, FormToolkit toolkit) {
        this.m_toolkit = toolkit;
        this.createControls(parent);
    }

    public DatabaseIDComposite(Composite parent) {
        this.m_toolkit = new FormToolkit(parent.getDisplay());
        this.m_toolkit.setBackground(parent.getBackground());
        this.createControls(parent);
    }

    private void createControls(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        parent.setLayout((Layout)layout);
        Label lbl = this.m_toolkit.createLabel(parent, "Prefix");
        lbl.setText("Prefix");
        lbl.setLayoutData((Object)new TableWrapData(2, 32));
        this.m_txtIdPrefix = this.m_toolkit.createText(parent, "", 2048);
        this.m_txtIdPrefix.setLayoutData((Object)new TableWrapData(256, 32, 1, 2));
        this.m_txtIdPrefix.setBackground(Display.getCurrent().getSystemColor(1));
        lbl = this.m_toolkit.createLabel(parent, "Postfix");
        lbl.setLayoutData((Object)new TableWrapData(2, 32));
        this.m_txtIdPostfix = this.m_toolkit.createText(parent, "", 2048);
        this.m_txtIdPostfix.setLayoutData((Object)new TableWrapData(256, 32, 1, 2));
        this.m_txtIdPostfix.setBackground(Display.getCurrent().getSystemColor(1));
        lbl = this.m_toolkit.createLabel(parent, "");
        lbl.setLayoutData((Object)new TableWrapData(2, 32));
        lbl = this.m_toolkit.createLabel(parent, "Glycan IDs will be generated following the format <prefix>Number<postfix>.\nIf prefix and postfix are empty the ID will consist of a number alone.", 64);
        TableWrapData data = new TableWrapData(256, 32, 1, 2);
        data.maxWidth = 120;
        lbl.setLayoutData((Object)data);
        this.m_btnOverwriteIds = this.m_toolkit.createButton(parent, "Overwrite:", 32);
        this.m_btnOverwriteIds.setLayoutData((Object)new TableWrapData(2, 16, 1, 2));
        lbl = this.m_toolkit.createLabel(parent, "For glycans with existing IDs generate new IDs as well.", 64);
        data = new TableWrapData(256, 32);
        data.maxWidth = 150;
        lbl.setLayoutData((Object)data);
    }

    public String getIDPrefix() {
        return this.m_txtIdPrefix.getText();
    }

    public String getIDPostfix() {
        return this.m_txtIdPostfix.getText();
    }

    public boolean isOverwriteIDs() {
        return this.m_btnOverwriteIds.getSelection();
    }
}

