/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.dango;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.file.reader.IMSAnnotationFileReader;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.DataHeader;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycanFeature;
import org.grits.toolbox.ms.om.data.GlycolipidAnnotation;
import org.grits.toolbox.ms.om.data.GlycolipidFeature;
import org.grits.toolbox.ms.om.data.LipidFeature;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScanFeatures;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;
import org.grits.toolbox.tools.gsl.dango.GlycolipidAnnotationObjectProvider;
import org.grits.toolbox.tools.gsl.dango.GlycolipidMSAnnotator;
import org.grits.toolbox.tools.gsl.dango.IonCombinationGenerator;
import org.grits.toolbox.tools.gsl.dango.ScanReader;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.INotifyingProcess;
import org.grits.toolbox.widgets.tools.NotifyingProcessUtil;

public class DANGOAnnotation
implements INotifyingProcess {
    private static final Logger logger = Logger.getLogger(DANGOAnnotation.class);
    private String m_strZipFilepath;
    private Data m_data;
    private static final CustomExtraData countingScoreData = new CustomExtraData("counting_score", "Counting Score", "Generic Method", CustomExtraData.Type.Double, "0.00");
    private static final CustomExtraData intensityScoreData = new CustomExtraData("intensity_score", "Intensity Score", "Second Method", CustomExtraData.Type.Double, "0.00");
    private static final CustomExtraData rawCountingScoreData = new CustomExtraData("raw_counting_score", "Raw Counting Score", "Generic Method", CustomExtraData.Type.Double, "0.0000");
    private static final CustomExtraData rawIntensityScoreData = new CustomExtraData("raw_intensity_score", "Raw Intensity Score", "Second Method", CustomExtraData.Type.Double, "0.0000");
    private MSFile m_msFile;
    private boolean m_bFilterByKeyFragment;
    private boolean m_bIntactGlycanAnnotation;
    private int m_nTotalSize;
    private List<IProgressListener> m_lMyProgressListeners;
    private boolean m_bCancel;

    public DANGOAnnotation(Data a_data, MSFile a_msFile, String a_strZipFilepath) {
        this.m_data = a_data;
        this.m_msFile = a_msFile;
        this.m_strZipFilepath = a_strZipFilepath;
        this.m_bFilterByKeyFragment = false;
        this.m_bIntactGlycanAnnotation = true;
        this.m_nTotalSize = -1;
        this.addFeatureCustomExtraData(this.m_data.getDataHeader());
    }

    public void setFilterByKeyFragment(boolean a_bFilter) {
        this.m_bFilterByKeyFragment = a_bFilter;
    }

    public void setIntactGlycanAnnotation(boolean a_bGlycanAnnot) {
        this.m_bIntactGlycanAnnotation = a_bGlycanAnnot;
    }

    public Data getData() {
        return this.m_data;
    }

    public void initialize() {
        this.setProgressType(IProgressListener.ProgressType.Indeterminant);
        this.m_data.setAnnotation(this.populateAnnotations(this.m_data.getDataHeader().getMethod()));
        this.m_data.setScans(this.getScans(this.m_msFile));
        this.m_nTotalSize = this.m_data.getScans().size();
        for (Integer t_iScanNum : this.m_data.getScans().keySet()) {
            ScanFeatures t_scanF = this.createScanFeatures((Scan)this.m_data.getScans().get(t_iScanNum), new ArrayList<Feature>());
            this.m_data.getScanFeatures().put(t_iScanNum, t_scanF);
        }
        this.setProgressType(IProgressListener.ProgressType.Determinant);
    }

    protected HashMap<Integer, Scan> getScans(MSFile a_msFile) {
        if (!(a_msFile.getReader() instanceof IMSAnnotationFileReader)) {
            return null;
        }
        HashMap<Integer, Scan> t_mapIDToScan = new HashMap<Integer, Scan>();
        IMSAnnotationFileReader t_msFileReader = (IMSAnnotationFileReader)a_msFile.getReader();
        List t_lScans = t_msFileReader.readMSFile(a_msFile);
        for (Scan t_scan : t_lScans) {
            t_mapIDToScan.put(t_scan.getScanNo(), t_scan);
        }
        return t_mapIDToScan;
    }

    protected void addFeatureCustomExtraData(DataHeader a_dHeader) {
        a_dHeader.getFeatureCustomExtraData().add(countingScoreData);
        a_dHeader.getFeatureCustomExtraData().add(intensityScoreData);
        a_dHeader.getFeatureCustomExtraData().add(rawCountingScoreData);
        a_dHeader.getFeatureCustomExtraData().add(rawIntensityScoreData);
    }

    public List<Annotation> populateAnnotations(Method a_method) {
        this.setMaxValue(1);
        this.updateListeners("Populate annotations", 0);
        ArrayList<Annotation> t_lAnnots = new ArrayList<Annotation>();
        GlycolipidAnnotationObjectProvider t_glAnnotProv = new GlycolipidAnnotationObjectProvider();
        t_glAnnotProv.createAnnotations(a_method);
        for (GlycolipidAnnotation t_glAnnot : t_glAnnotProv.getGlycolipidAnnotations()) {
            t_lAnnots.add((Annotation)t_glAnnot);
        }
        if (this.m_bIntactGlycanAnnotation) {
            for (GlycanAnnotation t_gAnnot : t_glAnnotProv.getGlycanAnnotations()) {
                t_lAnnots.add((Annotation)t_gAnnot);
            }
        }
        this.updateListeners("Done!", 1);
        return t_lAnnots;
    }

    public int processAnnotation() {
        GlycolipidMSAnnotator t_glAnnotator = new GlycolipidMSAnnotator(this.m_data.getDataHeader().getMethod().getTrustMzCharge(), this.m_data.getDataHeader().getMethod().getMonoisotopic(), ((AnalyteSettings)this.m_data.getDataHeader().getMethod().getAnalyteSettings().get(0)).getGlycanSettings());
        for (Annotation t_annot : this.m_data.getAnnotation()) {
            t_glAnnotator.addCandidateAnnotation(t_annot);
        }
        IonCombinationGenerator t_ionComboGen = new IonCombinationGenerator(this.m_data.getDataHeader().getMethod());
        t_ionComboGen.generate();
        t_glAnnotator.setIonCombinationsForPrecursor(t_ionComboGen.getPossibleIonCombinations());
        t_glAnnotator.setIonCombinationsForFragments(t_ionComboGen.getPossibleIonCombinations());
        t_glAnnotator.setIonCombinationsForGlycanFragments(t_ionComboGen.getPossibleIonCombinations());
        t_glAnnotator.setIonCombinationsForLipidFragments(t_ionComboGen.getPossibleIonCombinations());
        t_glAnnotator.setFilterByKeyFeature(this.m_bFilterByKeyFragment);
        if (this.isCanceled()) {
            return GRITSProcessStatus.CANCEL;
        }
        this.setMaxValue(this.m_nTotalSize);
        this.updateListeners("Processing", 0);
        int t_iRes = 0;
        t_iRes = this.annotateDirectInfusion(t_glAnnotator);
        this.updateListeners("Done!", this.m_nTotalSize);
        return t_iRes;
    }

    private int annotateDirectInfusion(GlycolipidMSAnnotator a_glAnnotator) {
        Scan t_scan;
        int t_iAnnotatedMS2 = 0;
        ArrayList<Integer> t_lMS1Scans = new ArrayList<Integer>();
        ArrayList t_lMS1Features = new ArrayList();
        ArrayList t_lScanNums = new ArrayList();
        t_lScanNums.addAll(this.m_data.getScans().keySet());
        Collections.sort(t_lScanNums);
        for (Integer t_iScanNum : t_lScanNums) {
            if (this.isCanceled()) {
                return GRITSProcessStatus.CANCEL;
            }
            t_scan = (Scan)this.m_data.getScans().get(t_iScanNum);
            if (t_scan.getMsLevel() != 1) continue;
            logger.debug((Object)("Processing scan #: " + t_iScanNum));
            this.updateListeners("Processing scan # " + t_iScanNum, t_iScanNum);
            t_lMS1Scans.add(t_iScanNum);
            boolean bRes = this.annotateSubScans(t_scan, a_glAnnotator);
            if (!bRes) {
                if (this.isCanceled()) {
                    return GRITSProcessStatus.CANCEL;
                }
                return GRITSProcessStatus.ERROR;
            }
            t_iAnnotatedMS2 += t_scan.getNumAnnotatedPeaks().intValue();
        }
        if (t_lMS1Scans.size() > 1) {
            for (Integer t_iMS1ScanNum : t_lMS1Scans) {
                t_scan = (Scan)this.m_data.getScans().get(t_iMS1ScanNum);
                t_scan.setNumAnnotatedPeaks(Integer.valueOf(t_iAnnotatedMS2));
                t_lMS1Features.addAll(((ScanFeatures)this.m_data.getScanFeatures().get(t_iMS1ScanNum)).getFeatures());
            }
            Integer t_iFirstMS1ScanNum = (Integer)t_lMS1Scans.get(0);
            ((ScanFeatures)this.m_data.getScanFeatures().get(t_iFirstMS1ScanNum)).setFeatures(t_lMS1Features);
        }
        return GRITSProcessStatus.OK;
    }

    private boolean annotateSubScans(Scan a_scanParent, GlycolipidMSAnnotator a_glAnnotator) {
        if (this.isCanceled()) {
            return false;
        }
        if (a_scanParent.getSubScans() == null || a_scanParent.getSubScans().isEmpty()) {
            return true;
        }
        int t_nAnnotatedSubscan = 0;
        for (Integer t_iSubScanNo : a_scanParent.getSubScans()) {
            List<Feature> t_lPrecursorFeatures;
            logger.debug((Object)("Processing scan #: " + t_iSubScanNo));
            this.updateListeners("Processing scan # " + t_iSubScanNo, t_iSubScanNo);
            if (this.isCanceled()) {
                return false;
            }
            Scan t_scanSub = (Scan)this.m_data.getScans().get(t_iSubScanNo);
            ScanReader t_scanRSub = this.wrapScan(t_scanSub, this.m_data.getDataHeader().getMethod());
            if (a_scanParent.getMsLevel() == 1) {
                t_lPrecursorFeatures = a_glAnnotator.annotateMS1Structures(t_scanRSub);
                ((ScanFeatures)this.m_data.getScanFeatures().get(a_scanParent.getScanNo())).getFeatures().addAll(t_lPrecursorFeatures);
            } else {
                t_lPrecursorFeatures = a_glAnnotator.annotateSubScan(t_scanRSub);
            }
            ((ScanFeatures)this.m_data.getScanFeatures().get(t_iSubScanNo)).setFeatures(this.getFragmentFeatures(t_lPrecursorFeatures));
            if (t_lPrecursorFeatures.isEmpty()) continue;
            ++t_nAnnotatedSubscan;
            if (this.annotateSubScans(t_scanSub, a_glAnnotator)) continue;
            return false;
        }
        a_scanParent.setNumAnnotatedPeaks(Integer.valueOf(t_nAnnotatedSubscan));
        return true;
    }

    private ScanFeatures createScanFeatures(Scan a_scan, List<Feature> a_lFeatures) {
        ScanFeatures t_scanF = new ScanFeatures();
        t_scanF.setScanId(a_scan.getScanNo().intValue());
        HashSet t_lScanPeaks = new HashSet();
        t_lScanPeaks.addAll(a_scan.getPeaklist());
        t_scanF.setScanPeaks(t_lScanPeaks);
        t_scanF.setFeatures(a_lFeatures);
        t_scanF.setUsesComplexRowId(Boolean.valueOf(true));
        return t_scanF;
    }

    private List<Feature> getFragmentFeatures(List<Feature> a_lPrecursorFeatures) {
        ArrayList<Feature> t_lFragmentFeatures = new ArrayList<Feature>();
        for (Feature t_fPre : a_lPrecursorFeatures) {
            if (t_fPre instanceof GlycolipidFeature) {
                GlycolipidFeature t_glfPre = (GlycolipidFeature)t_fPre;
                t_lFragmentFeatures.addAll(t_glfPre.getGlycanFragments());
                t_lFragmentFeatures.addAll(t_glfPre.getLipidFragments());
                t_lFragmentFeatures.addAll(t_glfPre.getGlycolipidFragments());
            }
            if (t_fPre instanceof GlycanFeature) {
                GlycanFeature t_gfPre = (GlycanFeature)t_fPre;
                t_lFragmentFeatures.addAll(t_gfPre.getGlycanFragment());
            }
            if (!(t_fPre instanceof LipidFeature)) continue;
            LipidFeature t_lfPre = (LipidFeature)t_fPre;
            t_lFragmentFeatures.addAll(t_lfPre.getLipidFragments());
        }
        return t_lFragmentFeatures;
    }

    private ScanReader wrapScan(Scan a_scan, Method a_method) {
        ScanReader t_scanR = new ScanReader(a_scan);
        t_scanR.setShift(a_method.getShift());
        t_scanR.setAccuracy(a_method.getAccuracy(), a_method.getAccuracyPpm());
        t_scanR.setFragmentAccuracy(a_method.getFragAccuracy(), a_method.getFragAccuracyPpm());
        if (a_scan.getMsLevel() == 1) {
            t_scanR.setIntencityCutoff(a_method.getPrecursorIntensityCutoff(), a_method.getPrecursorIntensityCutoffType());
        } else {
            t_scanR.setIntencityCutoff(a_method.getIntensityCutoff(), a_method.getIntensityCutoffType());
        }
        return t_scanR;
    }

    public boolean archiveData() {
        return this.archiveData(this.m_data, this.m_strZipFilepath);
    }

    public boolean archiveData(Data a_data, String a_strZipPath) {
        this.setMaxValue(1);
        this.updateListeners("Processing", 0);
        for (ScanFeatures t_sf : a_data.getScanFeatures().values()) {
            for (Feature t_f : t_sf.getFeatures()) {
                if (t_f instanceof GlycanFeature) {
                    ((GlycanFeature)t_f).getGlycanFragment().clear();
                }
                if (t_f instanceof LipidFeature) {
                    ((LipidFeature)t_f).getLipidFragments().clear();
                }
                if (!(t_f instanceof GlycolipidFeature)) continue;
                ((GlycolipidFeature)t_f).getGlycanFragments().clear();
                ((GlycolipidFeature)t_f).getLipidFragments().clear();
                ((GlycolipidFeature)t_f).getGlycolipidFragments().clear();
            }
        }
        try {
            AnnotationWriter t_annWriter = new AnnotationWriter();
            t_annWriter.generateScansAnnotationFiles(null, a_data, a_strZipPath, true, true, true, true);
            this.updateListeners("Done!", 1);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"An error in archive Data objects as zip file.", (Throwable)e);
            this.updateListeners("Failed.", 1);
            return false;
        }
    }

    public void addProgressListeners(IProgressListener lProgressListener) {
        this.m_lMyProgressListeners.add(lProgressListener);
    }

    public List<IProgressListener> getProgressListeners() {
        return this.m_lMyProgressListeners;
    }

    public boolean isCanceled() {
        return this.m_bCancel;
    }

    public void setCanceled(boolean bCancel) {
        this.m_bCancel = bCancel;
    }

    public void setMaxValue(int _iVal) {
        NotifyingProcessUtil.setMaxValue(this.getProgressListeners(), (int)_iVal);
    }

    public void setProgressListeners(List<IProgressListener> lProgressListeners) {
        this.m_lMyProgressListeners = lProgressListeners;
    }

    public void setProgressType(IProgressListener.ProgressType progressType) {
        NotifyingProcessUtil.setProgressType(this.getProgressListeners(), (IProgressListener.ProgressType)progressType);
    }

    public void updateErrorListener(String _sMsg) {
        NotifyingProcessUtil.updateErrorListener(this.getProgressListeners(), (String)_sMsg);
    }

    public void updateErrorListener(String _sMsg, Throwable t) {
        NotifyingProcessUtil.updateErrorListener(this.getProgressListeners(), (String)_sMsg, (Throwable)t);
    }

    public void updateListeners(String _sMsg, int _iVal) {
        NotifyingProcessUtil.updateListeners(this.getProgressListeners(), (String)_sMsg, (int)_iVal);
    }
}

