/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.report.dialog;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridEditor;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.dialog.ModalDialog;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.ListenerFactory;
import org.grits.toolbox.entry.ms.annotation.glycan.property.MSGlycanAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.glycan.report.adapter.MSGlycanAnnotationReportDialogAdapter;
import org.grits.toolbox.entry.ms.annotation.glycan.report.process.loader.MSGlycanAnnotationReportTableDataProcessorUtil;
import org.grits.toolbox.entry.ms.annotation.glycan.report.property.MSGlycanAnnotationReportProperty;
import org.grits.toolbox.entry.ms.annotation.glycan.report.property.datamodel.MSGlycanAnnotationReportMetaData;

public class MSGlycanAnnotationReportDialog
extends ModalDialog {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationReportDialog.class);
    private Text nameText;
    private String name;
    private Label nameLabel;
    private Text descriptionText;
    private String description;
    private Label descriptionLabel;
    private Label listLabel;
    private Label intervalLabel;
    private Text intervalText;
    private String interval = null;
    private boolean blnPPM;
    private Button btnPPMCheck = null;
    private Button daltonCheck = null;
    private Button okButton = null;
    private Button cancelButton = null;
    private String accuracyType = "Ppm";
    private List<Entry> msAnnEntryList = null;
    private MSGlycanAnnotationReportDialogAdapter msAnnEntrySelectionAdapter = null;
    private Grid msAnnDialogGrid = null;
    private Button btnUp = null;
    private Button btnDown = null;
    private HashMap<String, String> listEntries = new HashMap();

    public MSGlycanAnnotationReportDialog(Shell parentShell, List<Entry> entries) {
        super(parentShell);
        this.msAnnEntryList = entries == null ? new ArrayList<Entry>() : entries;
    }

    public void create() {
        super.create();
        this.setTitle("Merge MS Annotations");
        this.setMessage("");
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        this.initGrid(parent);
        this.createDisplayName(parent);
        this.createDescription(parent);
        this.createIntervalAndPpm(parent);
        this.createEmptyLine(parent);
        this.createListHeader(parent);
        this.createList(parent);
        this.createAddAndDelButtons(parent);
        this.createEmptyLine(parent);
        this.createLineSeparator(parent);
        this.createMergeOKAndCancelButtons(parent);
        return parent;
    }

    private void initGrid(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        gridLayout.verticalSpacing = 10;
        parent.setLayout((Layout)gridLayout);
    }

    private void createDisplayName(Composite parent) {
        GridData nameData = new GridData();
        nameData.grabExcessHorizontalSpace = false;
        this.nameLabel = new Label(parent, 0);
        this.nameLabel.setText("Display Name");
        this.nameLabel = this.setMandatoryLabel(this.nameLabel);
        this.nameLabel.setLayoutData((Object)nameData);
        GridData nameTextData = new GridData(768);
        nameTextData.grabExcessHorizontalSpace = true;
        nameTextData.horizontalSpan = 6;
        this.nameText = new Text(parent, 2048);
        this.nameText.setLayoutData((Object)nameTextData);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MSGlycanAnnotationReportDialog.this.isReadyToFinish()) {
                    MSGlycanAnnotationReportDialog.this.setPageComplete(true);
                } else {
                    MSGlycanAnnotationReportDialog.this.setPageComplete(false);
                }
            }
        });
    }

    private void createDescription(Composite parent) {
        GridData descriptionData = new GridData();
        descriptionData.grabExcessHorizontalSpace = false;
        this.descriptionLabel = new Label(parent, 0);
        this.descriptionLabel.setText("Description");
        this.descriptionLabel.setLayoutData((Object)descriptionData);
        GridData descriptionTextData = new GridData(1808);
        descriptionTextData.minimumHeight = 80;
        descriptionTextData.grabExcessHorizontalSpace = true;
        descriptionTextData.horizontalSpan = 6;
        this.descriptionText = new Text(parent, 2562);
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MSGlycanAnnotationReportDialog.this.isReadyToFinish()) {
                    MSGlycanAnnotationReportDialog.this.setPageComplete(true);
                } else {
                    MSGlycanAnnotationReportDialog.this.setPageComplete(false);
                }
            }
        });
        this.descriptionText.addTraverseListener(ListenerFactory.getTabTraverseListener());
        this.descriptionText.addKeyListener(ListenerFactory.getCTRLAListener());
    }

    private void createEmptyLine(Composite parent) {
        GridData dummy = new GridData();
        Label dummyLbl = new Label(parent, 0);
        dummy.grabExcessHorizontalSpace = true;
        dummy.horizontalSpan = 7;
        dummyLbl.setLayoutData((Object)dummy);
    }

    private void createLineSeparator(Composite parent) {
        GridData dummy = new GridData(768);
        Label separator = new Label(parent, 258);
        dummy.grabExcessHorizontalSpace = true;
        dummy.horizontalSpan = 7;
        separator.setLayoutData((Object)dummy);
    }

    private void createListHeader(Composite parent) {
        GridData listLabelData = new GridData();
        this.listLabel = new Label(parent, 0);
        listLabelData.grabExcessHorizontalSpace = true;
        listLabelData.horizontalSpan = 7;
        this.listLabel.setText("MS Annotations");
        this.listLabel.setLayoutData((Object)listLabelData);
        this.listLabel = this.setMandatoryLabel(this.listLabel);
    }

    private void createList(final Composite parent) {
        this.msAnnDialogGrid = new Grid(parent, 2048);
        this.msAnnDialogGrid.setHeaderVisible(true);
        GridColumn gridColumn = new GridColumn(this.msAnnDialogGrid, 0);
        gridColumn.setWidth(300);
        gridColumn.setText("Annotation Result Name");
        GridColumn gridColumn2 = new GridColumn(this.msAnnDialogGrid, 0);
        gridColumn2.setWidth(300);
        gridColumn2.setText("Alias (user-defined)");
        this.setListData();
        int desiredHeight = this.msAnnDialogGrid.getItemHeight() * (this.msAnnDialogGrid.getItemCount() + 1) + this.msAnnDialogGrid.getHeaderHeight();
        GridData gridData = new GridData(1808);
        gridData.minimumHeight = desiredHeight + 5;
        gridData.horizontalSpan = 6;
        gridData.verticalSpan = 2;
        this.msAnnDialogGrid.setLayoutData((Object)gridData);
        this.msAnnDialogGrid.setAutoHeight(true);
        this.btnUp = new Button(parent, 2180);
        this.btnUp.setText("Up");
        GridData gdBtnUp = new GridData(0x1000008, 1, false, true);
        gdBtnUp.horizontalSpan = 1;
        this.btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MSGlycanAnnotationReportDialog.this.moveItem(128);
            }
        });
        this.btnUp.setLayoutData((Object)gdBtnUp);
        this.btnDown = new Button(parent, 3076);
        this.btnDown.setText("D");
        GridData gdBtnDown = new GridData(0x1000008, 0x1000008, false, true);
        gdBtnDown.horizontalSpan = 1;
        this.btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MSGlycanAnnotationReportDialog.this.moveItem(1024);
            }
        });
        this.btnDown.setLayoutData((Object)gdBtnDown);
        this.msAnnDialogGrid.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                int desiredHeight = MSGlycanAnnotationReportDialog.this.msAnnDialogGrid.getItemHeight() * (MSGlycanAnnotationReportDialog.this.msAnnDialogGrid.getItemCount() + 1) + MSGlycanAnnotationReportDialog.this.msAnnDialogGrid.getHeaderHeight();
                GridData gd = (GridData)MSGlycanAnnotationReportDialog.this.msAnnDialogGrid.getLayoutData();
                gd.minimumHeight = desiredHeight + 5;
                MSGlycanAnnotationReportDialog.this.msAnnDialogGrid.setLayoutData((Object)gd);
                parent.layout();
                if (MSGlycanAnnotationReportDialog.this.isReadyToFinish()) {
                    MSGlycanAnnotationReportDialog.this.setPageComplete(true);
                } else {
                    MSGlycanAnnotationReportDialog.this.setPageComplete(false);
                }
            }
        });
        final GridEditor editor = new GridEditor(this.msAnnDialogGrid);
        this.msAnnDialogGrid.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                Point pt = new Point(e.x, e.y);
                final GridItem item = MSGlycanAnnotationReportDialog.this.msAnnDialogGrid.getItem(pt);
                final Point cell = MSGlycanAnnotationReportDialog.this.msAnnDialogGrid.getCell(pt);
                if (item == null || cell == null) {
                    return;
                }
                if (cell.x == 0) {
                    return;
                }
                MSGlycanAnnotationReportDialog.this.msAnnDialogGrid.deselect(cell.y);
                final Text newEditor = new Text((Composite)MSGlycanAnnotationReportDialog.this.msAnnDialogGrid, 2052);
                String curText = item.getText(cell.x);
                newEditor.setText(curText);
                editor.setEditor((Control)newEditor, item, cell.x);
                editor.grabHorizontal = true;
                editor.grabVertical = true;
                newEditor.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                        item.setText(cell.x, newEditor.getText());
                        MSGlycanAnnotationReportDialog.this.listEntries.put(item.getText(0), newEditor.getText());
                        if (MSGlycanAnnotationReportDialog.this.isReadyToFinish()) {
                            MSGlycanAnnotationReportDialog.this.setPageComplete(true);
                        } else {
                            MSGlycanAnnotationReportDialog.this.setPageComplete(false);
                        }
                    }

                    public void keyPressed(KeyEvent e) {
                    }
                });
                newEditor.forceFocus();
                newEditor.setSelection(newEditor.getText().length());
                newEditor.selectAll();
            }
        });
    }

    private void setListData() {
        int i = 0;
        while (i < this.msAnnEntryList.size()) {
            String displayName;
            Entry entry = this.msAnnEntryList.get(i);
            MSGlycanAnnotationProperty prop = (MSGlycanAnnotationProperty)entry.getProperty();
            String sEntryId = prop.getMSAnnotationMetaData().getAnnotationId();
            if (sEntryId != null && (displayName = MSGlycanAnnotationReportTableDataProcessorUtil.getDisplayNameByEntryName(sEntryId)) != null) {
                this.listEntries.put(displayName, displayName);
                GridItem item = new GridItem(this.msAnnDialogGrid, 0);
                item.setText(0, displayName);
                item.setBackground(0, Display.getCurrent().getSystemColor(22));
                item.setText(1, displayName);
            }
            ++i;
        }
    }

    private void moveItem(int direction) {
        int iFoundPos = this.msAnnDialogGrid.getSelectionIndex();
        if (iFoundPos < 0) {
            return;
        }
        GridItem foundItem = this.msAnnDialogGrid.getItem(iFoundPos);
        GridItem switchItem = null;
        int iSwitchInx = -1;
        if (direction == 128) {
            if (iFoundPos == 0) {
                return;
            }
            iSwitchInx = iFoundPos - 1;
        } else {
            if (iFoundPos == this.msAnnDialogGrid.getItemCount() - 1) {
                return;
            }
            iSwitchInx = iFoundPos + 1;
        }
        switchItem = this.msAnnDialogGrid.getItem(iSwitchInx);
        String s0 = switchItem.getText(0);
        String s1 = switchItem.getText(1);
        switchItem.setText(0, foundItem.getText(0));
        switchItem.setText(1, foundItem.getText(1));
        foundItem.setText(0, s0);
        foundItem.setText(1, s1);
        this.msAnnDialogGrid.setSelection(iSwitchInx);
        Entry curEntry = this.msAnnEntryList.remove(iFoundPos);
        this.msAnnEntryList.add(iSwitchInx, curEntry);
        logger.debug((Object)"Done with move");
    }

    private void createAddAndDelButtons(Composite parent) {
        Label dummy = new Label(parent, 0);
        GridData gdDummy = new GridData();
        dummy.setLayoutData((Object)gdDummy);
        Label dummy2 = new Label(parent, 0);
        GridData gdDummy2 = new GridData();
        gdDummy2.horizontalSpan = 2;
        gdDummy2.grabExcessHorizontalSpace = true;
        dummy2.setLayoutData((Object)gdDummy2);
        Label dummy3 = new Label(parent, 0);
        GridData gdDummy3 = new GridData();
        dummy3.setLayoutData((Object)gdDummy3);
        GridData gdAddBtn = new GridData();
        gdAddBtn.grabExcessHorizontalSpace = false;
        gdAddBtn.horizontalAlignment = 3;
        gdAddBtn.horizontalSpan = 1;
        Button btnAddButton = new Button(parent, 8);
        btnAddButton.setText("  Add  ");
        this.msAnnEntrySelectionAdapter = new MSGlycanAnnotationReportDialogAdapter(this.getAnnotationPropertyType(), "MS Annotation Selection", "Choose an annotation to add");
        this.msAnnEntrySelectionAdapter.setParent(parent);
        this.msAnnEntrySelectionAdapter.setList(this.msAnnDialogGrid);
        this.msAnnEntrySelectionAdapter.setListEntries(this.listEntries);
        this.msAnnEntrySelectionAdapter.setEntries(this.msAnnEntryList);
        btnAddButton.addSelectionListener((SelectionListener)this.msAnnEntrySelectionAdapter);
        btnAddButton.setLayoutData((Object)gdAddBtn);
        Button deleteButton = new Button(parent, 8);
        GridData gdDelBtn = new GridData();
        gdDelBtn.grabExcessHorizontalSpace = false;
        gdDelBtn.horizontalAlignment = 3;
        gdDelBtn.horizontalSpan = 1;
        deleteButton.setText("Delete");
        deleteButton.setLayoutData((Object)gdDelBtn);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int iRemoveInx = MSGlycanAnnotationReportDialog.this.msAnnDialogGrid.getSelectionIndex();
                MSGlycanAnnotationReportDialog.this.msAnnEntryList.remove(iRemoveInx);
                MSGlycanAnnotationReportDialog.this.msAnnDialogGrid.remove(iRemoveInx);
                MSGlycanAnnotationReportDialog.this.listEntries.clear();
                int i = 0;
                while (i < MSGlycanAnnotationReportDialog.this.msAnnDialogGrid.getItemCount()) {
                    String displayName = MSGlycanAnnotationReportDialog.this.msAnnDialogGrid.getItem(i).getText(0).trim();
                    String alias = MSGlycanAnnotationReportDialog.this.msAnnDialogGrid.getItem(i).getText(1).trim();
                    MSGlycanAnnotationReportDialog.this.listEntries.put(displayName, alias);
                    ++i;
                }
                if (MSGlycanAnnotationReportDialog.this.listEntries.isEmpty()) {
                    MSGlycanAnnotationReportDialog.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(parent, 0);
    }

    protected String getAnnotationPropertyType() {
        return "org.grits.toolbox.property.ms_annotation.glycan";
    }

    private void createIntervalAndPpm(Composite parent) {
        this.intervalLabel = new Label(parent, 0);
        this.intervalLabel.setText("Interval");
        this.intervalLabel = this.setMandatoryLabel(this.intervalLabel);
        this.intervalText = new Text(parent, 2052);
        this.intervalText.setText("500");
        this.interval = "500";
        GridData intervalgd = new GridData(768);
        intervalgd.horizontalSpan = 3;
        this.intervalText.setLayoutData((Object)intervalgd);
        this.intervalText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MSGlycanAnnotationReportDialog.this.interval = MSGlycanAnnotationReportDialog.this.intervalText.getText();
                if (!MSGlycanAnnotationReportDialog.this.intervalText.getText().isEmpty()) {
                    if (MSGlycanAnnotationReportDialog.this.isReadyToFinish()) {
                        MSGlycanAnnotationReportDialog.this.setPageComplete(true);
                    } else {
                        MSGlycanAnnotationReportDialog.this.setPageComplete(false);
                    }
                } else {
                    MSGlycanAnnotationReportDialog.this.setPageComplete(false);
                }
            }
        });
        this.btnPPMCheck = new Button(parent, 16);
        this.btnPPMCheck.setSelection(true);
        this.btnPPMCheck.setText("PPM");
        this.blnPPM = true;
        this.btnPPMCheck.setLayoutData((Object)new GridData(128));
        this.btnPPMCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!MSGlycanAnnotationReportDialog.this.btnPPMCheck.getSelection()) {
                    MSGlycanAnnotationReportDialog.this.btnPPMCheck.setSelection(true);
                    MSGlycanAnnotationReportDialog.this.accuracyType = "Ppm";
                } else {
                    MSGlycanAnnotationReportDialog.this.daltonCheck.setSelection(false);
                }
                MSGlycanAnnotationReportDialog.this.blnPPM = MSGlycanAnnotationReportDialog.this.btnPPMCheck.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.daltonCheck = new Button(parent, 16);
        this.daltonCheck.setText("Dalton");
        this.daltonCheck.setLayoutData((Object)new GridData(128));
        this.daltonCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!MSGlycanAnnotationReportDialog.this.daltonCheck.getSelection()) {
                    MSGlycanAnnotationReportDialog.this.daltonCheck.setSelection(true);
                    MSGlycanAnnotationReportDialog.this.accuracyType = "Dalton";
                } else {
                    MSGlycanAnnotationReportDialog.this.btnPPMCheck.setSelection(false);
                }
                MSGlycanAnnotationReportDialog.this.blnPPM = MSGlycanAnnotationReportDialog.this.btnPPMCheck.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(parent, 0);
    }

    private void createMergeOKAndCancelButtons(Composite parent) {
        Label dummy2 = new Label(parent, 0);
        GridData gdDummy2 = new GridData();
        gdDummy2.horizontalSpan = 4;
        gdDummy2.grabExcessHorizontalSpace = true;
        dummy2.setLayoutData((Object)gdDummy2);
        GridData cancelData = new GridData();
        cancelData.grabExcessHorizontalSpace = false;
        cancelData.horizontalAlignment = 3;
        cancelData.horizontalSpan = 1;
        this.cancelButton = new Button(parent, 8);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MSGlycanAnnotationReportDialog.this.cancelPressed();
            }
        });
        this.cancelButton.setLayoutData((Object)cancelData);
        GridData okData = new GridData();
        okData.grabExcessHorizontalSpace = false;
        okData.horizontalAlignment = 3;
        okData.horizontalSpan = 1;
        this.okButton = new Button(parent, 8);
        this.okButton.setText("   OK   ");
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MSGlycanAnnotationReportDialog.this.okPressed();
                MSGlycanAnnotationReportDialog.this.close();
            }
        });
        this.okButton.setLayoutData((Object)okData);
        if (this.isReadyToFinish()) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
        new Label(parent, 0);
    }

    protected boolean isReadyToFinish() {
        if (!this.intervalText.getText().isEmpty() && !this.nameText.getText().isEmpty() && this.msAnnDialogGrid.getItemCount() != 0) {
            if (!this.checkBasicLengthCheck(this.nameLabel, this.nameText, 0, 32)) {
                return false;
            }
            if (this.msAnnEntryList != null && this.msAnnEntryList.size() != 0) {
                for (Entry child : DataModelSearch.findParentByType((Entry)this.msAnnEntryList.get(0), (String)"org.grits.toolbox.property.project").getChildren()) {
                    if (!child.getProperty().getType().equals("org.grits.toolbox.property.report.ms_annotation_merge")) continue;
                    for (Entry child2 : child.getChildren()) {
                        if (!child2.getDisplayName().equals(this.nameText.getText())) continue;
                        this.setError(this.nameLabel, "The name is in use. Please choose another name.");
                        return false;
                    }
                }
            }
            if (!this.descriptionLabel.getText().isEmpty() && !this.checkBasicLengthCheck(this.descriptionLabel, this.descriptionText, 0, Integer.parseInt(PropertyHandler.getVariable((String)"descriptionLength")))) {
                return false;
            }
            boolean ok = true;
            try {
                double number = Double.parseDouble(this.intervalText.getText());
                if (number < 0.0) {
                    ok = false;
                    this.setError(this.intervalLabel, "Interval (" + this.intervalText.getText() + ") cannot be less than 0");
                }
            }
            catch (NumberFormatException numberFormatException) {
                ok = false;
                this.setError(this.intervalLabel, "Interval (" + this.intervalText.getText() + ") is an invalid number");
            }
            if (!ok) {
                return false;
            }
            this.removeError(this.intervalLabel);
            ArrayList<String> alContains = new ArrayList<String>();
            int i = 0;
            while (i < this.msAnnDialogGrid.getItemCount()) {
                String displayName = this.msAnnDialogGrid.getItem(i).getText(0);
                String alias = this.msAnnDialogGrid.getItem(i).getText(1);
                if (alias.equals("")) {
                    this.setErrorMessage("Alias for " + displayName + " cannot be blank.");
                    return false;
                }
                if (alContains.contains(alias)) {
                    this.setErrorMessage("Duplicate aliases are not allowed.");
                    return false;
                }
                alContains.add(alias);
                ++i;
            }
            this.setErrorMessage(null);
            return true;
        }
        return false;
    }

    private void setPageComplete(boolean flag) {
        if (flag) {
            this.name = this.nameText.getText();
            this.description = this.descriptionText.getText();
        }
        this.okButton.setEnabled(flag);
    }

    protected boolean isValidInput() {
        return true;
    }

    public Entry createEntry() {
        Entry simGlycanMergerEntry = new Entry();
        simGlycanMergerEntry.setDisplayName(this.name);
        MSGlycanAnnotationReportProperty property = new MSGlycanAnnotationReportProperty();
        MSGlycanAnnotationReportMetaData metaData = new MSGlycanAnnotationReportMetaData();
        metaData.setName(this.name);
        metaData.setVersion("1.1");
        metaData.setDescription(this.description);
        metaData.setCreationDate(new Date());
        metaData.setUpdateDate(metaData.getCreationDate());
        property.setMsGlycanAnnotReportMetaData(metaData);
        simGlycanMergerEntry.setProperty((Property)property);
        return simGlycanMergerEntry;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setSimGLycanEntryList(List<Entry> simGLycanEntryList) {
        this.msAnnEntryList = simGLycanEntryList;
    }

    public boolean getPPM() {
        return this.blnPPM;
    }

    public double getInterval() {
        return Double.parseDouble(this.interval);
    }

    public String getAccuracyType() {
        return this.accuracyType;
    }

    public void setAccuracyType(String accuracyType) {
        this.accuracyType = accuracyType;
    }

    public List<Entry> getAnnotationEntryList() {
        return this.msAnnEntryList;
    }

    public String getAnnotationInfo(String sEntryName) {
        return this.listEntries.get(sEntryName);
    }
}

