/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jrockit.jfr.client;

import com.oracle.jrockit.jfr.management.FlightRecorderMBean;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.openmbean.EventDefaultType;
import oracle.jrockit.jfr.openmbean.EventDescriptorType;
import oracle.jrockit.jfr.openmbean.EventSettingType;
import oracle.jrockit.jfr.settings.EventDefault;
import oracle.jrockit.jfr.settings.EventDefaultSet;
import oracle.jrockit.jfr.settings.EventSetting;

@Deprecated
public final class EventSettingsBuilder {
    private final ArrayList<EventDefaultSet> eventDefaultSets = new ArrayList();
    private final ArrayList<EventSetting> settings = new ArrayList();
    private final EventDescriptorType eventDescriptorType;
    private final EventSettingType eventSettingType;
    private final EventDefaultType eventDefaultType;

    public EventSettingsBuilder() {
        try {
            this.eventDescriptorType = new EventDescriptorType();
            this.eventSettingType = new EventSettingType(null);
            this.eventDefaultType = new EventDefaultType();
        }
        catch (OpenDataException openDataException) {
            throw new InternalError();
        }
    }

    public void addSettings(File file) throws IOException, URISyntaxException, ParseException {
        this.eventDefaultSets.add(EventDefaultSet.create(file));
    }

    public void addSettings(String string) throws IOException, URISyntaxException, ParseException {
        this.eventDefaultSets.add(EventDefaultSet.create(string));
    }

    public void addSettings(Reader reader) throws IOException, URISyntaxException, ParseException {
        this.eventDefaultSets.add(EventDefaultSet.create(reader));
    }

    public void addSettings(EventDefaultSet eventDefaultSet) {
        this.eventDefaultSets.add(eventDefaultSet);
    }

    public void createSetting(String string, boolean bl, boolean bl2, long l, long l2) throws URISyntaxException {
        this.eventDefaultSets.add(new EventDefaultSet(new EventDefault(new URI(string), new EventSetting(0, bl, bl2, l, l2))));
    }

    public void createSetting(int n, boolean bl, boolean bl2, long l, long l2) throws URISyntaxException {
        this.settings.add(new EventSetting(n, bl, bl2, l, l2));
    }

    public List<CompositeData> createSettings(FlightRecorderMBean flightRecorderMBean) throws OpenDataException {
        ArrayList<CompositeData> arrayList = new ArrayList<CompositeData>();
        if (!this.eventDefaultSets.isEmpty()) {
            for (CompositeData compositeData : flightRecorderMBean.getProducers()) {
                CompositeData[] compositeDataArray = (CompositeData[])compositeData.get("events");
                for (EventDescriptor eventDescriptor : this.eventDescriptorType.toJavaTypeData(Arrays.asList(compositeDataArray))) {
                    EventSetting eventSetting = null;
                    for (EventDefaultSet eventDefaultSet : this.eventDefaultSets) {
                        EventSetting eventSetting2 = eventDefaultSet.get(eventDescriptor.getURI());
                        if (eventSetting2 == null) continue;
                        eventSetting = eventSetting != null ? new EventSetting(eventSetting, eventSetting2) : new EventSetting(eventDescriptor, eventSetting2);
                    }
                    if (eventSetting == null) continue;
                    arrayList.add(this.eventSettingType.toCompositeTypeData(eventSetting));
                }
            }
        }
        arrayList.addAll(this.eventSettingType.toCompositeData(this.settings));
        return arrayList;
    }

    public List<CompositeData> createDefaultSettings() throws OpenDataException {
        ArrayList<EventDefault> arrayList = new ArrayList<EventDefault>();
        for (EventDefaultSet eventDefaultSet : this.eventDefaultSets) {
            arrayList.addAll(eventDefaultSet.getAll());
        }
        return this.eventDefaultType.toCompositeData(arrayList);
    }
}

