/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC;

import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACNotationConverter;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.MonosaccharideIndex;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameException;

public class ExtendedConverter
extends IUPACNotationConverter {
    public String start(Node _node) throws GlycanException, TrivialNameException {
        Node copy = _node.copy();
        this.makeTrivialName(copy);
        return this.makeExtendedNotation(copy);
    }

    public String makeExtendedNotation(Node _copy) throws TrivialNameException {
        Monosaccharide mono = (Monosaccharide)_copy;
        String threeLetter = this.getThreeLetterCode().toString();
        String configuration = "?";
        if (!mono.getStereos().isEmpty()) {
            configuration = this.makeConfiguration(mono.getStereos().getFirst()).toUpperCase();
        }
        StringBuilder ret = new StringBuilder(threeLetter);
        MonosaccharideIndex monoInd = MonosaccharideIndex.forTrivialNameWithIgnore(threeLetter);
        if (monoInd != null) {
            ret.insert(0, String.valueOf(configuration) + "-");
        }
        if (monoInd == null && mono.getStereos().size() != 2) {
            ret.insert(0, String.valueOf(configuration) + "-");
        }
        String deoxyNotation = this.makeDeoxyPosition(mono);
        if (!ret.toString().contains(deoxyNotation)) {
            ret.insert(0, deoxyNotation);
        }
        ret.insert(0, this.getSubConv().getPrefixSubstituent());
        ret.append(this.extractUlonic(mono));
        ret.append(this.defineRingSize(_copy));
        ret.append(this.getSubConv().getCoreSubstituentNotaiton());
        String acidicStatus = this.makeAcidicStatus(_copy);
        if (acidicStatus.equals("A")) {
            ret.append(acidicStatus);
        }
        ret.append(this.getSubConv().getSubstituentNotation());
        if (!acidicStatus.equals("A") && !this.containUlonicAcid(this.getThreeLetterCode())) {
            ret.append(acidicStatus);
        }
        ret = new StringBuilder(this.defineAnomericState(_copy, ret));
        if (this.isAlditol(_copy)) {
            ret.append("-ol");
        }
        if (this.isAldehyde(_copy)) {
            ret.insert(0, "aldehyde-");
        }
        return ret.toString();
    }

    private String defineAnomericState(Node _node, StringBuilder sb) {
        Monosaccharide mono = (Monosaccharide)_node;
        StringBuilder ret = new StringBuilder(sb);
        AnomericStateDescriptor enumAnom = mono.getAnomer();
        String anomericState = "";
        if (enumAnom != null && !enumAnom.getIUPACAnomericState().equals("")) {
            anomericState = String.valueOf(enumAnom.getIUPACAnomericState()) + "-";
        }
        if (mono.getStereos().size() == 2 && this.haveStereosInTrivial(_node)) {
            String firstComp = mono.getStereos().getFirst();
            firstComp = this.trimThreeLetterPrefix(firstComp, this.extractDLconfiguration(firstComp)).toLowerCase();
            ret.insert(ret.indexOf(firstComp) + 4, anomericState);
        } else {
            ret.insert(0, anomericState);
        }
        return ret.toString();
    }

    private boolean haveStereosInTrivial(Node _node) {
        String temp = this.getThreeLetterCode().toLowerCase();
        boolean ret = true;
        for (String stereo : ((Monosaccharide)_node).getStereos()) {
            if (temp.contains(stereo = this.trimThreeLetterPrefix(stereo, this.extractDLconfiguration(stereo)).toLowerCase())) continue;
            ret = false;
            break;
        }
        return ret;
    }

    private String trimThreeLetterPrefix(String _letter, String _configuration) {
        if (_configuration.equals("?")) {
            if (_letter.startsWith("d/l-")) {
                _letter = _letter.replaceFirst("d/l-", "");
            }
            if (_letter.startsWith("l/d-")) {
                _letter = _letter.replaceFirst("l/d-", "");
            }
        } else {
            _letter = _letter.replaceFirst(_configuration, "");
        }
        StringBuilder ret = new StringBuilder(_letter);
        ret = ret.replace(0, 1, ret.substring(0, 1).toUpperCase());
        return ret.toString();
    }
}

