/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GlycanNamescheme {
    GLYCOCT("GlycoCT", true),
    CARBBANK("CarbBank", false),
    IUPAC("IUPAC", CARBBANK, false),
    GLYCOSCIENCES("Glycosciences", CARBBANK, false),
    BCSDB("BCSDB", true),
    GLYDE("Glyde", true),
    SWEET2("Sweet2", CARBBANK, false),
    KEGG("KEGG", false),
    CFG("CFG", true),
    MONOSACCHARIDEDB("MsDb", GLYCOCT, true),
    GWB("GlycoWorkBench", CARBBANK, false),
    PDB("Protein Data Bank", false),
    CCPN("CCPN", false),
    GLYCAM("GlyCam", true),
    AUTO("auto-detect", false);

    private String nameStr;
    private GlycanNamescheme baseScheme;
    private boolean isCaseSensitive;

    private GlycanNamescheme(String name, boolean isCaseSens) {
        this.nameStr = name;
        this.baseScheme = this;
        this.isCaseSensitive = isCaseSens;
    }

    private GlycanNamescheme(String name, GlycanNamescheme base, boolean isCaseSens) {
        this.nameStr = name;
        this.baseScheme = base;
        this.isCaseSensitive = isCaseSens;
    }

    public String getNameStr() {
        return this.nameStr;
    }

    public GlycanNamescheme getBaseScheme() {
        return this.baseScheme;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public static GlycanNamescheme forName(String name) {
        for (GlycanNamescheme scheme : GlycanNamescheme.values()) {
            if (!scheme.getNameStr().equalsIgnoreCase(name) && !scheme.name().equalsIgnoreCase(name)) continue;
            return scheme;
        }
        return null;
    }

    public static GlycanNamescheme getGlycanNameschemeByNamestr(String name) {
        return GlycanNamescheme.forName(name);
    }
}

