/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.editor.experimentdesigner.dialog.ProtocolCreationDialog;
import org.grits.toolbox.editor.experimentdesigner.io.ProtocolFileHandler;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.Paper;
import org.grits.toolbox.editor.experimentdesigner.model.Parameter;
import org.grits.toolbox.editor.experimentdesigner.model.ParameterGroup;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;

public class GraphNodeCreateCommand
extends Command {
    private GraphNode newNode;
    private final ExperimentGraph parent;
    private final GraphicalViewer graphViewer;
    private Rectangle bounds;

    public GraphNodeCreateCommand(GraphNode newNode, GraphicalViewer viewer, ExperimentGraph parent, Rectangle bounds) {
        this.newNode = newNode;
        this.parent = parent;
        this.bounds = bounds;
        this.graphViewer = viewer;
        this.setLabel("node creation");
    }

    public boolean canExecute() {
        return this.newNode != null && this.parent != null && this.bounds != null;
    }

    public void execute() {
        this.newNode.setLocation(this.bounds.getLocation());
        Dimension size = this.bounds.getSize();
        if (size.width > 0 && size.height > 0) {
            this.newNode.setSize(size);
        }
        Shell shell = Display.getCurrent().getActiveShell();
        ProtocolCreationDialog dialog = new ProtocolCreationDialog(shell, this.newNode);
        dialog.create();
        dialog.getShell().setSize(500, 500);
        if (dialog.open() == 0) {
            if (this.newNode instanceof ProtocolNode) {
                ProtocolNode instanceNode = new ProtocolNode();
                ProtocolNode node = dialog.getExisting();
                if (node != null) {
                    instanceNode.setLabel(node.getLabel());
                    if (dialog.getDescription() != null) {
                        instanceNode.setDescription(dialog.getDescription());
                    } else {
                        instanceNode.setDescription(node.getDescription());
                    }
                    instanceNode.setCategory(node.getCategory());
                    instanceNode.setPapers(node.getPapers());
                    instanceNode.setParameters(node.getParameters());
                    instanceNode.setParameterGroups(node.getParameterGroups());
                    instanceNode.setColor(node.getColor());
                    instanceNode.setTemplate(node.getTemplate());
                    instanceNode.setTemplateUri(node.getTemplateUri());
                    instanceNode.setUri(node.getUri());
                    instanceNode.setCreator(node.getCreator());
                    instanceNode.setUrl(node.getUrl());
                    if (node.getFile() != null) {
                        instanceNode.setFile(ProtocolFileHandler.copyFromConfigToWorkspace(node.getFile(), this.parent.getProjectEntry().getDisplayName()));
                    }
                } else {
                    instanceNode.setLabel(dialog.getName());
                    instanceNode.setCategory(((ProtocolNode)this.newNode).getCategory());
                    instanceNode.setColor(this.newNode.getColor());
                    instanceNode.setUri(this.newNode.getUri());
                    instanceNode.setUrl(((ProtocolNode)this.newNode).getUrl());
                    if (((ProtocolNode)this.newNode).getFile() != null) {
                        String filename = null;
                        filename = ProtocolFileHandler.copyFromConfigToWorkspace(((ProtocolNode)this.newNode).getFile(), this.parent.getProjectEntry().getDisplayName());
                        if (filename != null) {
                            instanceNode.setFile(filename);
                        } else {
                            instanceNode.setFile(ProtocolFileHandler.copyFromJarToWorkspace(((ProtocolNode)this.newNode).getFile(), this.parent.getProjectEntry().getDisplayName()));
                        }
                    }
                    instanceNode.setDescription(dialog.getDescription());
                    instanceNode.setCreator(((ProtocolNode)this.newNode).getCreator());
                    instanceNode.setTemplate(this.newNode.getLabel());
                    instanceNode.setTemplateUri(((ProtocolNode)this.newNode).getTemplateUri());
                    List<Parameter> params = ((ProtocolNode)this.newNode).getParameters();
                    ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                    if (params != null) {
                        for (Parameter p : params) {
                            parameters.add(new Parameter(p));
                        }
                    }
                    instanceNode.setParameters(parameters);
                    List<ParameterGroup> paramGroups = ((ProtocolNode)this.newNode).getParameterGroups();
                    ArrayList<ParameterGroup> parameterGroups = new ArrayList<ParameterGroup>();
                    if (paramGroups != null) {
                        for (ParameterGroup g : paramGroups) {
                            parameterGroups.add(new ParameterGroup(g));
                        }
                    }
                    instanceNode.setParameterGroups(parameterGroups);
                    List<Paper> papers = ((ProtocolNode)this.newNode).getPapers();
                    if (papers != null) {
                        instanceNode.setPapers(new ArrayList<Paper>(papers));
                    } else {
                        instanceNode.setPapers(new ArrayList<Paper>());
                    }
                }
                instanceNode.setLocation(this.newNode.getLocation());
                instanceNode.setSize(this.newNode.getSize());
                this.newNode = instanceNode;
            }
            this.redo();
        }
    }

    public void redo() {
        this.parent.addChild(this.newNode);
        EditPart part = (EditPart)this.graphViewer.getEditPartRegistry().get(this.newNode);
        this.graphViewer.select(part);
    }

    public void undo() {
        this.parent.removeChild(this.newNode);
    }
}

