/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.property;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.entry.ms.property.FileLock;
import org.grits.toolbox.entry.ms.property.FileLockingUtils;
import org.grits.toolbox.entry.ms.property.LockEntry;

@XmlRootElement(name="file_locks")
public class FileLockManager {
    private static final Logger logger = Logger.getLogger(FileLockManager.class);
    public static final String LOCKFILE_NAME = ".lockFile";
    private List<FileLock> fileList = new ArrayList<FileLock>();

    public FileLockManager(String filePath) {
        try {
            FileLockManager loaded = FileLockingUtils.readLockFile(filePath);
            this.fileList = loaded.fileList;
        }
        catch (IOException e) {
            logger.error((Object)"Lock file cannot be loaded", (Throwable)e);
        }
        catch (JAXBException e) {
            logger.error((Object)"Lock file cannot be loaded", (Throwable)e);
        }
    }

    public FileLockManager() {
    }

    public List<FileLock> getFileList() {
        return this.fileList;
    }

    public void setFileList(List<FileLock> fileList) {
        this.fileList = fileList;
    }

    public void lockFile(String fileName, Entry entry) {
        FileLock existing = this.findFile(fileName);
        if (existing == null) {
            existing = new FileLock();
            existing.setFilename(fileName);
            this.fileList.add(existing);
        }
        existing.addEntry(entry);
        existing.incrementLock();
    }

    public void addFile(String fileName) {
        FileLock existing = this.findFile(fileName);
        if (existing == null) {
            existing = new FileLock();
            existing.setFilename(fileName);
            this.fileList.add(existing);
        }
    }

    public FileLock findFile(String filename) {
        File file = new File(filename);
        for (FileLock fileLock : this.fileList) {
            File file2 = new File(fileLock.getFilename());
            if (!file.getName().equals(file2.getName()) || file.getParent() != null && !file.getParent().equals(file2.getParent())) continue;
            return fileLock;
        }
        return null;
    }

    public boolean isFileLocked(String filename) {
        FileLock existing = this.findFile(filename);
        if (existing != null) {
            return existing.isLocked();
        }
        return false;
    }

    public void deleteFile(String fileName) {
        FileLock existing = this.findFile(fileName);
        if (existing != null) {
            this.fileList.remove(existing);
        }
    }

    public void lockFile(String fileName, LockEntry entry) {
        FileLock existing = this.findFile(fileName);
        if (existing == null) {
            existing = new FileLock();
            existing.setFilename(fileName);
            this.fileList.add(existing);
        }
        existing.addEntry(entry);
        existing.incrementLock();
    }

    public void removeLock(String fileName, LockEntry usedBy) {
        FileLock existing = this.findFile(fileName);
        if (existing != null) {
            existing.decrementLock();
            existing.removeEntry(usedBy);
        }
    }

    public void removeLock(String fileName, Entry entry) {
        FileLock existing = this.findFile(fileName);
        if (existing != null) {
            existing.decrementLock();
            existing.deleteEntry(entry);
        }
    }
}

