/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.process.loader;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.datamodel.ms.annotation.glycan.preference.MSGlycanAnnotationViewerPreference;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.MSGlycanAnnotationTableDataObject;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.dmtranslate.DMGlycanAnnotation;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate.DMAnnotation;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate.DMFeature;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPrecursorPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMScan;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.glycan.extquantfiles.process.MSGlycanAnnotationCustomAnnotationProcessor;
import org.grits.toolbox.entry.ms.annotation.glycan.process.loader.MSGlycanAnnotationTableDataProcessorUtil;
import org.grits.toolbox.entry.ms.annotation.glycan.property.MSGlycanAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.glycan.property.datamodel.MSGlycanAnnotationMetaData;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.extquantfiles.process.CustomAnnotationDataProcessor;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessorUtil;
import org.grits.toolbox.ms.file.extquant.data.ExternalQuantSettings;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.AnnotationFilter;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycanFeature;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScanFeatures;

public class MSGlycanAnnotationTableDataProcessor
extends MSAnnotationTableDataProcessor {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationTableDataProcessor.class);
    private AnnotationFilter filter = null;

    public MSGlycanAnnotationTableDataProcessor(Entry _entry, Property _sourceProperty, int iMinMSLevel) {
        super(_entry, _sourceProperty, iMinMSLevel);
    }

    public MSGlycanAnnotationTableDataProcessor(Entry _entry, Property _sourceProperty, FillTypes _fillType, int iMinMSLevel) {
        super(_entry, _sourceProperty, _fillType, iMinMSLevel);
    }

    public MSGlycanAnnotationTableDataProcessor(TableDataProcessor _parent, Property _sourceProperty, FillTypes _fillType, int iMinMSLevel) {
        super(_parent, _sourceProperty, _fillType, iMinMSLevel);
    }

    protected int addCustomAnnotationPeaks(MassSpecViewerPreference _preferences, CustomAnnotationDataProcessor _processor) {
        int iColCnt = super.addCustomAnnotationPeaks(_preferences, _processor);
        return iColCnt;
    }

    public boolean createTable() throws Exception {
        return super.createTable();
    }

    public boolean readDataFromFile() {
        boolean bSuccess = super.readDataFromFile();
        return bSuccess;
    }

    public void initializeTableDataObject(Property _sourceProperty) {
        this.setSimianTableDataObject((MassSpecTableDataObject)new MSGlycanAnnotationTableDataObject(this.getMassSpecEntityProperty().getMsLevel().intValue(), this.fillType));
        this.getSimianTableDataObject().initializePreferences();
        if (this.getSimianTableDataObject().getTablePreferences().settingsNeedInitialization()) {
            TableViewerPreference tvp = this.initializePreferences();
            MSGlycanAnnotationTableDataProcessor.setDefaultColumnViewSettings(this.fillType, tvp.getPreferenceSettings());
            this.getSimianTableDataObject().setTablePreferences(tvp);
            this.getSimianTableDataObject().getTablePreferences().writePreference();
        }
    }

    protected TableViewerPreference getNewTableViewerPreferences() {
        return new MSGlycanAnnotationViewerPreference();
    }

    public TableViewerPreference initializePreferences() {
        MSGlycanAnnotationViewerPreference newPreferences = (MSGlycanAnnotationViewerPreference)super.initializePreferences();
        MSGlycanAnnotationViewerPreference oldPreferences = (MSGlycanAnnotationViewerPreference)this.getSimianTableDataObject().getTablePreferences();
        if (oldPreferences != null) {
            newPreferences.setShowExtraInfo(oldPreferences.getShowExtraInfo());
        }
        MSGlycanAnnotationTableDataProcessorUtil.postProcessColumnSettings((TableViewerPreference)newPreferences);
        return newPreferences;
    }

    public static void setDefaultColumnViewSettings(FillTypes fillType, TableViewerColumnSettings tvs) {
        MSAnnotationTableDataProcessor.setDefaultColumnViewSettings((FillTypes)fillType, (TableViewerColumnSettings)tvs);
        if (fillType == FillTypes.PeaksWithFeatures) {
            GRITSColumnHeader header = tvs.getColumnHeader(DMGlycanAnnotation.glycan_annotation_sequence.name());
            if (header != null) {
                tvs.setVisColInx(header, Integer.valueOf(-1));
            }
            if ((header = tvs.getColumnHeader(DMGlycanAnnotation.glycan_annotation_sequenceGWB.name())) != null) {
                tvs.setVisColInx(header, Integer.valueOf(-1));
            }
            if ((header = tvs.getColumnHeader(DMGlycanAnnotation.glycan_annotation_glycancartoon.name())) != null) {
                MSGlycanAnnotationTableDataProcessor.setDefaultColumnPosition((TableViewerColumnSettings)tvs, (GRITSColumnHeader)header, (int)0);
            }
        }
    }

    private MSGlycanAnnotationTableDataObject getMySimianTableDataObject() {
        return (MSGlycanAnnotationTableDataObject)this.getSimianTableDataObject();
    }

    protected void addHeaderLine(int iPrefColNum, GRITSColumnHeader colHeader, ArrayList<GRITSColumnHeader> alHeader) {
        if (colHeader.getKeyValue().equals(DMGlycanAnnotation.glycan_annotation_glycancartoon.name())) {
            this.getMySimianTableDataObject().addCartoonCol(Integer.valueOf(iPrefColNum));
        } else if (colHeader.getKeyValue().equals(DMGlycanAnnotation.glycan_annotation_fragmentcartoon.name())) {
            this.getMySimianTableDataObject().addCartoonCol(Integer.valueOf(iPrefColNum));
        } else if (colHeader.getKeyValue().equals(DMScan.scan_scanNo.name()) || colHeader.getKeyValue().equals(DMScan.scan_pseudoScanNo.name())) {
            this.getMySimianTableDataObject().addScanNoCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMScan.scan_parentScan.name())) {
            this.getMySimianTableDataObject().addParentNoCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMFeature.feature_id.name())) {
            this.getMySimianTableDataObject().addFeatureIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMFeature.feature_charge.name())) {
            this.getMySimianTableDataObject().addFeatureChargeCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMFeature.feature_sequence.name())) {
            this.getMySimianTableDataObject().addSequenceCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMAnnotation.annotation_id.name())) {
            this.getMySimianTableDataObject().addAnnotationIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMGlycanAnnotation.glycan_annotation_glycanId.name())) {
            this.getMySimianTableDataObject().addAnnotationStringIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_id.name())) {
            this.getMySimianTableDataObject().addPeakIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_mz.name())) {
            this.getMySimianTableDataObject().addMzCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_intensity.name())) {
            this.getSimianTableDataObject().addPeakIntensityCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_is_precursor.name())) {
            this.getSimianTableDataObject().addPeakIsPrecursorCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPrecursorPeak.precursor_peak_intensity.name())) {
            this.getSimianTableDataObject().addPrecursorIntensityCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(TableDataProcessor.filterColHeader.getKeyValue())) {
            this.getMySimianTableDataObject().addFilterCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(TableDataProcessor.commentColHeader.getKeyValue())) {
            this.getMySimianTableDataObject().addCommentCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMAnnotation.annotation_ratio.name())) {
            this.getMySimianTableDataObject().addRatioCol(iPrefColNum);
        }
        MassSpecTableDataProcessorUtil.setHeaderValue((int)iPrefColNum, (GRITSColumnHeader)colHeader, alHeader);
    }

    public void buildTable() throws Exception {
        super.buildTable();
    }

    protected boolean processExternalQuant() {
        return super.processExternalQuant();
    }

    protected boolean addSubScanPeaksData(Scan _scan, Peak _peak, TableViewerColumnSettings _settings, GRITSListDataRow alRow) {
        boolean bAddQuant = super.addSubScanPeaksData(_scan, _peak, _settings, alRow);
        try {
            MSAnnotationEntityProperty eProp = this.getMSAnnotationEntityProperty();
            MSGlycanAnnotationProperty prop = (MSGlycanAnnotationProperty)eProp.getMSAnnotationParentProperty();
            MSGlycanAnnotationMetaData mData = (MSGlycanAnnotationMetaData)prop.getMSAnnotationMetaData();
            if (mData != null && mData.getCustomAnnotations() != null && _scan != null) {
                for (MassSpecCustomAnnotation annotation : mData.getCustomAnnotations()) {
                    int i = 0;
                    while (i < _scan.getPeaklist().size()) {
                        Peak subpeak = (Peak)_scan.getPeaklist().get(i);
                        bAddQuant |= MassSpecTableDataProcessorUtil.fillMassSpecScanDataCustomAnnotation((Peak)_peak, (Peak)subpeak, (ArrayList)alRow.getDataRow(), (TableViewerColumnSettings)_settings, (HashMap)annotation.getAnnotatedPeaks());
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"addSubScanPeaksData: error adding peaks data to table model.", (Throwable)e);
        }
        return bAddQuant;
    }

    protected void addAnnotationColumns(TableViewerColumnSettings _settings) {
        super.addAnnotationColumns(_settings);
        MSGlycanAnnotationTableDataProcessorUtil.fillMSGlycanAnnotationColumnSettingsCartoon(_settings, this.getMassSpecEntityProperty().getMsLevel() > 2);
        MSGlycanAnnotationTableDataProcessorUtil.fillMSGlycanAnnotationColumnSettingsGlycanAnnotation(_settings);
    }

    protected void fillAnnotationData(Annotation a_annotation, Feature feature, Scan a_scan, int _iNumCandidates, TableViewerColumnSettings _settings, GRITSListDataRow alRow) {
        super.fillAnnotationData(a_annotation, feature, a_scan, _iNumCandidates, _settings, alRow);
        MSGlycanAnnotationTableDataProcessorUtil.fillMSGlycanAnnotationData((GlycanAnnotation)a_annotation, (GlycanFeature)feature, a_scan, _iNumCandidates, alRow.getDataRow(), _settings);
        if (feature != null) {
            MSGlycanAnnotationTableDataProcessorUtil.fillMSGlycanAnnotationCartoonColumns(feature.getId(), alRow.getDataRow(), _settings, this.getMassSpecEntityProperty().getMsLevel() > 2);
        }
    }

    protected CustomAnnotationDataProcessor getNewCustomAnnotationProcessor(ExternalQuantSettings quantSettings) {
        MSGlycanAnnotationCustomAnnotationProcessor spdf = new MSGlycanAnnotationCustomAnnotationProcessor(quantSettings);
        return spdf;
    }

    protected void initializeQuantFiles() {
        super.initializeQuantFiles();
    }

    protected TableViewerColumnSettings initializeColumnSettings() {
        try {
            TableViewerColumnSettings newSettings = super.initializeColumnSettings();
            return newSettings;
        }
        catch (Exception e) {
            logger.error((Object)"initializeColumnSettings: unable to initialize all columns.", (Throwable)e);
            return null;
        }
    }

    public AnnotationFilter getFilter() {
        return this.filter;
    }

    public void setFilter(AnnotationFilter filter) {
        this.filter = filter;
    }

    protected void updateScanFeaturesWithFilter(ScanFeatures features) {
        if (features != null && this.filter != null) {
            features.setFilter(this.filter);
        }
    }
}

