/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.reporting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.eurocarbdb.application.glycanbuilder.ActionManager;
import org.eurocarbdb.application.glycanbuilder.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MouseUtils;
import org.eurocarbdb.application.glycanbuilder.SVGUtils;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.ProfilesComparisonReportChartCanvas;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.ProfilesComparisonReportDocument;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.ProfilesComparisonReportOptions;

public class ProfilesComparisonReportChartFrame
extends JFrame
implements ActionListener,
MouseListener {
    private GlycoWorkbench theApplication;
    private ActionManager theActionManager;
    private JMenuBar theMenuBar;
    private JToolBar theToolBar;
    private ProfilesComparisonReportChartCanvas theCanvas;
    private JScrollPane theScrollPane;

    public ProfilesComparisonReportChartFrame(GlycoWorkbench application, ProfilesComparisonReportDocument doc, ProfilesComparisonReportOptions opt) {
        this.theApplication = application;
        this.theActionManager = new ActionManager();
        this.theCanvas = new ProfilesComparisonReportChartCanvas(application, doc, opt);
        this.createActions();
        this.getContentPane().setLayout(new BorderLayout());
        this.theMenuBar = this.createMenuBar();
        this.setJMenuBar(this.theMenuBar);
        UIManager.getDefaults().put("ToolTip.hideAccelerator", Boolean.TRUE);
        this.theToolBar = this.createToolBar();
        this.getContentPane().add((Component)this.theToolBar, "North");
        this.theScrollPane = new JScrollPane(this.theCanvas);
        this.theCanvas.setScrollPane(this.theScrollPane);
        this.getContentPane().add((Component)this.theScrollPane, "Center");
        this.theCanvas.addMouseListener(this);
        this.setSize(900, 700);
        this.setLocationRelativeTo((Component)((Object)this.theApplication));
        this.updateActions();
    }

    private void createActions() {
        for (Map.Entry e : SVGUtils.getExportFormats().entrySet()) {
            this.theActionManager.add("export=" + (String)e.getKey(), FileUtils.defaultThemeManager.getImageIcon(""), "Export to " + (String)e.getValue() + "...", -1, "", (ActionListener)this);
        }
        this.theActionManager.add("print", FileUtils.defaultThemeManager.getImageIcon("print"), "Print...", 80, "ctrl P", (ActionListener)this);
        this.theActionManager.add("close", FileUtils.defaultThemeManager.getImageIcon("close"), "Close", 67, "ctrl Q", (ActionListener)this);
        this.theActionManager.add("screenshot", FileUtils.defaultThemeManager.getImageIcon("screenshot"), "Screenshot", 154, "PRINTSCREEN", (ActionListener)this);
        this.theActionManager.add("zoomnone", FileUtils.defaultThemeManager.getImageIcon("zoomnone"), "Reset zoom", -1, "", (ActionListener)this);
        this.theActionManager.add("zoomin", FileUtils.defaultThemeManager.getImageIcon("zoomin"), "Zoom in", -1, "", (ActionListener)this);
        this.theActionManager.add("zoomout", FileUtils.defaultThemeManager.getImageIcon("zoomout"), "Zoom out", -1, "", (ActionListener)this);
    }

    private void updateActions() {
    }

    private JMenu createExportDrawingMenu() {
        JMenu export_menu = new JMenu("Export to graphical formats");
        export_menu.setIcon(FileUtils.defaultThemeManager.getImageIcon("export"));
        for (Map.Entry e : SVGUtils.getExportFormats().entrySet()) {
            export_menu.add((Action)this.theActionManager.get("export=" + (String)e.getKey()));
        }
        return export_menu;
    }

    private JMenu createFileMenu() {
        JMenu file_menu = new JMenu("File");
        file_menu.add(this.createExportDrawingMenu());
        file_menu.addSeparator();
        file_menu.add((Action)this.theActionManager.get("print"));
        file_menu.addSeparator();
        file_menu.add((Action)this.theActionManager.get("close"));
        return file_menu;
    }

    private JMenu createEditMenu() {
        JMenu edit_menu = new JMenu("Edit");
        edit_menu.setMnemonic(69);
        edit_menu.add((Action)this.theActionManager.get("screenshot"));
        return edit_menu;
    }

    private JMenu createViewMenu() {
        JMenu view_menu = new JMenu("View");
        view_menu.setMnemonic(86);
        view_menu.add((Action)this.theActionManager.get("zoomnone"));
        view_menu.add((Action)this.theActionManager.get("zoomin"));
        view_menu.add((Action)this.theActionManager.get("zoomout"));
        return view_menu;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.createFileMenu());
        menubar.add(this.createEditMenu());
        menubar.add(this.createViewMenu());
        return menubar;
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.theActionManager.get("zoomnone"));
        menu.add((Action)this.theActionManager.get("zoomin"));
        menu.add((Action)this.theActionManager.get("zoomout"));
        return menu;
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("print"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("screenshot"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("zoomnone"));
        toolbar.add((Action)this.theActionManager.get("zoomin"));
        toolbar.add((Action)this.theActionManager.get("zoomout"));
        return toolbar;
    }

    public void onZoomNone() {
        this.theCanvas.setScale(1.0);
    }

    public void onZoomIn() {
        this.theCanvas.setScale(this.theCanvas.getScale() * 1.5);
    }

    public void onZoomOut() {
        this.theCanvas.setScale(this.theCanvas.getScale() * 0.667);
    }

    public void onPrint() {
        try {
            PrinterJob pj = this.theApplication.getWorkspace().getPrinterJob();
            if (pj != null) {
                pj.setPrintable(this.theCanvas);
                if (pj.printDialog()) {
                    this.theCanvas.print(pj);
                }
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void onExportTo(String format) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(format));
        int returnVal = fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            int retValue;
            String filename = fileChooser.getSelectedFile().getAbsolutePath();
            File file = new File(filename = FileUtils.enforceExtension((String)filename, (String)format));
            if (file.exists() && (retValue = JOptionPane.showOptionDialog(this, "File exists. Overwrite file: " + filename + "?", "Salva documento", 1, 3, null, null, null)) != 0) {
                return;
            }
            try {
                SVGUtils.export((String)filename, (SVGUtils.Renderable)this.theCanvas, (String)format);
            }
            catch (Exception e) {
                LogUtils.report((Exception)e);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = GlycanAction.getAction((ActionEvent)e);
        String param = GlycanAction.getParam((ActionEvent)e);
        if (action.equals("export")) {
            this.onExportTo(param);
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("close")) {
            this.setVisible(false);
        } else if (action.equals("screenshot")) {
            this.theCanvas.getScreenshot();
        } else if (action.equals("zoomnone")) {
            this.onZoomNone();
        } else if (action.equals("zoomin")) {
            this.onZoomIn();
        } else if (action.equals("zoomout")) {
            this.onZoomOut();
        }
        this.updateActions();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (MouseUtils.isPopupTrigger((MouseEvent)e)) {
            this.createPopupMenu().show(this.theCanvas, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (MouseUtils.isPopupTrigger((MouseEvent)e)) {
            this.createPopupMenu().show(this.theCanvas, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

