/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptions;
import org.eurocarbdb.application.glycoworkbench.IonCloudUtils;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotation;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationCollection;
import org.eurocarbdb.application.glycoworkbench.PeakList;
import org.eurocarbdb.application.glycoworkbench.plugin.ProfilerOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureGenerator;

public class ProfilerThread
extends Thread {
    private int progress = 0;
    private int matches = 0;
    private AnnotatedPeakList annotated_peaks = new AnnotatedPeakList();
    private PeakList peaks = null;
    private Glycan motif = null;
    private StructureGenerator generator = null;
    private AnnotationOptions ann_opt = null;
    private ProfilerOptions prof_opt = null;
    private boolean add_unmatched_peaks = true;

    public ProfilerThread(PeakList _peaks, Glycan _motif, StructureGenerator _generator, ProfilerOptions _prof_opt, AnnotationOptions _ann_opt) {
        this.peaks = _peaks;
        this.motif = _motif;
        this.generator = _generator;
        this.prof_opt = _prof_opt;
        this.ann_opt = _ann_opt;
    }

    public void setAddUnmatchedPeaks(boolean f) {
        this.add_unmatched_peaks = f;
    }

    public boolean getAddUnmatchedPeaks() {
        return this.add_unmatched_peaks;
    }

    public AnnotatedPeakList getAnnotatedPeaks() {
        return this.annotated_peaks;
    }

    public void setAnnotatedPeaks(AnnotatedPeakList apl) {
        this.annotated_peaks = apl;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMatches() {
        return this.matches;
    }

    @Override
    public void run() {
        this.progress = 0;
        this.matches = 0;
        if (this.peaks == null || this.ann_opt == null || this.generator == null || this.motif == null) {
            this.interrupt();
            return;
        }
        try {
            this.match();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            this.interrupt();
        }
    }

    public void match() throws Exception {
        Vector<IonCloud> ion_clouds = IonCloudUtils.getPossibleIonClouds(this.ann_opt);
        this.generator.start(this.prof_opt.getMassOptions());
        boolean backtrack = false;
        FragmentEntry fe = null;
        this.annotated_peaks.clear();
        while ((fe = this.generator.next(backtrack)) != null) {
            boolean matched = false;
            boolean in_range = false;
            if (this.ann_opt.COMPUTE_EXCHANGES) {
                Vector<IonCloud> neutral_exchanges = IonCloudUtils.getPossibleNeutralExchanges(fe.fragment.countCharges(), this.ann_opt);
                for (IonCloud nex : neutral_exchanges) {
                    for (IonCloud cloud : ion_clouds) {
                        if (cloud.and(nex).isRealistic()) {
                            for (Peak p : this.peaks.getPeaks()) {
                                double fmz = cloud.computeMZ(nex.getIonsMass() + fe.mass);
                                if (ProfilerThread.match(fmz, p.getMZ(), this.ann_opt)) {
                                    fe.setScore(this.generator.computeScore(fe.fragment));
                                    this.annotated_peaks.addPeakAnnotation(this.motif, new PeakAnnotation(p, fe.and(cloud, nex)), true);
                                    matched = true;
                                    continue;
                                }
                                if (!(fmz < p.getMZ())) continue;
                                in_range = true;
                            }
                        }
                        if (!ProfilerThread.interrupted()) continue;
                        return;
                    }
                }
            } else {
                for (IonCloud cloud : ion_clouds) {
                    for (Peak p : this.peaks.getPeaks()) {
                        double fmz = cloud.computeMZ(fe.mass.doubleValue());
                        if (ProfilerThread.match(fmz, p.getMZ(), this.ann_opt)) {
                            fe.setScore(this.generator.computeScore(fe.fragment));
                            this.annotated_peaks.addPeakAnnotation(this.motif, new PeakAnnotation(p, fe.and(cloud)), true);
                            matched = true;
                            continue;
                        }
                        if (!(fmz < p.getMZ())) continue;
                        in_range = true;
                    }
                    if (!ProfilerThread.interrupted()) continue;
                    return;
                }
            }
            boolean bl = backtrack = !in_range;
            if (matched) {
                ++this.matches;
            }
            ++this.progress;
        }
        if (this.add_unmatched_peaks) {
            PeakAnnotationCollection pac = this.annotated_peaks.getPeakAnnotationCollection(this.motif);
            for (Peak p : this.peaks.getPeaks()) {
                if (pac != null && pac.isAnnotated(p)) continue;
                this.annotated_peaks.addPeakAnnotation(this.motif, new PeakAnnotation(p), true);
            }
        }
    }

    public static boolean match(double fmz, double mz_ratio, AnnotationOptions ann_opt) {
        if (ann_opt.MASS_ACCURACY_UNIT.equals("ppm")) {
            return Math.abs(1.0 - fmz / mz_ratio) < 1.0E-6 * ann_opt.MASS_ACCURACY;
        }
        return Math.abs(mz_ratio - fmz) < ann_opt.MASS_ACCURACY;
    }
}

