/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.Annotation;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PeakAnnotation
implements Comparable<PeakAnnotation>,
SAXUtils.SAXWriter {
    protected Peak peak;
    protected Annotation annotation;

    public PeakAnnotation() {
        this.peak = new Peak();
        this.annotation = new Annotation();
    }

    public PeakAnnotation(double _mz, double _int) {
        this.peak = new Peak(_mz, _int);
        this.annotation = new Annotation();
    }

    public PeakAnnotation(Peak p) {
        this.peak = p != null ? p.clone() : new Peak();
        this.annotation = new Annotation();
    }

    public PeakAnnotation(Peak p, FragmentEntry f) {
        this.peak = p != null ? p.clone() : new Peak();
        this.annotation = new Annotation(f);
    }

    public PeakAnnotation(Peak p, FragmentEntry f, IonCloud c) {
        this.peak = p != null ? p.clone() : new Peak();
        this.annotation = new Annotation(f, c);
    }

    public PeakAnnotation(Peak p, FragmentEntry f, IonCloud c, IonCloud ex) {
        this.peak = p != null ? p.clone() : new Peak();
        this.annotation = new Annotation(f, c, ex);
    }

    public PeakAnnotation(Peak p, Annotation a) {
        this.peak = p != null ? p.clone() : new Peak();
        this.annotation = a != null ? a.clone() : new Annotation();
    }

    public PeakAnnotation clone() {
        return new PeakAnnotation(this.peak, this.annotation);
    }

    @Override
    public int compareTo(PeakAnnotation pa) {
        double ma2;
        if (pa == null) {
            return 1;
        }
        int cp = this.peak.compareTo(pa.peak);
        if (cp != 0) {
            return cp;
        }
        double ma1 = Math.round(this.getAccuracy() * 10000.0);
        if (ma1 < (ma2 = (double)Math.round(pa.getAccuracy() * 10000.0))) {
            return -1;
        }
        if (ma1 > ma2) {
            return 1;
        }
        return this.annotation.compareTo(pa.annotation);
    }

    public boolean equals(Object other) {
        if (!(other instanceof PeakAnnotation)) {
            return false;
        }
        PeakAnnotation pa = (PeakAnnotation)other;
        return this.peak.equals(pa.peak) && this.annotation.equals(pa.annotation);
    }

    public int hashCode() {
        return this.peak.hashCode() + this.annotation.hashCode();
    }

    public Peak getPeak() {
        return this.peak;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Double getMZ() {
        return this.peak.getMZ();
    }

    public Double getIntensity() {
        return this.peak.getIntensity();
    }

    public FragmentEntry getFragmentEntry() {
        return this.annotation.getFragmentEntry();
    }

    public Glycan getFragment() {
        return this.annotation.getFragmentEntry().fragment;
    }

    public String getFragmentType() {
        return this.annotation.getFragmentEntry().name;
    }

    public boolean isAnnotated() {
        return !this.annotation.isEmpty();
    }

    public double getAccuracy() {
        return this.annotation.getAccuracy(this.peak);
    }

    public double getAccuracyPPM() {
        return this.annotation.getAccuracyPPM(this.peak);
    }

    public double getAnnotationMZ() {
        return this.annotation.getMZ();
    }

    public int getAnnotationZ() {
        return this.annotation.getZ();
    }

    public IonCloud getIons() {
        return this.annotation.getIons();
    }

    public IonCloud getNeutralExchanges() {
        return this.annotation.getNeutralExchanges();
    }

    public String toString() {
        return this.peak + " " + this.annotation;
    }

    public static PeakAnnotation fromXML(Node pa_node) throws Exception {
        PeakAnnotation ret = new PeakAnnotation();
        Node peak_node = XMLUtils.assertChild((Node)pa_node, (String)"Peak");
        ret.peak = Peak.fromXML(peak_node);
        Node ann_node = XMLUtils.assertChild((Node)pa_node, (String)"Annotation");
        ret.annotation = Annotation.fromXML(ann_node);
        return ret;
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element pa_node = document.createElement("PeakAnnotation");
        if (pa_node == null) {
            return null;
        }
        Element peak_node = this.peak.toXML(document);
        if (peak_node == null) {
            return null;
        }
        pa_node.appendChild(peak_node);
        Element ann_node = this.annotation.toXML(document);
        if (ann_node == null) {
            return null;
        }
        pa_node.appendChild(ann_node);
        return pa_node;
    }

    public void write(TransformerHandler th) throws SAXException {
        th.startElement("", "", "PeakAnnotation", new AttributesImpl());
        this.peak.write(th);
        this.annotation.write(th);
        th.endElement("", "", "PeakAnnotation");
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "PeakAnnotation";
        }

        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            if (qName.equals(Peak.SAXHandler.getNodeElementName())) {
                return new Peak.SAXHandler();
            }
            if (qName.equals(Annotation.SAXHandler.getNodeElementName())) {
                return new Annotation.SAXHandler();
            }
            return null;
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            Peak p = (Peak)this.getSubObject(Peak.SAXHandler.getNodeElementName(), true);
            Annotation a = (Annotation)this.getSubObject(Annotation.SAXHandler.getNodeElementName(), true);
            return new PeakAnnotation(p, a);
        }
    }
}

