/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.grits.toolbox.core.datamodel.GeneralSettings;
import org.grits.toolbox.core.datamodel.SettingEntry;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.core.utils.SettingsHandler;
import org.grits.toolbox.core.workspace.WorkspaceHistory;
import org.grits.toolbox.core.workspace.WorkspaceHistoryEntry;
import org.grits.toolbox.core.workspace.WorkspaceHistoryFileHandler;

public class GlobalPreferencesPage
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(GlobalPreferencesPage.class);
    private static final Image CHECKED = ImageShare.CHECKBOX_ICON_YES.createImage();
    private static final Image UNCHECKED = ImageShare.CHECKBOX_ICON_NO.createImage();
    GeneralSettings settings;
    WorkspaceHistory history;
    private TableViewer workspaceTable;

    public GlobalPreferencesPage() {
        try {
            this.settings = SettingsHandler.readSettings();
        }
        catch (Exception exception) {
            logger.warn((Object)"No settings file");
            this.settings = new GeneralSettings();
        }
        try {
            List<WorkspaceHistoryEntry> workspaceList = WorkspaceHistoryFileHandler.readHistoryFile();
            this.history = new WorkspaceHistory();
            this.history.setWorkspaceList(workspaceList);
        }
        catch (Exception e) {
            logger.error((Object)"workspace history file cannot be read", (Throwable)e);
            this.history = new WorkspaceHistory();
        }
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.horizontalSpacing = 20;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        Label description = new Label(container, 64);
        description.setText("This page contains preferences that are applicable to all instances of GRITS\nand to all workspaces of the current user");
        description.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Label settingsTitle = new Label(container, 0);
        settingsTitle.setText("Do not show again");
        settingsTitle.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        if (this.settings != null && this.settings.getHiddenDialogs() != null) {
            for (final SettingEntry se : this.settings.getHiddenDialogs()) {
                Label prefLabel = new Label(container, 0);
                prefLabel.setText(se.getName());
                prefLabel.setToolTipText(se.getDescription());
                final Button valueControl = new Button(container, 32);
                valueControl.setSelection(true);
                valueControl.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (valueControl.getSelection()) {
                            GlobalPreferencesPage.this.settings.addHiddenDialog(se);
                        } else {
                            GlobalPreferencesPage.this.settings.removeHiddenDialog(se);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                new Label(container, 0);
            }
        }
        new Label(container, 0);
        separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        if (this.history != null) {
            this.addWorkspaceHistoryTable(container);
        }
        return container;
    }

    private void addWorkspaceHistoryTable(Composite parent) {
        Label workspaceSelection = new Label(parent, 0);
        workspaceSelection.setText("Used Workspaces");
        workspaceSelection.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.workspaceTable = new TableViewer(parent, 67586);
        this.workspaceTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 3, 4));
        this.workspaceTable.getTable().setLinesVisible(true);
        this.workspaceTable.getTable().setHeaderVisible(true);
        TableViewerColumn column1 = new TableViewerColumn(this.workspaceTable, 16384);
        column1.getColumn().setText("Path");
        column1.getColumn().setWidth(300);
        column1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof WorkspaceHistoryEntry) {
                    return ((WorkspaceHistoryEntry)element).getPath();
                }
                return null;
            }
        });
        TableViewerColumn column2 = new TableViewerColumn(this.workspaceTable, 0x1000000);
        column2.getColumn().setText("Last Active");
        column2.getColumn().setWidth(80);
        column2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof WorkspaceHistoryEntry) {
                    String lastActive = ((WorkspaceHistoryEntry)element).getLastActive();
                    if (lastActive != null && lastActive.equals("true")) {
                        return CHECKED;
                    }
                    return UNCHECKED;
                }
                return null;
            }
        });
        this.workspaceTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.workspaceTable.setInput(this.history.getWorkspaceList());
        new Label(parent, 0);
        new Label(parent, 0);
        Button deleteButton = new Button(parent, 8);
        deleteButton.setText("Remove");
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = GlobalPreferencesPage.this.workspaceTable.getTable().getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem selected = tableItemArray[n2];
                    WorkspaceHistoryEntry entry = (WorkspaceHistoryEntry)selected.getData();
                    GlobalPreferencesPage.this.history.getWorkspaceList().remove(entry);
                    ++n2;
                }
                GlobalPreferencesPage.this.workspaceTable.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public boolean performOk() {
        return this.save();
    }

    private boolean save() {
        try {
            if (this.settings != null) {
                SettingsHandler.writeSettings(this.settings);
            }
            if (this.history != null && this.history.getWorkspaceList() != null) {
                WorkspaceHistoryFileHandler.writeHistoryFile(this.history);
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Could not update global settings", (Throwable)e);
            return false;
        }
    }

    protected void performApply() {
        this.save();
    }
}

