/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.databasebot.wizards.createnew;

import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.utils.DatabaseUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.utils.GlycanStructureDatabase;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.utils.GlycanStructureDatabaseIndex;
import org.grits.toolbox.tools.databasebot.om.DatabaseBotSettings;
import org.grits.toolbox.tools.databasebot.utils.DatabaseBotException;
import org.grits.toolbox.tools.databasebot.utils.DatabaseUtil;

public class DatabaseTypePage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(DatabaseTypePage.class);
    private Button m_radioNewDatabase = null;
    private Button m_radioExtendDatabase = null;
    private Button m_radioFileDatabase = null;
    private Button m_buttonBrowseDatabaseFile = null;
    private Button m_buttonBrowseReportFile = null;
    private Button m_checkCreateReport = null;
    private Button m_checkCreateTopology = null;
    private Combo m_comboDatabases = null;
    private Combo m_comboScalingFactor = null;
    private Text m_textDatabaseFile = null;
    private Text m_textReportFile = null;
    private GlycanStructureDatabaseIndex m_databases = null;

    public DatabaseTypePage(ImageDescriptor a_titleImage) {
        super("Type of database", "Type of database", a_titleImage);
        this.setDescription("Create a new database or extend an existing database.");
    }

    public void createControl(Composite a_parent) {
        Composite t_container = new Composite(a_parent, 0);
        t_container.setLayout((Layout)new GridLayout(1, false));
        this.createControlSourceOfDatabase(t_container);
        new Label(t_container, 0);
        this.m_checkCreateTopology = new Button(t_container, 32);
        this.m_checkCreateTopology.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.m_checkCreateTopology.setText("Create topology database");
        new Label(t_container, 0);
        this.createControlReport(t_container);
        this.m_radioNewDatabase.setSelection(true);
        this.m_comboDatabases.setEnabled(false);
        this.m_textDatabaseFile.setEnabled(false);
        this.m_buttonBrowseDatabaseFile.setEnabled(false);
        this.m_textReportFile.setEnabled(false);
        this.m_buttonBrowseReportFile.setEnabled(false);
        this.m_comboScalingFactor.setEnabled(false);
        this.setControl((Control)t_container);
        this.setPageComplete(true);
    }

    private void createControlReport(final Composite a_container) {
        Group t_groupReport = new Group(a_container, 0);
        GridData t_gridReport = new GridData(4, 128, true, false, 1, 1);
        t_groupReport.setLayoutData((Object)t_gridReport);
        t_groupReport.setText("Excel report");
        t_groupReport.setLayout((Layout)new GridLayout(4, false));
        this.m_checkCreateReport = new Button((Composite)t_groupReport, 32);
        this.m_checkCreateReport.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.m_checkCreateReport.setText("Create report");
        Label t_placeholder = new Label((Composite)t_groupReport, 0);
        GridData t_gridDataLabel = new GridData(4, 0x1000000, false, false, 1, 1);
        t_gridDataLabel.widthHint = 15;
        t_placeholder.setLayoutData((Object)t_gridDataLabel);
        this.m_textReportFile = new Text((Composite)t_groupReport, 2048);
        this.m_textReportFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_textReportFile.setEditable(false);
        this.m_buttonBrowseReportFile = new Button((Composite)t_groupReport, 0);
        GridData t_gridDataButton = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        t_gridDataButton.widthHint = 100;
        this.m_buttonBrowseReportFile.setLayoutData((Object)t_gridDataButton);
        this.m_buttonBrowseReportFile.setText("Save As");
        t_placeholder = new Label((Composite)t_groupReport, 0);
        t_gridDataLabel = new GridData(4, 0x1000000, false, false, 1, 1);
        t_gridDataLabel.widthHint = 15;
        t_placeholder.setLayoutData((Object)t_gridDataLabel);
        Label t_dropdownText = new Label((Composite)t_groupReport, 0);
        GridData t_gridDataDropLabel = new GridData(4, 0x1000000, false, false, 1, 1);
        t_dropdownText.setLayoutData((Object)t_gridDataDropLabel);
        t_dropdownText.setText("Image Scaling Factor");
        this.m_comboScalingFactor = new Combo((Composite)t_groupReport, 12);
        this.m_comboScalingFactor.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.m_comboScalingFactor.add("50%");
        this.m_comboScalingFactor.add("75%");
        this.m_comboScalingFactor.add("100%");
        this.m_comboScalingFactor.select(0);
        this.m_checkCreateReport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent a_event) {
                Button t_button = (Button)a_event.widget;
                if (t_button.getSelection()) {
                    DatabaseTypePage.this.m_textReportFile.setEnabled(true);
                    DatabaseTypePage.this.m_buttonBrowseReportFile.setEnabled(true);
                    DatabaseTypePage.this.m_comboScalingFactor.setEnabled(true);
                } else {
                    DatabaseTypePage.this.m_textReportFile.setEnabled(false);
                    DatabaseTypePage.this.m_buttonBrowseReportFile.setEnabled(false);
                    DatabaseTypePage.this.m_comboScalingFactor.setEnabled(false);
                }
                DatabaseTypePage.this.validate();
            }
        });
        this.m_buttonBrowseReportFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent a_event) {
                try {
                    FileDialog t_dialogSave = new FileDialog(a_container.getShell(), 8192);
                    t_dialogSave.setFilterNames(new String[]{"Excel Report (*.xls)"});
                    t_dialogSave.setFilterExtensions(new String[]{"*.xls"});
                    t_dialogSave.setFileName("DatabaseReport.xls");
                    String t_file = t_dialogSave.open();
                    if (t_file != null) {
                        File t_fileHandle = new File(t_file);
                        if (t_fileHandle.exists()) {
                            int t_response = ErrorUtils.createSingleConfirmationMessageBoxReturn((Shell)a_container.getShell(), (String)"Report exists", (String)"The selected report file already exists. Do you want to overwrite it?");
                            if (t_response == 64) {
                                DatabaseTypePage.this.m_textReportFile.setText(t_file);
                            }
                        } else {
                            DatabaseTypePage.this.m_textReportFile.setText(t_file);
                        }
                    }
                    DatabaseTypePage.this.validate();
                }
                catch (Exception e) {
                    logger.fatal((Object)"Unable to select an excel file for a exclude report.", (Throwable)e);
                }
            }
        });
    }

    private void createControlSourceOfDatabase(final Composite a_container) {
        Group t_groupSourceOfDatabase = new Group(a_container, 0);
        GridData t_gridTypeOfDatabase = new GridData(4, 128, true, false, 1, 1);
        t_groupSourceOfDatabase.setLayoutData((Object)t_gridTypeOfDatabase);
        t_groupSourceOfDatabase.setText("Type of database");
        t_groupSourceOfDatabase.setLayout((Layout)new GridLayout(3, false));
        this.m_radioNewDatabase = new Button((Composite)t_groupSourceOfDatabase, 16);
        this.m_radioNewDatabase.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.m_radioNewDatabase.setText("Create new database");
        this.m_radioExtendDatabase = new Button((Composite)t_groupSourceOfDatabase, 16);
        this.m_radioExtendDatabase.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.m_radioExtendDatabase.setText("Extend GELATO database");
        Label t_placeholder = new Label((Composite)t_groupSourceOfDatabase, 0);
        GridData t_gridDataLabel = new GridData(4, 0x1000000, false, false, 1, 1);
        t_gridDataLabel.widthHint = 15;
        t_placeholder.setLayoutData((Object)t_gridDataLabel);
        this.m_comboDatabases = new Combo((Composite)t_groupSourceOfDatabase, 12);
        this.m_comboDatabases.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        try {
            this.m_databases = DatabaseUtils.getGelatoDatabases();
            if (this.m_databases.getDatabase().size() > 0) {
                for (GlycanStructureDatabase t_database : this.m_databases.getDatabase()) {
                    this.m_comboDatabases.add(t_database.getName());
                }
                this.m_comboDatabases.select(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to load GELATO databases", (Throwable)e);
        }
        this.m_radioFileDatabase = new Button((Composite)t_groupSourceOfDatabase, 16);
        this.m_radioFileDatabase.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.m_radioFileDatabase.setText("Extend file database");
        new Label((Composite)t_groupSourceOfDatabase, 0);
        this.m_textDatabaseFile = new Text((Composite)t_groupSourceOfDatabase, 2048);
        this.m_textDatabaseFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.m_textDatabaseFile.setEditable(false);
        this.m_buttonBrowseDatabaseFile = new Button((Composite)t_groupSourceOfDatabase, 0);
        GridData t_gridDataButton = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        t_gridDataButton.widthHint = 100;
        this.m_buttonBrowseDatabaseFile.setLayoutData((Object)t_gridDataButton);
        this.m_buttonBrowseDatabaseFile.setText("Browse");
        this.m_radioNewDatabase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseTypePage.this.m_comboDatabases.setEnabled(false);
                DatabaseTypePage.this.m_textDatabaseFile.setEnabled(false);
                DatabaseTypePage.this.m_buttonBrowseDatabaseFile.setEnabled(false);
                DatabaseTypePage.this.validate();
            }
        });
        this.m_radioExtendDatabase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseTypePage.this.m_comboDatabases.setEnabled(true);
                DatabaseTypePage.this.m_textDatabaseFile.setEnabled(false);
                DatabaseTypePage.this.m_buttonBrowseDatabaseFile.setEnabled(false);
                DatabaseTypePage.this.validate();
            }
        });
        this.m_radioFileDatabase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseTypePage.this.m_comboDatabases.setEnabled(false);
                DatabaseTypePage.this.m_textDatabaseFile.setEnabled(true);
                DatabaseTypePage.this.m_buttonBrowseDatabaseFile.setEnabled(true);
                DatabaseTypePage.this.validate();
            }
        });
        this.m_buttonBrowseDatabaseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent a_event) {
                try {
                    FileDialog t_dialogSave = new FileDialog(a_container.getShell());
                    t_dialogSave.setFilterNames(new String[]{"Glycan structure database (.xml)", "All files"});
                    t_dialogSave.setFilterExtensions(new String[]{"*.xml", "*.*"});
                    String t_file = t_dialogSave.open();
                    if (t_file != null) {
                        if (DatabaseUtil.isValidDatabaseFile(t_file)) {
                            DatabaseTypePage.this.m_textDatabaseFile.setText(t_file);
                        } else {
                            ErrorUtils.createErrorMessageBox((Shell)a_container.getShell(), (String)"Error in the database file", (String)"The selected databases file is not in a valid format.\nPlease select a valid file.");
                        }
                    }
                    DatabaseTypePage.this.validate();
                }
                catch (Exception e) {
                    logger.fatal((Object)"Unable to select a database file.", (Throwable)e);
                }
            }
        });
    }

    private void validate() {
        if (this.isValidInput()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private boolean isValidInput() {
        String t_fileName;
        String t_databaseName;
        GlycanStructureDatabase t_db;
        if (this.m_radioExtendDatabase.getSelection() && (t_db = this.findDatabaseForName(t_databaseName = this.m_comboDatabases.getText())) == null) {
            this.setErrorMessage("Please select a valid GELATO database.");
            return false;
        }
        if (this.m_radioFileDatabase.getSelection()) {
            t_fileName = this.m_textDatabaseFile.getText();
            if (t_fileName != null) {
                File t_file = new File(t_fileName);
                if (!t_file.exists() || !t_file.isFile()) {
                    this.setErrorMessage("Please select a valid database file.");
                    return false;
                }
            } else {
                this.setErrorMessage("Please select a database file.");
                return false;
            }
        }
        if (this.m_checkCreateReport.getSelection()) {
            t_fileName = this.m_textReportFile.getText();
            if (t_fileName != null) {
                if (t_fileName.length() == 0) {
                    this.setErrorMessage("Please select a report file.");
                    return false;
                }
            } else {
                this.setErrorMessage("Please select a report file.");
                return false;
            }
        }
        return true;
    }

    public void fillCreateDatabaseSettings(DatabaseBotSettings a_settings) throws DatabaseBotException {
        if (this.m_radioExtendDatabase.getSelection()) {
            String t_databaseFile;
            String t_databaseName = this.m_comboDatabases.getText();
            GlycanStructureDatabase t_db = this.findDatabaseForName(t_databaseName);
            try {
                if (t_db == null) {
                    logger.error((Object)("Could not find database (" + t_databaseName + ") building settings object"));
                    throw new DatabaseBotException("Unable to load database that should be extended.");
                }
                t_databaseFile = String.valueOf(DatabaseUtils.getDatabasePath()) + File.separator + t_db.getFileName();
            }
            catch (Exception e) {
                logger.error((Object)"Problems building the path for the database to be extended", (Throwable)e);
                throw new DatabaseBotException("Unable to load database that should be extended.");
            }
            a_settings.setExtendDatabaseFile(t_databaseFile);
        }
        if (this.m_radioFileDatabase.getSelection()) {
            a_settings.setExtendDatabaseFile(this.m_textDatabaseFile.getText());
        }
        if (this.m_checkCreateReport.getSelection()) {
            a_settings.setReportFile(this.m_textReportFile.getText());
            a_settings.setImageScalingFactor(this.getImageScalingFactor());
        }
        if (this.m_checkCreateTopology.getSelection()) {
            a_settings.setTopologyDatabase(true);
        } else {
            a_settings.setTopologyDatabase(false);
        }
    }

    private Double getImageScalingFactor() {
        String t_selection = this.m_comboScalingFactor.getText();
        if (t_selection.equals("100%")) {
            return 1.0;
        }
        if (t_selection.equals("75%")) {
            return 0.75;
        }
        return 0.5;
    }

    private GlycanStructureDatabase findDatabaseForName(String a_name) {
        if (this.m_databases == null) {
            return null;
        }
        for (GlycanStructureDatabase t_database : this.m_databases.getDatabase()) {
            if (!t_database.getName().equals(a_name)) continue;
            return t_database;
        }
        logger.error((Object)("Unable to find GELATO database: " + a_name));
        return null;
    }
}

