/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.linearscale;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.IScaleProvider;
import org.eclipse.nebula.visualization.xygraph.linearscale.ITicksProvider;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaleTickLabels;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaleTickMarks;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class LinearScale
extends AbstractScale
implements IScaleProvider {
    protected static final int SPACE_BTW_MARK_LABEL = 2;
    private Orientation orientation = Orientation.HORIZONTAL;
    private LinearScaleTickLabels tickLabels = this.createLinearScaleTickLabels();
    private LinearScaleTickMarks tickMarks = this.createLinearScaleTickMarks();
    private int length;
    private int margin;
    private Range localRange = null;

    public LinearScale() {
        this.add((IFigure)this.tickMarks);
        this.add((IFigure)this.tickLabels);
    }

    protected LinearScaleTickLabels createLinearScaleTickLabels() {
        return new LinearScaleTickLabels(this);
    }

    protected LinearScaleTickMarks createLinearScaleTickMarks() {
        return new LinearScaleTickMarks(this);
    }

    private void calcMargin() {
        this.margin = this.isHorizontal() ? (int)Math.ceil((double)Math.max(FigureUtilities.getTextExtents((String)this.format((Object)Double.valueOf((double)this.getRange().getLower()), (boolean)true), (Font)this.getFont()).width, FigureUtilities.getTextExtents((String)this.format((Object)Double.valueOf((double)this.getRange().getUpper()), (boolean)true), (Font)this.getFont()).width) / 2.0) : (int)Math.ceil((double)Math.max(FigureUtilities.getTextExtents((String)this.format((Object)Double.valueOf((double)this.getRange().getLower()), (boolean)true), (Font)this.getFont()).height, FigureUtilities.getTextExtents((String)this.format((Object)Double.valueOf((double)this.getRange().getUpper()), (boolean)true), (Font)this.getFont()).height) / 2.0);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getMargin(boolean updateTick) {
        if (updateTick) {
            return this.getMargin();
        }
        return this.margin;
    }

    @Override
    public int getMargin() {
        this.updateTick();
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension size = new Dimension(wHint, hHint);
        LinearScaleTickLabels fakeTickLabels = new LinearScaleTickLabels(this);
        if (this.isHorizontal()) {
            fakeTickLabels.update(wHint - 2 * this.getMargin());
            size.height = fakeTickLabels.getTickLabelMaxHeight() + 2 + 6;
        } else {
            fakeTickLabels.update(hHint - 2 * this.getMargin());
            size.width = fakeTickLabels.getTickLabelMaxLength() + 2 + 6;
        }
        return size;
    }

    @Override
    public ITicksProvider getTicksProvider() {
        return this.tickLabels.getTicksProvider();
    }

    public LinearScaleTickLabels getScaleTickLabels() {
        return this.tickLabels;
    }

    public LinearScaleTickMarks getScaleTickMarks() {
        return this.tickMarks;
    }

    public int getTickLength() {
        return this.length - 2 * this.getMargin();
    }

    public int getValuePosition(double value, boolean relative) {
        return (int)Math.round(this.getValuePrecisePosition(value, relative));
    }

    public double getValuePrecisePosition(double value, boolean relative) {
        if (this.dirty) {
            this.updateTick();
        }
        Range r = this.getLocalRange();
        double min = r.getLower();
        double max = r.getUpper();
        double pixelsToStart = 0.0;
        if (this.isLogScaleEnabled()) {
            if (value <= 0.0) {
                value = min;
            }
            pixelsToStart = (Math.log10(value) - Math.log10(min)) / (Math.log10(max) - Math.log10(min)) * ((double)this.length - 2.0 * (double)this.margin) + (double)this.margin;
        } else {
            pixelsToStart = (value - min) / (max - min) * ((double)this.length - 2.0 * (double)this.margin) + (double)this.margin;
        }
        if (relative) {
            if (this.orientation == Orientation.HORIZONTAL) {
                return pixelsToStart;
            }
            return (double)this.length - pixelsToStart;
        }
        if (this.orientation == Orientation.HORIZONTAL) {
            return pixelsToStart + (double)this.bounds.x;
        }
        return (double)this.length - pixelsToStart + (double)this.bounds.y;
    }

    public double getPositionValue(int position, boolean relative) {
        return this.getPositionValue((double)position, relative);
    }

    public double getPositionValue(double position, boolean relative) {
        this.updateTick();
        double pixelsToStart = relative ? (this.isHorizontal() ? position : (double)this.length - position) : (this.isHorizontal() ? position - (double)this.bounds.x : (double)(this.length + this.bounds.y) - position);
        Range r = this.getLocalRange();
        double min = r.getLower();
        double max = r.getUpper();
        double value = this.isLogScaleEnabled() ? Math.pow(10.0, (pixelsToStart - (double)this.margin) * (Math.log10(max) - Math.log10(min)) / (double)(this.length - 2 * this.margin) + Math.log10(min)) : (pixelsToStart - (double)this.margin) * (max - min) / (double)(this.length - 2 * this.margin) + min;
        return value;
    }

    @Override
    public boolean isHorizontal() {
        return this.orientation == Orientation.HORIZONTAL;
    }

    public boolean isShowMaxLabel() {
        return this.tickLabels.isShowMaxLabel();
    }

    public boolean isShowMinLabel() {
        return this.tickLabels.isShowMinLabel();
    }

    protected void layout() {
        super.layout();
        this.updateTick();
        Rectangle area = this.getClientArea();
        if (this.isHorizontal() && this.getTickLabelSide() == AbstractScale.LabelSide.Primary) {
            this.tickLabels.setBounds(new Rectangle(area.x, area.y + 6 + 2, area.width, area.height - 6));
            this.tickMarks.setBounds(area);
        } else if (this.isHorizontal() && this.getTickLabelSide() == AbstractScale.LabelSide.Secondary) {
            this.tickLabels.setBounds(new Rectangle(area.x, area.y + area.height - 6 - this.tickLabels.getTickLabelMaxHeight() - 2, area.width, this.tickLabels.getTickLabelMaxHeight()));
            this.tickMarks.setBounds(new Rectangle(area.x, area.y + area.height - 6, area.width, 6));
        } else if (this.getTickLabelSide() == AbstractScale.LabelSide.Primary) {
            this.tickLabels.setBounds(new Rectangle(area.x + area.width - 6 - this.tickLabels.getTickLabelMaxLength() - 2, area.y, this.tickLabels.getTickLabelMaxLength(), area.height));
            this.tickMarks.setBounds(new Rectangle(area.x + area.width - 6, area.y, 6, area.height));
        } else {
            this.tickLabels.setBounds(new Rectangle(area.x + 6 + 2, area.y, this.tickLabels.getTickLabelMaxLength(), area.height));
            this.tickMarks.setBounds(new Rectangle(area.x, area.y, 6, area.height));
        }
    }

    public void figureLayout() {
        super.layout();
    }

    public void setBounds(Rectangle rect) {
        if (!this.bounds.equals((Object)rect)) {
            this.setDirty(true);
            this.length = this.isHorizontal() ? rect.width - this.getInsets().getWidth() : rect.height - this.getInsets().getHeight();
        }
        super.setBounds(rect);
    }

    @Override
    public void setFont(Font font) {
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.tickLabels.setFont(font);
        super.setFont(font);
    }

    public void setForegroundColor(Color color) {
        this.tickMarks.setForegroundColor(color);
        this.tickLabels.setForegroundColor(color);
        super.setForegroundColor(color);
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.setDirty(true);
        this.revalidate();
    }

    public void setShowMaxLabel(boolean b) {
        this.tickLabels.setShowMaxLabel(b);
    }

    public void setShowMinLabel(boolean b) {
        this.tickLabels.setShowMinLabel(b);
    }

    public Range getLocalRange() {
        return this.localRange == null ? super.getRange() : this.localRange;
    }

    public void setLocalRange(Range localRange) {
        this.localRange = localRange;
    }

    @Override
    public void updateTick() {
        if (this.isDirty()) {
            this.calcMargin();
            this.setDirty(false);
            int n = this.length = this.isHorizontal() ? this.getClientArea().width : this.getClientArea().height;
            if (this.length > 2 * this.margin) {
                this.tickLabels.update(this.length - 2 * this.margin);
            }
        }
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    @Override
    public Range getScaleRange() {
        return this.getRange();
    }

    @Override
    public Dimension getDimension(Object obj) {
        if (obj == null) {
            return new Dimension();
        }
        if (obj instanceof String) {
            return FigureUtilities.getTextExtents((String)((String)obj), (Font)this.getFont());
        }
        return FigureUtilities.getTextExtents((String)this.format(obj), (Font)this.getFont());
    }

    @Override
    public boolean isPrimary() {
        return this.getTickLabelSide() == AbstractScale.LabelSide.Primary;
    }

    @Override
    public double getLabel(double value) {
        return value;
    }

    @Override
    public boolean isLabelCustomised() {
        return false;
    }

    @Override
    public boolean hasTicksAtEnds() {
        return true;
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

