/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.dataprovider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProviderListener;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;

public abstract class AbstractDataProvider
implements IDataProvider {
    protected boolean chronological = false;
    protected List<IDataProviderListener> listeners;
    protected Range xDataMinMax = null;
    protected Range yDataMinMax = null;

    public AbstractDataProvider(boolean chronological) {
        this.chronological = chronological;
        this.listeners = new ArrayList<IDataProviderListener>();
    }

    @Override
    public abstract int getSize();

    @Override
    public abstract ISample getSample(int var1);

    protected abstract void innerUpdate();

    protected abstract void updateDataRange(boolean var1);

    @Override
    public Range getXDataMinMax() {
        return this.getXDataMinMax(false);
    }

    @Override
    public Range getYDataMinMax() {
        return this.getYDataMinMax(false);
    }

    @Override
    public synchronized Range getXDataMinMax(boolean positiveOnly) {
        if (this.getSize() <= 0) {
            return null;
        }
        this.updateDataRange(positiveOnly);
        return this.xDataMinMax;
    }

    @Override
    public synchronized Range getYDataMinMax(boolean positiveOnly) {
        if (this.getSize() <= 0) {
            return null;
        }
        this.updateDataRange(positiveOnly);
        return this.yDataMinMax;
    }

    public void setChronological(boolean chronological) {
        this.chronological = chronological;
    }

    @Override
    public boolean isChronological() {
        return this.chronological;
    }

    @Override
    public void addDataProviderListener(IDataProviderListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    public boolean removeDataProviderListener(IDataProviderListener listener) {
        return this.listeners.remove(listener);
    }

    protected void fireDataChange() {
        this.innerUpdate();
        for (IDataProviderListener listener : this.listeners) {
            listener.dataChanged(this);
        }
    }
}

