/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.preference;

import org.apache.log4j.Logger;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationFilterPreferenceUI;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanFilterCateogoryPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanFilterPreference;

public class MSGlycanCustomFilterPreferencePage
extends PreferencePage
implements IPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MSGlycanCustomFilterPreferencePage.class);
    private MSGlycanAnnotationFilterPreferenceUI filterPreferenceUI;
    private MSGlycanFilterPreference filterPreferences = null;
    private MSGlycanFilterCateogoryPreference categoryPreferences = null;

    public MSGlycanCustomFilterPreferencePage() {
        this.loadFilterPreferences();
    }

    private void loadFilterPreferences() {
        try {
            this.filterPreferences = MSGlycanFilterPreference.getMSGlycanFilterPreferences(MSGlycanFilterPreference.getPreferenceEntity());
            this.categoryPreferences = MSGlycanFilterCateogoryPreference.getMSGlycanFilterCategoryPreferences(MSGlycanFilterCateogoryPreference.getPreferenceEntity());
        }
        catch (Exception e) {
            logger.error((Object)"Error getting filter preferences", (Throwable)e);
        }
    }

    protected Control createContents(Composite parent) {
        this.filterPreferenceUI = new MSGlycanAnnotationFilterPreferenceUI(parent, 2048, this);
        this.filterPreferenceUI.setPreferences(this.filterPreferences);
        this.filterPreferenceUI.setCategoryPreferences(this.categoryPreferences);
        this.filterPreferenceUI.initComponents();
        return parent;
    }

    public boolean isValid() {
        if (!this.filterPreferenceUI.isPageComplete()) {
            this.setErrorMessage(this.filterPreferenceUI.getErrorMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setValid(this.isValid());
    }

    protected void performApply() {
        this.save();
    }

    public boolean performOk() {
        this.save();
        return true;
    }

    private void save() {
        try {
            this.filterPreferenceUI.updatePreferences();
            logger.debug((Object)"Time to save values!");
            this.filterPreferences.saveValues();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

