/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.datamodel.property.project;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="projectTasklist")
@XmlType(propOrder={"task", "templateList", "person", "status", "role", "numberOfTasks", "groupOrPIName", "dueDate", "description", "addByDefault", "sampleType", "sampleName"})
public class ProjectTasklist {
    private boolean addByDefault = false;
    private String person = null;
    private String description = null;
    private String groupOrPIName = null;
    private String role = null;
    private String task = null;
    private List<String> templateList = new ArrayList<String>();
    private Date dueDate = null;
    private String status = null;
    private Integer numberOfTasks = 1;
    private String sampleType = null;
    private String sampleName = null;
    private Date modifiedTime;

    @XmlAttribute(name="addByDefault", required=true)
    public boolean isAddByDefault() {
        return this.addByDefault;
    }

    public void setAddByDefault(boolean addByDefault) {
        this.addByDefault = addByDefault;
    }

    @XmlAttribute(name="person", required=true)
    public String getPerson() {
        return this.person;
    }

    public void setPerson(String person) {
        this.person = person;
    }

    @XmlElement(name="description", required=false)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement(name="groupOrPIName", required=false)
    public String getGroupOrPIName() {
        return this.groupOrPIName;
    }

    public void setGroupOrPIName(String groupOrPIName) {
        this.groupOrPIName = groupOrPIName;
    }

    @XmlElement(name="role", required=false)
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @XmlElement(name="task", required=false)
    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    @XmlElement(name="dueDate", required=false)
    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @XmlElement(name="status", required=false)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @XmlElement(name="numberOfTasks", required=true)
    public int getNumberOfTasks() {
        return this.numberOfTasks;
    }

    public void setNumberOfTasks(int numberOfTasks) {
        this.numberOfTasks = numberOfTasks;
    }

    @XmlElement(name="sampleType", required=true)
    public String getSampleType() {
        return this.sampleType;
    }

    public void setSampleType(String a_sampleType) {
        this.sampleType = a_sampleType;
    }

    @XmlElement(name="sampleName", required=true)
    public String getSampleName() {
        return this.sampleName;
    }

    public void setSampleName(String a_sampleName) {
        this.sampleName = a_sampleName;
    }

    @XmlTransient
    public ProjectTasklist getACopy() {
        ProjectTasklist projectTasklist = new ProjectTasklist();
        projectTasklist.setAddByDefault(this.addByDefault);
        projectTasklist.setDescription(this.description);
        if (this.dueDate != null) {
            projectTasklist.setDueDate(new Date(this.dueDate.getTime()));
        }
        projectTasklist.setGroupOrPIName(this.groupOrPIName);
        projectTasklist.setPerson(this.person);
        projectTasklist.setRole(this.role);
        projectTasklist.status = this.status;
        projectTasklist.setTask(this.task);
        projectTasklist.setNumberOfTasks(this.numberOfTasks);
        return projectTasklist;
    }

    public boolean matches(ProjectTasklist projectTasklist) {
        return Objects.equals(this.task, projectTasklist.getTask()) && Objects.equals(this.person, projectTasklist.getPerson());
    }

    @XmlElement(name="templateList", required=false)
    public List<String> getTemplateList() {
        return this.templateList;
    }

    public void setTemplateList(List<String> a_templateList) {
        this.templateList = a_templateList;
    }

    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    @XmlAttribute
    public Date getModifiedTime() {
        return this.modifiedTime;
    }
}

