/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.datamodel.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.projectexplorer.part.ProjectExplorerLabelProvider;
import org.grits.toolbox.core.projectexplorer.part.ProjectExplorerViewContentProvider;
import org.grits.toolbox.core.utilShare.sort.EntryComparator;

public class ProjectExplorerDialog
extends TitleAreaDialog {
    private List<String> filter = new ArrayList<String>();
    private Entry entry = null;
    protected Shell parent = null;
    private TreeViewer viewer;
    private Entry selectedEntry = null;

    public ProjectExplorerDialog(Shell parentShell) {
        super(parentShell);
        this.parent = parentShell;
        Monitor primary = parentShell.getMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = parentShell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        parentShell.setLocation(x, y);
        parentShell.setSize(300, 300);
        this.create();
    }

    public void addFilter(String filter) {
        this.filter.add(filter);
    }

    public Entry getEntry() {
        return this.entry;
    }

    public Control createDialogArea(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 10;
        parent.setLayout((Layout)gridLayout);
        this.viewer = new TreeViewer(parent, 2820);
        this.viewer.setContentProvider((IContentProvider)new ProjectExplorerViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProjectExplorerLabelProvider());
        this.viewer.setInput((Object)PropertyHandler.getDataModel().getRoot());
        this.viewer.setComparator((ViewerComparator)new EntryComparator());
        GridData treeData = new GridData();
        treeData.minimumHeight = 180;
        treeData.grabExcessHorizontalSpace = true;
        treeData.grabExcessVerticalSpace = true;
        treeData.horizontalAlignment = 4;
        treeData.horizontalSpan = 3;
        this.viewer.getTree().setLayoutData((Object)treeData);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                TreeSelection to = (TreeSelection)selection;
                if (to.size() == 1) {
                    Entry node = (Entry)to.getFirstElement();
                    boolean match = false;
                    for (String ft : ProjectExplorerDialog.this.filter) {
                        if (!node.getProperty().getType().equals(ft)) continue;
                        match = true;
                    }
                    if (match) {
                        ProjectExplorerDialog.this.getButton(0).setEnabled(true);
                        ProjectExplorerDialog.this.selectedEntry = node;
                    } else {
                        ProjectExplorerDialog.this.getButton(0).setEnabled(false);
                    }
                } else {
                    ProjectExplorerDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        return parent;
    }

    protected void okPressed() {
        this.entry = this.selectedEntry;
        super.okPressed();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }
}

