/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.io.ms.annotation.glycan.report.process.export;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.grits.toolbox.datamodel.ms.annotation.glycan.report.tablemodel.MSGlycanAnnotationReportTableDataObject;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPrecursorPeak;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.io.ms.annotation.glycan.process.export.MSGlycanAnnotationExportProcess;
import org.grits.toolbox.io.ms.annotation.glycan.report.process.export.MSGlycanAnnotationReportWriterExcel;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationWriterExcel;

public class MSGlycanAnnotationReportExportProcess
extends MSGlycanAnnotationExportProcess {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationReportExportProcess.class);

    protected MSAnnotationWriterExcel getNewMSAnnotationWriterExcel() {
        return new MSGlycanAnnotationReportWriterExcel();
    }

    protected void markAnnotatedRows(int iRowNum, Map<Integer, List<String>> mAtLeastOne) throws Exception {
        GRITSListDataRow row = (GRITSListDataRow)this.getMyTableDataObject().getTableData().get(iRowNum);
        int iNumExps = this.getMyTableDataObject().getPeakIdCols().size();
        int i = 0;
        while (i < iNumExps) {
            int iFeatureIdCol = (Integer)this.getMyTableDataObject().getFeatureIdCols().get(i);
            String sFeatureId = (String)row.getDataRow().get(iFeatureIdCol);
            if (!(sFeatureId == null && this.hideUnAnnotatedRows() || sFeatureId == null)) {
                List<Object> alAtLeastOne = null;
                if (!mAtLeastOne.containsKey(iRowNum)) {
                    alAtLeastOne = new ArrayList();
                    mAtLeastOne.put(iRowNum, alAtLeastOne);
                } else {
                    alAtLeastOne = mAtLeastOne.get(iRowNum);
                }
                alAtLeastOne.add(Integer.toString(i));
            }
            ++i;
        }
    }

    protected Map<String, List<Integer>> getRowIdtoRowNumMap() {
        HashMap<String, List<Integer>> mRowIdToRunNum = new HashMap<String, List<Integer>>();
        int i = 0;
        while (i < this.getTableDataObject().getTableData().size()) {
            if (this.isCanceled()) {
                return null;
            }
            String sRowID = Integer.toString(i);
            List<Integer> lRowNums = null;
            if (mRowIdToRunNum.containsKey(sRowID)) {
                lRowNums = (List)mRowIdToRunNum.get(sRowID);
            } else {
                lRowNums = new ArrayList();
                mRowIdToRunNum.put(sRowID, lRowNums);
            }
            lRowNums.add(i);
            ++i;
        }
        return mRowIdToRunNum;
    }

    protected boolean getFinalVisibility(int iRowNum, Map<Integer, List<String>> mAtLeastOne) throws Exception {
        GRITSListDataRow row = (GRITSListDataRow)this.getMyTableDataObject().getTableData().get(iRowNum);
        int iNumExps = this.getMyTableDataObject().getPeakIdCols().size();
        boolean bInvisible = false;
        int i = 0;
        while (i < iNumExps) {
            int iFeatureIdCol = (Integer)this.getMyTableDataObject().getFeatureIdCols().get(i);
            String sFeatureId = (String)row.getDataRow().get(iFeatureIdCol);
            if (sFeatureId != null || !this.hideUnAnnotatedRows()) {
                if (!mAtLeastOne.containsKey(iRowNum)) {
                    if (!(sFeatureId == null && this.hideUnAnnotatedRows() || sFeatureId != null && this.getMyTableDataObject().isHiddenRow(Integer.valueOf(iRowNum), Integer.toString(i), sFeatureId))) {
                        bInvisible = true;
                    }
                } else {
                    List<String> atLeastOne = mAtLeastOne.get(iRowNum);
                    if (!(atLeastOne != null && atLeastOne.size() != 0 || sFeatureId == null && this.hideUnAnnotatedRows() || sFeatureId != null && this.getMyTableDataObject().isHiddenRow(Integer.valueOf(iRowNum), Integer.toString(i), sFeatureId))) {
                        bInvisible = true;
                    }
                }
            }
            ++i;
        }
        return bInvisible;
    }

    protected int isVisible(int iRowNum) {
        GRITSListDataRow row = (GRITSListDataRow)this.getMyTableDataObject().getTableData().get(iRowNum);
        int iNumExps = this.getMyTableDataObject().getPeakIdCols().size();
        int iHiddenCount = 0;
        int i = 0;
        while (i < iNumExps) {
            int iFeatureIdCol = (Integer)this.getMyTableDataObject().getFeatureIdCols().get(i);
            String sFeatureId = (String)row.getDataRow().get(iFeatureIdCol);
            if (sFeatureId != null || !this.hideUnAnnotatedRows()) {
                String iRowId = Integer.toString(i);
                if (this.getMyTableDataObject().isHiddenRow(Integer.valueOf(iRowNum), iRowId, sFeatureId)) {
                    ++iHiddenCount;
                } else {
                    return 0;
                }
            }
            ++i;
        }
        if (iHiddenCount == iNumExps) {
            return 2;
        }
        return 1;
    }

    protected void applyIntensityFilter(int iRowNum, Map<String, Double> rowIntensityMap) {
        GRITSListDataRow row = (GRITSListDataRow)this.getMyTableDataObject().getTableData().get(iRowNum);
        new ArrayList();
        int iNumExps = this.getMyTableDataObject().getSequenceCols().size();
        double dMaxInt = 0.0;
        int i = 0;
        while (i < iNumExps) {
            Double dPeakIntensity = 0.0;
            if (this.filterKey != null && this.filterKey.equals(DMPeak.peak_intensity.getLabel())) {
                Double peakIntensity = (Double)row.getDataRow().get((Integer)this.getTableDataObject().getPeakIntensityCols().get(0));
                if (this.thresholdValue > 0.0 && peakIntensity >= this.thresholdValue) {
                    dPeakIntensity = peakIntensity;
                }
            } else if (this.filterKey != null && this.filterKey.equals(DMPrecursorPeak.precursor_peak_intensity.getLabel())) {
                Double intensity = (Double)row.getDataRow().get((Integer)this.getTableDataObject().getPrecursorIntensityCols().get(0));
                if (this.thresholdValue > 0.0 && intensity >= this.thresholdValue) {
                    dPeakIntensity = intensity;
                }
            }
            if (dPeakIntensity > dMaxInt) {
                dMaxInt = dPeakIntensity;
            }
            ++i;
        }
        rowIntensityMap.put(Integer.toString(iRowNum), dMaxInt);
    }

    protected Boolean applyGlycanFilters(ArrayList<Object> dataRow) throws Exception {
        int iNumExps = this.getMyTableDataObject().getSequenceCols().size();
        boolean bPassedOne = false;
        int i = 0;
        while (i < iNumExps) {
            int sequenceCol = (Integer)this.getMyTableDataObject().getSequenceCols().get(i);
            String sequence = (String)dataRow.get(sequenceCol);
            boolean bPasses = this.passesFilters(sequence);
            bPassedOne |= bPasses;
            ++i;
        }
        return bPassedOne;
    }

    public MSGlycanAnnotationReportTableDataObject getMyTableDataObject() {
        return (MSGlycanAnnotationReportTableDataObject)this.tableDataObject;
    }
}

