/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;

@XmlType(propOrder={"uri", "label", "descriptorGroups", "descriptors"})
public class Category {
    private String uri = null;
    private String label = null;
    private List<Descriptor> descriptors = new ArrayList<Descriptor>();
    private List<DescriptorGroup> descriptorGroups = new ArrayList<DescriptorGroup>();

    public Category() {
    }

    public Category(String uri) {
        this.uri = uri;
    }

    @XmlAttribute(name="uri", required=true)
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @XmlAttribute(name="label", required=true)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @XmlElement(name="descriptorGroup", required=false)
    public List<DescriptorGroup> getDescriptorGroups() {
        return this.descriptorGroups;
    }

    public void setDescriptorGroups(List<DescriptorGroup> descriptorGroups) {
        this.descriptorGroups = descriptorGroups;
    }

    public void addDescriptorGroup(DescriptorGroup descriptorGroup) {
        this.descriptorGroups.add(descriptorGroup);
    }

    @XmlElement(name="descriptor", required=false)
    public List<Descriptor> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(List<Descriptor> descriptors) {
        this.descriptors = descriptors;
    }

    public void addDescriptor(Descriptor descriptor) {
        this.descriptors.add(descriptor);
    }

    public Category getACopy() {
        Category category = new Category();
        category.setUri(this.uri);
        for (Descriptor desc : this.descriptors) {
            category.addDescriptor(desc.getACopy());
        }
        for (DescriptorGroup dg : this.descriptorGroups) {
            category.addDescriptorGroup(dg.getACopy());
        }
        return category;
    }
}

