/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.dialog;

import com.hp.hpl.jena.vocabulary.XSD;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.core.typeahead.NamespaceHandler;
import org.grits.toolbox.core.typeahead.PatriciaTrieContentProposalProvider;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.entry.sample.config.ImageRegistry;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.MeasurementUnit;
import org.grits.toolbox.entry.sample.model.Namespace;

public class AddDescriptorDialog
extends TitleAreaDialog {
    private Logger logger = Logger.getLogger(AddDescriptorDialog.class);
    private static final String DATE_FORMAT = "MM/dd/yyyy";
    private SimpleDateFormat simpleDateFormat = null;
    private List<Descriptor> availableDescriptors = null;
    public Descriptor descriptor = null;
    private ComboViewer descriptorCombo = null;
    private StackLayout stackLayout = null;
    private Text descriptorValueText = null;
    private CDateTime cDateTime = null;
    private ComboViewer descriptorUnitCombo = null;
    private IContentProposal[] proposals = null;
    private ContentProposalAdapter contentProposalAdapter = null;
    private String lastValidValue = "";

    public void create() {
        super.create();
        String title = this.descriptor == null ? "Adding a Decriptor" : "Edit the Descriptor";
        this.setTitle(title);
        this.setMessage("Please enter the following information");
        this.simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        this.initializeCombo();
    }

    private void initializeCombo() {
        if (this.descriptor == null) {
            this.descriptorCombo.setInput(this.availableDescriptors);
            this.getButton(0).setEnabled(false);
        } else {
            this.availableDescriptors = new ArrayList<Descriptor>();
            this.availableDescriptors.add(this.descriptor);
            this.descriptorCombo.setInput(this.availableDescriptors);
            this.descriptorCombo.setSelection((ISelection)new StructuredSelection((Object)this.descriptor));
        }
    }

    public AddDescriptorDialog(Shell parentShell, Descriptor descriptor) {
        super(parentShell);
        this.descriptor = descriptor;
    }

    public AddDescriptorDialog(Shell parentShell, List<Descriptor> availableDescriptors) {
        super(parentShell);
        this.availableDescriptors = availableDescriptors;
    }

    public Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(comp, 0);
        Image icon = this.descriptor == null ? ImageShare.ADD_ICON.createImage() : ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.EDIT_DESCRIPTOR_ICON).createImage();
        container.getShell().setImage(icon);
        GridData containerData = new GridData(4, 4, false, false);
        containerData.widthHint = 400;
        container.setLayoutData((Object)containerData);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 25;
        container.setLayout((Layout)layout);
        this.createLabel(container, "Descriptor");
        this.descriptorCombo = new ComboViewer(container, 2056);
        this.descriptorCombo.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.descriptorCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element instanceof Descriptor ? ((Descriptor)element).getLabel() : null;
            }
        });
        this.descriptorCombo.getCombo().setLayoutData((Object)this.getDefaultLayoutData());
        this.createLabel(container, "Value");
        Composite valueComposite = new Composite(container, 0);
        valueComposite.setLayoutData((Object)this.getDefaultLayoutData());
        this.descriptorValueText = new Text(valueComposite, 2048);
        this.cDateTime = new CDateTime(valueComposite, 3);
        this.cDateTime.setPattern(DATE_FORMAT);
        this.stackLayout = new StackLayout();
        valueComposite.setLayout((Layout)this.stackLayout);
        this.stackLayout.topControl = this.descriptorValueText;
        this.createLabel(container, "Unit");
        this.descriptorUnitCombo = new ComboViewer(container, 2056);
        this.descriptorUnitCombo.getCombo().setLayoutData((Object)this.getDefaultLayoutData());
        this.descriptorUnitCombo.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.descriptorUnitCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element instanceof MeasurementUnit ? ((MeasurementUnit)element).getLabel() : null;
            }
        });
        this.descriptorCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!AddDescriptorDialog.this.descriptorCombo.getSelection().isEmpty()) {
                    AddDescriptorDialog.this.descriptor = (Descriptor)((StructuredSelection)AddDescriptorDialog.this.descriptorCombo.getSelection()).getFirstElement();
                    AddDescriptorDialog.this.changeValueControl();
                    AddDescriptorDialog.this.setUnitCombo();
                }
            }
        });
        this.descriptorValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = ((Text)e.getSource()).getText().trim();
                boolean valid = AddDescriptorDialog.this.isValid(value);
                AddDescriptorDialog.this.getButton(0).setEnabled(valid);
                if (valid) {
                    AddDescriptorDialog.this.lastValidValue = value;
                }
            }
        });
        this.descriptorValueText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 27) {
                    e.doit = false;
                    AddDescriptorDialog.this.descriptorValueText.setText(AddDescriptorDialog.this.lastValidValue);
                    e.detail = 0;
                }
            }
        });
        this.contentProposalAdapter = new ContentProposalAdapter((Control)this.descriptorValueText, (IControlContentAdapter)new TextContentAdapter(), null, null, null);
        this.contentProposalAdapter.setProposalAcceptanceStyle(2);
        this.contentProposalAdapter.addContentProposalListener(new IContentProposalListener2(){

            public void proposalPopupOpened(ContentProposalAdapter adapter) {
                AddDescriptorDialog.this.proposals = AddDescriptorDialog.this.contentProposalAdapter.getContentProposalProvider().getProposals(AddDescriptorDialog.this.contentProposalAdapter.getControlContentAdapter().getControlContents((Control)AddDescriptorDialog.this.descriptorValueText), AddDescriptorDialog.this.contentProposalAdapter.getControlContentAdapter().getCursorPosition((Control)AddDescriptorDialog.this.descriptorValueText));
            }

            public void proposalPopupClosed(ContentProposalAdapter adapter) {
            }
        });
        return comp;
    }

    protected void setUnitCombo() {
        if (!this.descriptor.getValidUnits().isEmpty()) {
            MeasurementUnit selectedUnit = null;
            for (MeasurementUnit unit : this.descriptor.getValidUnits()) {
                if (!unit.getUri().equals(this.descriptor.getSelectedMeasurementUnit())) continue;
                selectedUnit = unit;
                break;
            }
            this.descriptorUnitCombo.setInput(this.descriptor.getValidUnits());
            if (selectedUnit != null) {
                this.descriptorUnitCombo.setSelection((ISelection)new StructuredSelection((Object)selectedUnit));
            }
            this.descriptorUnitCombo.getCombo().setEnabled(true);
        } else {
            this.descriptorUnitCombo.setInput(new ArrayList());
            this.descriptorUnitCombo.getCombo().setEnabled(false);
        }
    }

    protected void changeValueControl() {
        String namespaceUri = this.descriptor.getNamespaces().isEmpty() ? XSD.xstring.getURI() : this.descriptor.getNamespaces().iterator().next().getUri();
        CDateTime topControl = XSD.date.getURI().equals(namespaceUri) ? this.cDateTime : this.descriptorValueText;
        this.stackLayout.topControl = topControl;
        if (topControl.equals(this.cDateTime)) {
            this.cDateTime.setVisible(topControl.equals(this.cDateTime));
            this.initializeCalendar();
        } else {
            this.descriptorValueText.setVisible(topControl.equals(this.descriptorValueText));
            this.initializeContentProposal();
        }
    }

    private void initializeCalendar() {
        Date date = null;
        if (!this.descriptorCombo.getSelection().isEmpty()) {
            try {
                date = this.descriptor.getValue() == null ? null : this.simpleDateFormat.parse(this.descriptor.getValue());
            }
            catch (ParseException parseException) {
                try {
                    date = this.descriptor.getValue() == null ? null : new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy").parse(this.descriptor.getValue());
                }
                catch (ParseException ex2) {
                    this.logger.error((Object)("Error parsing date value from descriptor " + this.descriptor.getValue() + " \n" + ex2.getMessage()), (Throwable)ex2);
                }
            }
        }
        this.cDateTime.setSelection(date);
    }

    protected void initializeContentProposal() {
        String value = this.descriptor.getValue() == null ? "" : this.descriptor.getValue();
        this.descriptorValueText.setText(value);
        this.contentProposalAdapter.setEnabled(false);
        Namespace namespace = this.descriptor.getNamespaces().iterator().next();
        if (namespace.getNamespaceFile() != null) {
            try {
                this.logger.info((Object)("Loading namespace : " + namespace.getNamespaceFile()));
                NamespaceHandler handler = new NamespaceHandler(namespace.getUri(), null, namespace.getNamespaceFile(), "org.grits.toolbox.entry.sample");
                PatriciaTrie trie = handler.getTrieForNamespace();
                if (trie != null && !trie.isEmpty()) {
                    this.logger.info((Object)("Setting content proposal provider for type ahead with trie size : " + trie.size()));
                    this.contentProposalAdapter.setContentProposalProvider((IContentProposalProvider)new PatriciaTrieContentProposalProvider(trie));
                    this.contentProposalAdapter.setEnabled(true);
                } else {
                    this.logger.error((Object)("Something went wrong while loading namespace \"" + namespace.getLabel() + "\". Type-ahead is not available currently!"));
                    MessageDialog.openError((Shell)this.getShell(), (String)"Type-ahead Error", (String)("Something went wrong while loading namespace \"" + namespace.getLabel() + "\". Type-ahead is not available currently!"));
                }
            }
            catch (Error | Exception ex) {
                this.logger.error((Object)ex.getMessage(), ex);
                MessageDialog.openError((Shell)this.getShell(), (String)"Type-ahead Error", (String)("Something went wrong while loading namespace \"" + namespace.getLabel() + "\". Type-ahead is not available currently!"));
            }
        }
    }

    private GridData getDefaultLayoutData() {
        GridData textDataName = new GridData();
        textDataName.grabExcessHorizontalSpace = true;
        textDataName.horizontalAlignment = 4;
        return textDataName;
    }

    private void createLabel(Composite container, String labelTitle) {
        Label label = new Label(container, 0);
        label.setText(labelTitle);
        label.setLayoutData((Object)new GridData(128));
    }

    protected boolean isValid(String value) {
        return value.isEmpty() || this.descriptor.getNamespaces().isEmpty() || this.verifyFromNamespace(value, this.descriptor.getNamespaces().iterator().next());
    }

    private boolean verifyFromNamespace(String value, Namespace namespace) {
        boolean isValid = false;
        if (XSD.xstring.getURI().equals(namespace.getUri())) {
            isValid = true;
        } else if (XSD.xboolean.getURI().equals(namespace.getUri())) {
            isValid = "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
        } else if (XSD.xdouble.getURI().equals(namespace.getUri())) {
            try {
                Double.parseDouble(value);
                isValid = true;
                this.setErrorMessage(null);
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("Please enter a valid number");
            }
        } else if (XSD.date.getURI().equals(namespace.getUri())) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            dateFormat.setLenient(false);
            try {
                dateFormat.parse(value);
                isValid = true;
                this.setErrorMessage(null);
            }
            catch (ParseException parseException) {
                this.setErrorMessage("Please enter a valid date in format: MM/dd/yyyy");
            }
        } else if (namespace.getNamespaceFile() != null && this.proposals != null) {
            IContentProposal[] iContentProposalArray = this.proposals;
            int n = this.proposals.length;
            int n2 = 0;
            while (n2 < n) {
                IContentProposal proposal = iContentProposalArray[n2];
                if (proposal.getContent().equals(value)) {
                    isValid = true;
                    break;
                }
                ++n2;
            }
        }
        return isValid;
    }

    protected void okPressed() {
        if (!this.descriptorCombo.getSelection().isEmpty()) {
            this.descriptor = (Descriptor)((StructuredSelection)this.descriptorCombo.getSelection()).getFirstElement();
            String value = this.lastValidValue.isEmpty() ? null : this.lastValidValue;
            this.descriptor.setValue(value);
            String selectedUnit = null;
            if (!this.descriptorUnitCombo.getSelection().isEmpty()) {
                selectedUnit = ((MeasurementUnit)((StructuredSelection)this.descriptorUnitCombo.getSelection()).getFirstElement()).getUri();
            }
            this.descriptor.setSelectedMeasurementUnit(selectedUnit);
            super.okPressed();
        }
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }
}

