/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.reporting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.eurocarbdb.application.glycanbuilder.ActionManager;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.FileHistory;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.GraphicOptionsDialog;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MouseUtils;
import org.eurocarbdb.application.glycanbuilder.SVGUtils;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.ReportingPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportCanvas;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportDocument;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportOptionsDialog;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.StructureSelectorDialog;

public class AnnotationReportEditor
extends JFrame
implements ActionListener,
MouseListener,
AnnotationReportCanvas.SelectionChangeListener,
BaseDocument.DocumentChangeListener {
    private GlycoWorkbench theApplication;
    private ActionManager theActionManager;
    private ReportingPlugin thePlugin;
    private JMenuBar theMenuBar;
    private JToolBar theToolBar;
    private AnnotationReportCanvas theCanvas;
    private JScrollPane theScrollPane;
    private ButtonGroup display_button_group = null;
    protected HashMap<String, ButtonModel> display_models = null;

    public AnnotationReportEditor(GlycoWorkbench application, ReportingPlugin plugin, AnnotationReportDocument doc, boolean init_pos) {
        this.theApplication = application;
        this.theActionManager = new ActionManager();
        this.theCanvas = new AnnotationReportCanvas(doc, init_pos);
        this.theCanvas.getDocument().addDocumentChangeListener(this);
        this.thePlugin = plugin;
        this.createActions();
        this.getContentPane().setLayout(new BorderLayout());
        this.theMenuBar = this.createMenuBar();
        this.setJMenuBar(this.theMenuBar);
        UIManager.getDefaults().put("ToolTip.hideAccelerator", Boolean.TRUE);
        this.theToolBar = this.createToolBar();
        this.getContentPane().add((Component)this.theToolBar, "North");
        this.theScrollPane = new JScrollPane(this.theCanvas);
        this.theCanvas.setScrollPane(this.theScrollPane);
        this.getContentPane().add((Component)this.theScrollPane, "Center");
        this.theCanvas.addMouseListener(this);
        this.theCanvas.addSelectionChangeListener(this);
        this.updateTitle();
        this.setSize(900, 700);
        this.setLocationRelativeTo((Component)((Object)this.theApplication));
        this.updateActions();
    }

    private void createActions() {
        for (Map.Entry e : SVGUtils.getExportFormats().entrySet()) {
            this.theActionManager.add("export=" + (String)e.getKey(), FileUtils.defaultThemeManager.getImageIcon(""), "Export to " + (String)e.getValue() + "...", -1, "", (ActionListener)this);
        }
        this.theActionManager.add("open", FileUtils.defaultThemeManager.getImageIcon("open"), "Open...", 79, "ctrl O", (ActionListener)this);
        this.theActionManager.add("save", FileUtils.defaultThemeManager.getImageIcon("save"), "Save", 83, "ctrl S", (ActionListener)this);
        this.theActionManager.add("saveas", FileUtils.defaultThemeManager.getImageIcon("saveas"), "Save as...", 65, "shift ctrl S", (ActionListener)this);
        this.theActionManager.add("update", FileUtils.defaultThemeManager.getImageIcon("update"), "Update annotations", 85, "", (ActionListener)this);
        this.theActionManager.add("print", FileUtils.defaultThemeManager.getImageIcon("print"), "Print...", 80, "ctrl P", (ActionListener)this);
        this.theActionManager.add("close", FileUtils.defaultThemeManager.getImageIcon("close"), "Close", 67, "ctrl Q", (ActionListener)this);
        this.theActionManager.add("undo", FileUtils.defaultThemeManager.getImageIcon("undo"), "Undo", 85, "ctrl Z", (ActionListener)this);
        this.theActionManager.add("redo", FileUtils.defaultThemeManager.getImageIcon("redo"), "Redo", 82, "ctrl Y", (ActionListener)this);
        this.theActionManager.add("cut", FileUtils.defaultThemeManager.getImageIcon("cut"), "Cut", 84, "ctrl X", (ActionListener)this);
        this.theActionManager.add("copy", FileUtils.defaultThemeManager.getImageIcon("copy"), "Copy", 67, "ctrl C", (ActionListener)this);
        this.theActionManager.add("delete", FileUtils.defaultThemeManager.getImageIcon("delete"), "Delete", 127, "", (ActionListener)this);
        this.theActionManager.add("screenshot", FileUtils.defaultThemeManager.getImageIcon("screenshot"), "Screenshot", 154, "PRINTSCREEN", (ActionListener)this);
        this.theActionManager.add("selectall", FileUtils.defaultThemeManager.getImageIcon("selectall"), "Select all", 65, "ctrl A", (ActionListener)this);
        this.theActionManager.add("selectnone", FileUtils.defaultThemeManager.getImageIcon("selectnone"), "Select none", 69, "ESCAPE", (ActionListener)this);
        this.theActionManager.add("enlarge", FileUtils.defaultThemeManager.getImageIcon("enlarge"), "Enlarge selected structures", -1, "", (ActionListener)this);
        this.theActionManager.add("resetsize", FileUtils.defaultThemeManager.getImageIcon("resetsize"), "Reset size of selected structures to default value", -1, "", (ActionListener)this);
        this.theActionManager.add("shrink", FileUtils.defaultThemeManager.getImageIcon("shrink"), "Shrink selected structures", -1, "", (ActionListener)this);
        this.theActionManager.add("highlight", FileUtils.defaultThemeManager.getImageIcon("highlight"), "Set highlight for selected structures", -1, "", (ActionListener)this);
        this.theActionManager.add("ungroup", FileUtils.defaultThemeManager.getImageIcon("ungroup"), "Ungroup selected structures", -1, "", (ActionListener)this);
        this.theActionManager.add("group", FileUtils.defaultThemeManager.getImageIcon("group"), "Group selected structures", -1, "", (ActionListener)this);
        this.theActionManager.add("placestructures", FileUtils.defaultThemeManager.getImageIcon("placestructures"), "Automatic place all structures", -1, "", (ActionListener)this);
        this.theActionManager.add("zoomnone", FileUtils.defaultThemeManager.getImageIcon("zoomnone"), "Reset zoom", -1, "", (ActionListener)this);
        this.theActionManager.add("zoomin", FileUtils.defaultThemeManager.getImageIcon("zoomin"), "Zoom in", -1, "", (ActionListener)this);
        this.theActionManager.add("zoomout", FileUtils.defaultThemeManager.getImageIcon("zoomout"), "Zoom out", -1, "", (ActionListener)this);
        this.theActionManager.add("notation=cfg", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "CFG notation", 67, "", (ActionListener)this);
        this.theActionManager.add("notation=cfgbw", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "CFG black and white notation", 66, "", (ActionListener)this);
        this.theActionManager.add("notation=cfglink", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "CFG with linkage placement notation", 76, "", (ActionListener)this);
        this.theActionManager.add("notation=uoxf", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "UOXF notation", 79, "", (ActionListener)this);
        this.theActionManager.add("notation=text", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Text only notation", 84, "", (ActionListener)this);
        this.theActionManager.add("display=compact", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "compact view", 79, "", (ActionListener)this);
        this.theActionManager.add("display=normal", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "normal view", 78, "", (ActionListener)this);
        this.theActionManager.add("display=normalinfo", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "normal view with linkage info", 73, "", (ActionListener)this);
        this.theActionManager.add("display=custom", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "custom view with user settings", 75, "", (ActionListener)this);
        this.theActionManager.add("orientation", this.getOrientationIcon(), "Change orientation", -1, "", (ActionListener)this);
        this.theActionManager.add("displaysettings", FileUtils.defaultThemeManager.getImageIcon(""), "Change structure display settings", 83, "", (ActionListener)this);
        this.theActionManager.add("reportsettings", FileUtils.defaultThemeManager.getImageIcon(""), "Change report display settings", 82, "", (ActionListener)this);
    }

    private void updateActions() {
        this.theActionManager.get("save").setEnabled(this.theCanvas.getDocument().hasChanged());
        this.theActionManager.get("undo").setEnabled(this.theCanvas.getDocument().getUndoManager().canUndo());
        this.theActionManager.get("redo").setEnabled(this.theCanvas.getDocument().getUndoManager().canRedo());
        this.theActionManager.get("cut").setEnabled(this.theCanvas.hasSelection());
        this.theActionManager.get("copy").setEnabled(this.theCanvas.hasSelection());
        this.theActionManager.get("delete").setEnabled(this.theCanvas.hasSelection());
        this.theActionManager.get("enlarge").setEnabled(this.theCanvas.hasSelection());
        this.theActionManager.get("resetsize").setEnabled(this.theCanvas.hasSelection());
        this.theActionManager.get("shrink").setEnabled(this.theCanvas.hasSelection());
        this.theActionManager.get("highlight").setEnabled(this.theCanvas.hasSelection());
        this.theActionManager.get("group").setEnabled(this.theCanvas.canGroupSelections());
        this.theActionManager.get("orientation").putValue("SmallIcon", (Object)this.getOrientationIcon());
    }

    private JMenu createExportDrawingMenu() {
        JMenu export_menu = new JMenu("Export to graphical formats");
        export_menu.setIcon(FileUtils.defaultThemeManager.getImageIcon("export"));
        for (Map.Entry e : SVGUtils.getExportFormats().entrySet()) {
            export_menu.add((Action)this.theActionManager.get("export=" + (String)e.getKey()));
        }
        return export_menu;
    }

    private JMenu createFileMenu() {
        JMenu file_menu = new JMenu("File");
        file_menu.add((Action)this.theActionManager.get("open"));
        file_menu.add((Action)this.theActionManager.get("save"));
        file_menu.add((Action)this.theActionManager.get("saveas"));
        file_menu.addSeparator();
        file_menu.add((Action)this.theActionManager.get("update"));
        file_menu.addSeparator();
        file_menu.add(this.createExportDrawingMenu());
        file_menu.addSeparator();
        file_menu.add((Action)this.theActionManager.get("print"));
        file_menu.addSeparator();
        file_menu.add((Action)this.theActionManager.get("close"));
        return file_menu;
    }

    private JMenu createEditMenu() {
        JMenu edit_menu = new JMenu("Edit");
        edit_menu.setMnemonic(69);
        edit_menu.add((Action)this.theActionManager.get("undo"));
        edit_menu.add((Action)this.theActionManager.get("redo"));
        edit_menu.addSeparator();
        edit_menu.add((Action)this.theActionManager.get("cut"));
        edit_menu.add((Action)this.theActionManager.get("copy"));
        edit_menu.add((Action)this.theActionManager.get("delete"));
        edit_menu.add((Action)this.theActionManager.get("screenshot"));
        edit_menu.addSeparator();
        edit_menu.add((Action)this.theActionManager.get("selectall"));
        edit_menu.add((Action)this.theActionManager.get("selectnone"));
        edit_menu.addSeparator();
        edit_menu.add((Action)this.theActionManager.get("enlarge"));
        edit_menu.add((Action)this.theActionManager.get("resetsize"));
        edit_menu.add((Action)this.theActionManager.get("shrink"));
        edit_menu.addSeparator();
        edit_menu.add((Action)this.theActionManager.get("highlight"));
        edit_menu.addSeparator();
        edit_menu.add((Action)this.theActionManager.get("group"));
        edit_menu.add((Action)this.theActionManager.get("ungroup"));
        edit_menu.addSeparator();
        edit_menu.add((Action)this.theActionManager.get("placestructures"));
        return edit_menu;
    }

    private JMenu createViewMenu() {
        GraphicOptions view_opt = this.theCanvas.getWorkspace().getGraphicOptions();
        JMenu view_menu = new JMenu("View");
        view_menu.setMnemonic(86);
        view_menu.add((Action)this.theActionManager.get("zoomnone"));
        view_menu.add((Action)this.theActionManager.get("zoomin"));
        view_menu.add((Action)this.theActionManager.get("zoomout"));
        view_menu.addSeparator();
        JRadioButtonMenuItem last = null;
        ButtonGroup groupn = new ButtonGroup();
        last = new JRadioButtonMenuItem((Action)this.theActionManager.get("notation=cfg"));
        view_menu.add(last);
        last.setSelected(view_opt.NOTATION.equals("cfg"));
        groupn.add(last);
        last = new JRadioButtonMenuItem((Action)this.theActionManager.get("notation=cfgbw"));
        view_menu.add(last);
        last.setSelected(view_opt.NOTATION.equals("cfgbw"));
        groupn.add(last);
        last = new JRadioButtonMenuItem((Action)this.theActionManager.get("notation=cfglink"));
        view_menu.add(last);
        last.setSelected(view_opt.NOTATION.equals("cfglink"));
        groupn.add(last);
        last = new JRadioButtonMenuItem((Action)this.theActionManager.get("notation=uoxf"));
        view_menu.add(last);
        last.setSelected(view_opt.NOTATION.equals("uoxf"));
        groupn.add(last);
        last = new JRadioButtonMenuItem((Action)this.theActionManager.get("notation=text"));
        view_menu.add(last);
        last.setSelected(view_opt.NOTATION.equals("text"));
        groupn.add(last);
        view_menu.addSeparator();
        this.display_button_group = new ButtonGroup();
        this.display_models = new HashMap();
        last = new JRadioButtonMenuItem((Action)this.theActionManager.get("display=compact"));
        view_menu.add(last);
        last.setSelected(view_opt.DISPLAY.equals("compact"));
        this.display_models.put("compact", last.getModel());
        this.display_button_group.add(last);
        last = new JRadioButtonMenuItem((Action)this.theActionManager.get("display=normal"));
        view_menu.add(last);
        last.setSelected(view_opt.DISPLAY.equals("normal"));
        this.display_models.put("normal", last.getModel());
        this.display_button_group.add(last);
        last = new JRadioButtonMenuItem((Action)this.theActionManager.get("display=normalinfo"));
        view_menu.add(last);
        last.setSelected(view_opt.DISPLAY.equals("normalinfo"));
        this.display_models.put("normalinfo", last.getModel());
        this.display_button_group.add(last);
        last = new JRadioButtonMenuItem((Action)this.theActionManager.get("display=custom"));
        view_menu.add(last);
        last.setSelected(view_opt.DISPLAY.equals("custom"));
        this.display_models.put("custom", last.getModel());
        this.display_button_group.add(last);
        view_menu.addSeparator();
        view_menu.add((Action)this.theActionManager.get("orientation"));
        view_menu.addSeparator();
        view_menu.add((Action)this.theActionManager.get("displaysettings"));
        view_menu.add((Action)this.theActionManager.get("reportsettings"));
        return view_menu;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.createFileMenu());
        menubar.add(this.createEditMenu());
        menubar.add(this.createViewMenu());
        return menubar;
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.theActionManager.get("zoomnone"));
        menu.add((Action)this.theActionManager.get("zoomin"));
        menu.add((Action)this.theActionManager.get("zoomout"));
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("cut"));
        menu.add((Action)this.theActionManager.get("copy"));
        menu.add((Action)this.theActionManager.get("delete"));
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("enlarge"));
        menu.add((Action)this.theActionManager.get("resetsize"));
        menu.add((Action)this.theActionManager.get("shrink"));
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("highlight"));
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("group"));
        menu.add((Action)this.theActionManager.get("ungroup"));
        return menu;
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("open"));
        toolbar.add((Action)this.theActionManager.get("save"));
        toolbar.add((Action)this.theActionManager.get("saveas"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("print"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("undo"));
        toolbar.add((Action)this.theActionManager.get("redo"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("cut"));
        toolbar.add((Action)this.theActionManager.get("copy"));
        toolbar.add((Action)this.theActionManager.get("delete"));
        toolbar.add((Action)this.theActionManager.get("screenshot"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("enlarge"));
        toolbar.add((Action)this.theActionManager.get("resetsize"));
        toolbar.add((Action)this.theActionManager.get("shrink"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("highlight"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("zoomnone"));
        toolbar.add((Action)this.theActionManager.get("zoomin"));
        toolbar.add((Action)this.theActionManager.get("zoomout"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("orientation"));
        return toolbar;
    }

    public void onZoomNone() {
        this.theCanvas.setScale(1.0);
    }

    public void onZoomIn() {
        this.theCanvas.setScale(this.theCanvas.getScale() * 1.5);
    }

    public void onZoomOut() {
        this.theCanvas.setScale(this.theCanvas.getScale() * 0.667);
    }

    public void onUndo() {
        try {
            this.theCanvas.getDocument().getUndoManager().undo();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void onRedo() {
        try {
            this.theCanvas.getDocument().getUndoManager().redo();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void onUpdate() {
        Object[] options = new String[]{"Update the report", "Update the peaklist", "Merge report and peaklist"};
        boolean UPDATE_REPORT = false;
        boolean UPDATE_PEAKLIST = true;
        int MERGE = 2;
        int option = JOptionPane.showOptionDialog(this, "Select one of the following options", "Update mode selection", 0, -1, null, options, options[0]);
        if (option == -1) {
            return;
        }
        Glycan parent = this.theCanvas.getDocument().getParentStructure();
        AnnotatedPeakList apl = this.theApplication.getWorkspace().getAnnotatedPeakList();
        int selected = -1;
        if (parent != null) {
            for (int i = 0; i < apl.getNoStructures(); ++i) {
                if (!parent.equalsStructure(apl.getStructure(i))) continue;
                if (selected == -1) {
                    selected = i;
                    continue;
                }
                selected = -1;
                break;
            }
        }
        if (selected == -1) {
            StructureSelectorDialog dlg = new StructureSelectorDialog(this, "Select parent", "Select the structure corresponding\nto the current report", apl.getStructures(), false, this.theApplication.getWorkspace().getGlycanRenderer());
            dlg.setVisible(true);
            if (dlg.isCanceled() || dlg.getSelectedIndex() == -1) {
                return;
            }
            selected = dlg.getSelectedIndex();
        }
        if (option == 0) {
            this.theCanvas.updateAnnotations(parent, apl.getPeakAnnotationCollection(selected), false);
        } else if (option == 1) {
            AnnotationReportDocument doc = this.theCanvas.getDocument();
            apl.updateAnnotations(selected, doc.getStartMZ(), doc.getEndMZ(), doc.getPeakAnnotations(), false);
        } else if (option == 2) {
            AnnotationReportDocument doc = this.theCanvas.getDocument();
            this.theCanvas.updateAnnotations(parent, apl.getPeakAnnotationCollection(selected), true);
            apl.updateAnnotations(selected, doc.getStartMZ(), doc.getEndMZ(), doc.getPeakAnnotations(), true);
        }
    }

    public void setNotation(String notation) {
        this.theCanvas.getWorkspace().setNotation(notation);
        this.theCanvas.updateView();
    }

    public void setDisplay(String display) {
        this.theCanvas.getWorkspace().setDisplay(display);
        this.theCanvas.updateView();
    }

    public void onChangeOrientation() {
        this.theCanvas.getWorkspace().getGraphicOptions().ORIENTATION = (this.theCanvas.getWorkspace().getGraphicOptions().ORIENTATION + 1) % 4;
        this.theCanvas.updateView();
    }

    private Icon getOrientationIcon() {
        int orientation = this.theCanvas.getWorkspace().getGraphicOptions().ORIENTATION;
        if (orientation == 2) {
            return FileUtils.defaultThemeManager.getImageIcon("lr");
        }
        if (orientation == 0) {
            return FileUtils.defaultThemeManager.getImageIcon("rl");
        }
        if (orientation == 3) {
            return FileUtils.defaultThemeManager.getImageIcon("tb");
        }
        if (orientation == 1) {
            return FileUtils.defaultThemeManager.getImageIcon("bt");
        }
        return null;
    }

    public void onChangeDisplaySettings() {
        GraphicOptions options = this.theCanvas.getWorkspace().getGraphicOptions();
        GraphicOptionsDialog dlg = new GraphicOptionsDialog((Frame)this, options);
        dlg.setVisible(true);
        if (dlg.getReturnStatus().equals("OK")) {
            this.theCanvas.getWorkspace().setDisplay(options.DISPLAY);
            this.display_button_group.setSelected(this.display_models.get(options.DISPLAY), true);
            this.theCanvas.getDocument().fireDocumentChanged();
        }
    }

    public void onChangeReportSettings() {
        AnnotationReportOptionsDialog dlg = new AnnotationReportOptionsDialog(this, this.theCanvas.getAnnotationReportOptions());
        dlg.setVisible(true);
        if (dlg.getReturnStatus().equals("OK")) {
            this.theCanvas.getDocument().fireDocumentChanged();
            this.thePlugin.getAnnotationReportOptions().setValues(this.theCanvas.getAnnotationReportOptions());
        }
    }

    public void updateTitle() {
        String title = FileHistory.getAbbreviatedName((String)this.theCanvas.getDocument().getFileName()) + " - Annotation report";
        if (this.theCanvas.getDocument().hasChanged()) {
            title = "* " + title;
        }
        this.setTitle(title);
    }

    public void onOpen() {
        this.theApplication.onOpen(null, this.theCanvas.getDocument(), false);
    }

    public void onSave() {
        this.theApplication.onSave(this.theCanvas.getDocument());
    }

    public void onSaveAs() {
        this.theApplication.onSaveAs(this.theCanvas.getDocument());
    }

    public void onPrint() {
        try {
            PrinterJob pj = this.theCanvas.getWorkspace().getPrinterJob();
            if (pj != null) {
                pj.setPrintable(this.theCanvas);
                if (pj.printDialog()) {
                    this.theCanvas.print(pj);
                }
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void onExportTo(String format) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(format));
        int returnVal = fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            int retValue;
            String filename = fileChooser.getSelectedFile().getAbsolutePath();
            File file = new File(filename = FileUtils.enforceExtension((String)filename, (String)format));
            if (file.exists() && (retValue = JOptionPane.showOptionDialog(this, "File exists. Overwrite file: " + filename + "?", "Salva documento", 1, 3, null, null, null)) != 0) {
                return;
            }
            try {
                SVGUtils.export((String)filename, (SVGUtils.Renderable)this.theCanvas, (String)format);
            }
            catch (Exception e) {
                LogUtils.report((Exception)e);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = GlycanAction.getAction((ActionEvent)e);
        String param = GlycanAction.getParam((ActionEvent)e);
        if (action.equals("export")) {
            this.onExportTo(param);
        } else if (action.equals("open")) {
            this.onOpen();
        } else if (action.equals("save")) {
            this.onSave();
        } else if (action.equals("saveas")) {
            this.onSaveAs();
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("close")) {
            this.setVisible(false);
        } else if (action.equals("undo")) {
            this.onUndo();
        } else if (action.equals("redo")) {
            this.onRedo();
        } else if (action.equals("cut")) {
            this.theCanvas.cut();
        } else if (action.equals("copy")) {
            this.theCanvas.copy();
        } else if (action.equals("delete")) {
            this.theCanvas.delete();
        } else if (action.equals("screenshot")) {
            this.theCanvas.getScreenshot();
        } else if (action.equals("update")) {
            this.onUpdate();
        } else if (action.equals("selectall")) {
            this.theCanvas.selectAll();
        } else if (action.equals("selectnone")) {
            this.theCanvas.resetSelection();
        } else if (action.equals("enlarge")) {
            this.theCanvas.rescaleSelections(1.2);
        } else if (action.equals("resetsize")) {
            this.theCanvas.resetSelectionsScale();
        } else if (action.equals("shrink")) {
            this.theCanvas.rescaleSelections(0.8333333333333334);
        } else if (action.equals("highlight")) {
            this.theCanvas.highlightSelections();
        } else if (action.equals("group")) {
            this.theCanvas.groupSelections();
        } else if (action.equals("ungroup")) {
            this.theCanvas.ungroupSelections();
        } else if (action.equals("placestructures")) {
            this.theCanvas.placeStructures();
        }
        if (action.equals("zoomnone")) {
            this.onZoomNone();
        } else if (action.equals("zoomin")) {
            this.onZoomIn();
        } else if (action.equals("zoomout")) {
            this.onZoomOut();
        } else if (action.equals("notation")) {
            this.setNotation(param);
        } else if (action.equals("display")) {
            this.setDisplay(param);
        } else if (action.equals("displaysettings")) {
            this.onChangeDisplaySettings();
        } else if (action.equals("reportsettings")) {
            this.onChangeReportSettings();
        } else if (action.equals("orientation")) {
            this.onChangeOrientation();
        }
        this.updateActions();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (MouseUtils.isPopupTrigger((MouseEvent)e)) {
            this.theCanvas.enforceSelection(e.getPoint());
            this.createPopupMenu().show(this.theCanvas, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (MouseUtils.isPopupTrigger((MouseEvent)e)) {
            this.theCanvas.enforceSelection(e.getPoint());
            this.createPopupMenu().show(this.theCanvas, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void selectionChanged(AnnotationReportCanvas.SelectionChangeEvent e) {
        this.updateActions();
    }

    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        this.updateTitle();
        this.updateActions();
    }

    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        this.updateTitle();
        this.updateActions();
    }
}

